/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.queue;

import com.google.common.base.Preconditions;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.recipes.queue.DistributedQueue;
import com.netflix.curator.framework.recipes.queue.MultiItem;
import com.netflix.curator.framework.recipes.queue.QueueConsumer;
import com.netflix.curator.framework.recipes.queue.QueueSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class DistributedPriorityQueue<T>
implements Closeable {
    private final DistributedQueue<T> queue;

    DistributedPriorityQueue(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath, ThreadFactory threadFactory, Executor executor, int minItemsBeforeRefresh, String lockPath) {
        Preconditions.checkArgument((minItemsBeforeRefresh >= 0 ? 1 : 0) != 0);
        this.queue = new DistributedQueue<T>(client, consumer, serializer, queuePath, threadFactory, executor, minItemsBeforeRefresh, true, lockPath);
    }

    public void start() throws Exception {
        this.queue.start();
    }

    @Override
    public void close() throws IOException {
        this.queue.close();
    }

    public void put(T item, int priority) throws Exception {
        this.queue.checkState();
        String priorityHex = this.priorityToString(priority);
        this.queue.internalPut(item, null, this.queue.makeItemPath() + priorityHex);
    }

    public void putMulti(MultiItem<T> items, int priority) throws Exception {
        this.queue.checkState();
        String priorityHex = this.priorityToString(priority);
        this.queue.internalPut(null, items, this.queue.makeItemPath() + priorityHex);
    }

    public static String defaultPriorityToString(int priority) {
        long l = (long)priority & 0xFFFFFFFFL;
        return String.format("%s%08X", priority >= 0 ? "1" : "0", l);
    }

    protected String priorityToString(int priority) {
        return DistributedPriorityQueue.defaultPriorityToString(priority);
    }
}

