/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.queue;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.recipes.queue.DistributedPriorityQueue;
import com.netflix.curator.framework.recipes.queue.DistributedQueue;
import com.netflix.curator.framework.recipes.queue.QueueConsumer;
import com.netflix.curator.framework.recipes.queue.QueueSerializer;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class QueueBuilder<T> {
    private final CuratorFramework client;
    private final QueueConsumer<T> consumer;
    private final QueueSerializer<T> serializer;
    private final String queuePath;
    private ThreadFactory factory;
    private Executor executor;
    private String lockPath;
    private static final ThreadFactory defaultThreadFactory = new ThreadFactoryBuilder().setNameFormat("QueueBuilder-%d").build();

    public static <T> QueueBuilder<T> builder(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath) {
        return new QueueBuilder<T>(client, consumer, serializer, queuePath);
    }

    public DistributedQueue<T> buildQueue() {
        return new DistributedQueue<T>(this.client, this.consumer, this.serializer, this.queuePath, this.factory, this.executor, Integer.MAX_VALUE, false, this.lockPath);
    }

    public DistributedPriorityQueue<T> buildPriorityQueue(int minItemsBeforeRefresh) {
        return new DistributedPriorityQueue<T>(this.client, this.consumer, this.serializer, this.queuePath, this.factory, this.executor, minItemsBeforeRefresh, this.lockPath);
    }

    public QueueBuilder<T> threadFactory(ThreadFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        this.factory = factory;
        return this;
    }

    public QueueBuilder<T> executor(Executor executor) {
        Preconditions.checkNotNull((Object)executor);
        this.executor = executor;
        return this;
    }

    public QueueBuilder<T> lockPath(String path) {
        this.lockPath = path;
        return this;
    }

    private QueueBuilder(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath) {
        this.client = client;
        this.consumer = consumer;
        this.serializer = serializer;
        this.queuePath = queuePath;
        this.factory = defaultThreadFactory;
        this.executor = MoreExecutors.sameThreadExecutor();
    }
}

