/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.atomic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.recipes.atomic.AtomicStats;
import com.netflix.curator.framework.recipes.atomic.AtomicValue;
import com.netflix.curator.framework.recipes.atomic.DistributedAtomicNumber;
import com.netflix.curator.framework.recipes.atomic.DistributedAtomicValue;
import com.netflix.curator.framework.recipes.atomic.MakeValue;
import com.netflix.curator.framework.recipes.atomic.PromotedToLock;
import java.nio.ByteBuffer;

public class DistributedAtomicLong
implements DistributedAtomicNumber<Long> {
    private final DistributedAtomicValue value;

    public DistributedAtomicLong(CuratorFramework client, String counterPath, RetryPolicy retryPolicy) {
        this(client, counterPath, retryPolicy, null);
    }

    public DistributedAtomicLong(CuratorFramework client, String counterPath, RetryPolicy retryPolicy, PromotedToLock promotedToLock) {
        this.value = new DistributedAtomicValue(client, counterPath, retryPolicy, promotedToLock);
    }

    @Override
    public AtomicValue<Long> get() throws Exception {
        return new AtomicLong(this.value.get());
    }

    @Override
    public void forceSet(Long newValue) throws Exception {
        this.value.forceSet(this.valueToBytes(newValue));
    }

    @Override
    public AtomicValue<Long> compareAndSet(Long expectedValue, Long newValue) throws Exception {
        return new AtomicLong(this.value.compareAndSet(this.valueToBytes(expectedValue), this.valueToBytes(newValue)));
    }

    @Override
    public AtomicValue<Long> trySet(Long newValue) throws Exception {
        return new AtomicLong(this.value.trySet(this.valueToBytes(newValue)));
    }

    @Override
    public AtomicValue<Long> increment() throws Exception {
        return this.worker(1L);
    }

    @Override
    public AtomicValue<Long> decrement() throws Exception {
        return this.worker(-1L);
    }

    @Override
    public AtomicValue<Long> add(Long delta) throws Exception {
        return this.worker(delta);
    }

    @Override
    public AtomicValue<Long> subtract(Long delta) throws Exception {
        return this.worker(-1L * delta);
    }

    @VisibleForTesting
    byte[] valueToBytes(Long newValue) {
        Preconditions.checkNotNull((Object)newValue, (Object)"newValue cannot be null");
        byte[] newData = new byte[8];
        ByteBuffer wrapper = ByteBuffer.wrap(newData);
        wrapper.putLong(newValue);
        return newData;
    }

    @VisibleForTesting
    long bytesToValue(byte[] data) {
        if (data == null || data.length == 0) {
            return 0L;
        }
        ByteBuffer wrapper = ByteBuffer.wrap(data);
        return wrapper.getLong();
    }

    private AtomicValue<Long> worker(final Long addAmount) throws Exception {
        Preconditions.checkNotNull((Object)addAmount, (Object)"addAmount cannot be null");
        MakeValue makeValue = new MakeValue(){

            @Override
            public byte[] makeFrom(byte[] previous) {
                long previousValue = previous != null ? DistributedAtomicLong.this.bytesToValue(previous) : 0L;
                long newValue = previousValue + addAmount;
                return DistributedAtomicLong.this.valueToBytes(newValue);
            }
        };
        AtomicValue<byte[]> result = this.value.trySet(makeValue);
        return new AtomicLong(result);
    }

    private class AtomicLong
    implements AtomicValue<Long> {
        private AtomicValue<byte[]> bytes;

        private AtomicLong(AtomicValue<byte[]> bytes) {
            this.bytes = bytes;
        }

        @Override
        public boolean succeeded() {
            return this.bytes.succeeded();
        }

        @Override
        public Long preValue() {
            return DistributedAtomicLong.this.bytesToValue(this.bytes.preValue());
        }

        @Override
        public Long postValue() {
            return DistributedAtomicLong.this.bytesToValue(this.bytes.postValue());
        }

        @Override
        public AtomicStats getStats() {
            return this.bytes.getStats();
        }
    }
}

