/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.locks;

import com.google.common.base.Preconditions;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.recipes.locks.InterProcessLock;
import com.netflix.curator.framework.recipes.locks.InterProcessSemaphore;
import com.netflix.curator.framework.recipes.locks.Lease;
import java.util.concurrent.TimeUnit;

public class InterProcessSemaphoreMutex
implements InterProcessLock {
    private final InterProcessSemaphore semaphore;
    private volatile Lease lease;

    public InterProcessSemaphoreMutex(CuratorFramework client, String path) {
        this.semaphore = new InterProcessSemaphore(client, path, 1);
    }

    @Override
    public void acquire() throws Exception {
        this.lease = this.semaphore.acquire();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        Lease acquiredLease = this.semaphore.acquire(time, unit);
        if (acquiredLease == null) {
            return false;
        }
        this.lease = acquiredLease;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws Exception {
        Preconditions.checkState((this.lease != null ? 1 : 0) != 0, (Object)"Not acquired");
        try {
            this.lease.close();
        }
        finally {
            this.lease = null;
        }
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.lease != null;
    }
}

