/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.Auto;
import com.netflix.discovery.converters.StringCache;
import com.netflix.discovery.converters.envelope.ApplicationEnvelope;
import com.netflix.discovery.converters.envelope.ApplicationsEnvelope;
import com.netflix.discovery.converters.envelope.InstanceInfoEnvelope;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaJacksonCodec {
    private static final Logger logger = LoggerFactory.getLogger(EurekaJacksonCodec.class);
    private static final Version VERSION = new Version(1, 1, 0, null);
    public static final String NODE_LEASE = "leaseInfo";
    public static final String NODE_METADATA = "metadata";
    public static final String NODE_DATACENTER = "dataCenterInfo";
    public static final String NODE_INSTANCE = "instance";
    public static final String NODE_APP = "application";
    public static final String NODE_APPS = "applications";
    private static final String ELEM_INSTANCE = "instance";
    private static final String ELEM_OVERRIDDEN_STATUS = "overriddenstatus";
    private static final String ELEM_HOST = "hostName";
    private static final String ELEM_APP = "app";
    private static final String ELEM_IP = "ipAddr";
    private static final String ELEM_SID = "sid";
    private static final String ELEM_STATUS = "status";
    private static final String ELEM_PORT = "port";
    private static final String ELEM_SECURE_PORT = "securePort";
    private static final String ELEM_COUNTRY_ID = "countryId";
    private static final String ELEM_IDENTIFYING_ATTR = "identifyingAttribute";
    private static final String ELEM_HEALTHCHECKURL = "healthCheckUrl";
    private static final String ELEM_SECHEALTHCHECKURL = "secureHealthCheckUrl";
    private static final String ELEM_APPGROUPNAME = "appGroupName";
    private static final String ELEM_HOMEPAGEURL = "homePageUrl";
    private static final String ELEM_STATUSPAGEURL = "statusPageUrl";
    private static final String ELEM_VIPADDRESS = "vipAddress";
    private static final String ELEM_SECVIPADDRESS = "secureVipAddress";
    private static final String ELEM_ISCOORDINATINGDISCSOERVER = "isCoordinatingDiscoveryServer";
    private static final String ELEM_LASTUPDATEDTS = "lastUpdatedTimestamp";
    private static final String ELEM_LASTDIRTYTS = "lastDirtyTimestamp";
    private static final String ELEM_ACTIONTYPE = "actionType";
    private static final String ELEM_ASGNAME = "asgName";
    private static final String ELEM_NAME = "name";
    private static final String DATACENTER_METADATA = "metadata";
    private static final String VERSIONS_DELTA_TEMPLATE = "versions_delta";
    private static final String APPS_HASHCODE_TEMPTE = "apps_hashcode";
    public static final EurekaJacksonCodec INSTANCE = new EurekaJacksonCodec();
    private final String versionDeltaKey;
    private final String appHashCodeKey;
    private final StringCache cache = new StringCache();
    private final ObjectMapper mapper;

    public EurekaJacksonCodec() {
        this.versionDeltaKey = EurekaJacksonCodec.formatKey(VERSIONS_DELTA_TEMPLATE);
        this.appHashCodeKey = EurekaJacksonCodec.formatKey(APPS_HASHCODE_TEMPTE);
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("eureka1.x", VERSION);
        module.addSerializer(DataCenterInfo.class, (JsonSerializer)new DataCenterInfoSerializer());
        module.addSerializer(InstanceInfo.class, (JsonSerializer)new InstanceInfoSerializer());
        module.addSerializer(Application.class, (JsonSerializer)new ApplicationSerializer());
        module.addSerializer(Applications.class, (JsonSerializer)new ApplicationsSerializer());
        module.addDeserializer(DataCenterInfo.class, (JsonDeserializer)new DataCenterInfoDeserializer());
        module.addDeserializer(LeaseInfo.class, (JsonDeserializer)new LeaseInfoDeserializer());
        module.addDeserializer(InstanceInfo.class, (JsonDeserializer)new InstanceInfoDeserializer(this.cache));
        module.addDeserializer(InstanceInfoEnvelope.class, (JsonDeserializer)new InstanceInfoEnvelopeDeserializer());
        module.addDeserializer(Application.class, (JsonDeserializer)new ApplicationDeserializer());
        module.addDeserializer(Applications.class, (JsonDeserializer)new ApplicationsDeserializer());
        this.mapper.registerModule((Module)module);
    }

    private static String formatKey(String keyTemplate) {
        EurekaClientConfig clientConfig = DiscoveryManager.getInstance().getEurekaClientConfig();
        String replacement = clientConfig == null ? "__" : clientConfig.getEscapeCharReplacement();
        StringBuilder sb = new StringBuilder(keyTemplate.length() + 1);
        for (char c : keyTemplate.toCharArray()) {
            if (c == '_') {
                sb.append(replacement);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public <T> T readFrom(Class<T> type, InputStream entityStream) throws IOException {
        return (T)this.mapper.readValue(entityStream, type);
    }

    public <T> T readFromEnvelope(Class<T> type, InputStream entityStream) throws IOException {
        if (type.isAssignableFrom(Applications.class)) {
            return (T)this.readFrom(ApplicationsEnvelope.class, entityStream).getApplications();
        }
        if (type.isAssignableFrom(Application.class)) {
            return (T)this.readFrom(ApplicationEnvelope.class, entityStream).getApplication();
        }
        if (type.isAssignableFrom(InstanceInfo.class)) {
            return (T)this.readFrom(InstanceInfoEnvelope.class, entityStream).getInstance();
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    public <T> void writeTo(T object, OutputStream entityStream) throws IOException {
        this.mapper.writeValue(entityStream, object);
    }

    public <T> String writeToString(T object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot encode provided object", e);
        }
    }

    public <T> void writeWithEnvelopeTo(T object, OutputStream entityStream) {
        Object toEncode;
        if (object instanceof Applications) {
            toEncode = new ApplicationsEnvelope((Applications)object);
        } else if (object instanceof Application) {
            toEncode = new ApplicationEnvelope((Application)object);
        } else if (object instanceof InstanceInfo) {
            toEncode = new InstanceInfoEnvelope((InstanceInfo)object);
        } else {
            throw new IllegalArgumentException("Unsupported type " + object.getClass());
        }
        try {
            this.mapper.writeValue(entityStream, toEncode);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot encode provided object", e);
        }
    }

    public static EurekaJacksonCodec getInstance() {
        return INSTANCE;
    }

    private class ApplicationsDeserializer
    extends JsonDeserializer<Applications> {
        private ApplicationsDeserializer() {
        }

        public Applications deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonNode appNode;
            Applications apps = new Applications();
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.get(EurekaJacksonCodec.this.versionDeltaKey) != null) {
                apps.setVersion(node.get(EurekaJacksonCodec.this.versionDeltaKey).asLong());
            }
            if (node.get(EurekaJacksonCodec.this.appHashCodeKey) != null) {
                apps.setAppsHashCode(node.get(EurekaJacksonCodec.this.appHashCodeKey).asText());
            }
            if ((appNode = node.get(EurekaJacksonCodec.NODE_APP)) != null) {
                if (appNode instanceof ArrayNode) {
                    ArrayNode appsNode = (ArrayNode)appNode;
                    for (JsonNode item : appsNode) {
                        apps.addApplication((Application)EurekaJacksonCodec.this.mapper.treeToValue((TreeNode)item, Application.class));
                    }
                } else {
                    apps.addApplication((Application)EurekaJacksonCodec.this.mapper.treeToValue((TreeNode)appNode, Application.class));
                }
            }
            return apps;
        }
    }

    private class ApplicationsSerializer
    extends JsonSerializer<Applications> {
        private ApplicationsSerializer() {
        }

        public void serialize(Applications applications, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(EurekaJacksonCodec.this.versionDeltaKey, applications.getVersion().toString());
            jgen.writeStringField(EurekaJacksonCodec.this.appHashCodeKey, applications.getAppsHashCode());
            jgen.writeObjectField(EurekaJacksonCodec.NODE_APP, applications.getRegisteredApplications());
        }
    }

    private class ApplicationDeserializer
    extends JsonDeserializer<Application> {
        private ApplicationDeserializer() {
        }

        public Application deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String name = EurekaJacksonCodec.this.cache.cachedValueOf(node.get(EurekaJacksonCodec.ELEM_NAME).asText());
            Application application = new Application(name);
            JsonNode instanceNode = node.get("instance");
            if (instanceNode != null) {
                if (instanceNode instanceof ArrayNode) {
                    ArrayNode instancesNode = (ArrayNode)instanceNode;
                    if (instancesNode != null) {
                        for (JsonNode nextNode : instancesNode) {
                            application.addInstance((InstanceInfo)EurekaJacksonCodec.this.mapper.treeToValue((TreeNode)nextNode, InstanceInfo.class));
                        }
                    }
                } else {
                    application.addInstance((InstanceInfo)EurekaJacksonCodec.this.mapper.treeToValue((TreeNode)instanceNode, InstanceInfo.class));
                }
            }
            return application;
        }
    }

    private static class ApplicationSerializer
    extends JsonSerializer<Application> {
        private ApplicationSerializer() {
        }

        public void serialize(Application value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField(EurekaJacksonCodec.ELEM_NAME, value.getName());
            jgen.writeObjectField("instance", value.getInstances());
            jgen.writeEndObject();
        }
    }

    private class InstanceInfoDeserializer
    extends JsonDeserializer<InstanceInfo> {
        private final StringCache cache;

        private InstanceInfoDeserializer(StringCache cache) {
            this.cache = cache;
        }

        public InstanceInfo deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder();
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String healthChecUrl = null;
            String healthCheckSecureUrl = null;
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode fieldNode = node.get(fieldName);
                if (fieldNode.isNull()) continue;
                if (EurekaJacksonCodec.ELEM_HOST.equals(fieldName)) {
                    builder.setHostName(fieldNode.asText());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_APP.equals(fieldName)) {
                    builder.setAppName(this.cache.cachedValueOf(fieldNode.asText()));
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_IP.equals(fieldName)) {
                    builder.setIPAddr(fieldNode.asText());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_SID.equals(fieldName)) {
                    builder.setSID(this.cache.cachedValueOf(fieldNode.asText()));
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_IDENTIFYING_ATTR.equals(fieldName)) continue;
                if (EurekaJacksonCodec.ELEM_STATUS.equals(fieldName)) {
                    builder.setStatus(InstanceInfo.InstanceStatus.toEnum(fieldNode.asText()));
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_OVERRIDDEN_STATUS.equals(fieldName)) {
                    builder.setOverriddenStatus(InstanceInfo.InstanceStatus.toEnum(fieldNode.asText()));
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_PORT.equals(fieldName)) {
                    int port = fieldNode.get("$").asInt();
                    boolean enabled = fieldNode.get("@enabled").asBoolean();
                    builder.setPort(port);
                    builder.enablePort(InstanceInfo.PortType.UNSECURE, enabled);
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_SECURE_PORT.equals(fieldName)) {
                    int port = fieldNode.get("$").asInt();
                    boolean enabled = fieldNode.get("@enabled").asBoolean();
                    builder.setSecurePort(port);
                    builder.enablePort(InstanceInfo.PortType.SECURE, enabled);
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_COUNTRY_ID.equals(fieldName)) {
                    builder.setCountryId(Integer.valueOf(fieldNode.asText()));
                    continue;
                }
                if (EurekaJacksonCodec.NODE_DATACENTER.equals(fieldName)) {
                    builder.setDataCenterInfo((DataCenterInfo)EurekaJacksonCodec.this.mapper.treeToValue((TreeNode)fieldNode, DataCenterInfo.class));
                    continue;
                }
                if (EurekaJacksonCodec.NODE_LEASE.equals(fieldName)) {
                    builder.setLeaseInfo((LeaseInfo)EurekaJacksonCodec.this.mapper.treeToValue((TreeNode)fieldNode, LeaseInfo.class));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map<String, String> meta = null;
                    Iterator metaNameIt = fieldNode.fieldNames();
                    while (metaNameIt.hasNext()) {
                        String key = this.cache.cachedValueOf((String)metaNameIt.next());
                        if (key.equals("@class")) {
                            if (meta != null || metaNameIt.hasNext()) continue;
                            meta = Collections.emptyMap();
                            continue;
                        }
                        if (meta == null) {
                            meta = new ConcurrentHashMap();
                        }
                        String value = this.cache.cachedValueOf(fieldNode.get(key).asText());
                        meta.put(key, value);
                    }
                    builder.setMetadata(meta);
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_HEALTHCHECKURL.equals(fieldName)) {
                    healthChecUrl = fieldNode.asText();
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_SECHEALTHCHECKURL.equals(fieldName)) {
                    healthCheckSecureUrl = fieldNode.asText();
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_APPGROUPNAME.equals(fieldName)) {
                    builder.setAppGroupName(fieldNode.asText());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_HOMEPAGEURL.equals(fieldName)) {
                    builder.setHomePageUrlForDeser(fieldNode.asText());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_STATUSPAGEURL.equals(fieldName)) {
                    builder.setStatusPageUrlForDeser(fieldNode.asText());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_VIPADDRESS.equals(fieldName)) {
                    builder.setVIPAddressDeser(fieldNode.asText());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_SECVIPADDRESS.equals(fieldName)) {
                    builder.setSecureVIPAddressDeser(fieldNode.asText());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_ISCOORDINATINGDISCSOERVER.equals(fieldName) || EurekaJacksonCodec.ELEM_LASTUPDATEDTS.equals(fieldName)) continue;
                if (EurekaJacksonCodec.ELEM_LASTDIRTYTS.equals(fieldName)) {
                    builder.setLastDirtyTimestamp(fieldNode.asLong());
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_ACTIONTYPE.equals(fieldName)) {
                    builder.setActionType(InstanceInfo.ActionType.valueOf(fieldNode.asText()));
                    continue;
                }
                if (EurekaJacksonCodec.ELEM_ASGNAME.equals(fieldName)) {
                    builder.setASGName(fieldNode.asText());
                    continue;
                }
                this.autoUnmarshalEligible(fieldName, fieldNode.asText(), builder.getRawInstance());
            }
            builder.setHealthCheckUrlsForDeser(healthChecUrl, healthCheckSecureUrl);
            return builder.build();
        }

        private void autoUnmarshalEligible(String fieldName, String value, Object o) {
            try {
                Class<?> c = o.getClass();
                Field f = null;
                try {
                    f = c.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
                if (f == null) {
                    return;
                }
                Auto annotation = f.getAnnotation(Auto.class);
                if (annotation == null) {
                    return;
                }
                f.setAccessible(true);
                Class<?> returnClass = f.getType();
                if (value != null) {
                    if (!String.class.equals(returnClass)) {
                        Method method = returnClass.getDeclaredMethod("valueOf", String.class);
                        Object valueObject = method.invoke(returnClass, value);
                        f.set(o, valueObject);
                    } else {
                        f.set(o, value);
                    }
                }
            }
            catch (Throwable th) {
                logger.error("Error in unmarshalling the object:", th);
            }
        }
    }

    private class InstanceInfoEnvelopeDeserializer
    extends JsonDeserializer<InstanceInfoEnvelope> {
        private InstanceInfoEnvelopeDeserializer() {
        }

        public InstanceInfoEnvelope deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            JsonNode instanceNode = node.get("instance");
            if (instanceNode == null) {
                throw new IOException("Expected field 'instance'");
            }
            return new InstanceInfoEnvelope((InstanceInfo)EurekaJacksonCodec.this.mapper.treeToValue((TreeNode)instanceNode, InstanceInfo.class));
        }
    }

    private static class InstanceInfoSerializer
    extends JsonSerializer<InstanceInfo> {
        private static final Object EMPTY_METADATA = Collections.singletonMap("@class", "java.util.Collections$EmptyMap");

        private InstanceInfoSerializer() {
        }

        public void serialize(InstanceInfo info, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map<String, String> metadata;
            jgen.writeStartObject();
            jgen.writeStringField(EurekaJacksonCodec.ELEM_HOST, info.getHostName());
            jgen.writeStringField(EurekaJacksonCodec.ELEM_APP, info.getAppName());
            jgen.writeStringField(EurekaJacksonCodec.ELEM_IP, info.getIPAddr());
            if (!"unknown".equals(info.getSID()) && !"na".equals(info.getSID())) {
                jgen.writeStringField(EurekaJacksonCodec.ELEM_SID, info.getSID());
            }
            jgen.writeStringField(EurekaJacksonCodec.ELEM_STATUS, info.getStatus().name());
            jgen.writeStringField(EurekaJacksonCodec.ELEM_OVERRIDDEN_STATUS, info.getOverriddenStatus().name());
            jgen.writeFieldName(EurekaJacksonCodec.ELEM_PORT);
            jgen.writeStartObject();
            jgen.writeNumberField("$", info.getPort());
            jgen.writeStringField("@enabled", Boolean.toString(info.isPortEnabled(InstanceInfo.PortType.UNSECURE)));
            jgen.writeEndObject();
            jgen.writeFieldName(EurekaJacksonCodec.ELEM_SECURE_PORT);
            jgen.writeStartObject();
            jgen.writeNumberField("$", info.getSecurePort());
            jgen.writeStringField("@enabled", Boolean.toString(info.isPortEnabled(InstanceInfo.PortType.SECURE)));
            jgen.writeEndObject();
            jgen.writeNumberField(EurekaJacksonCodec.ELEM_COUNTRY_ID, info.getCountryId());
            if (info.getDataCenterInfo() != null) {
                jgen.writeObjectField(EurekaJacksonCodec.NODE_DATACENTER, (Object)info.getDataCenterInfo());
            }
            if (info.getLeaseInfo() != null) {
                jgen.writeObjectField(EurekaJacksonCodec.NODE_LEASE, (Object)info.getLeaseInfo());
            }
            if ((metadata = info.getMetadata()) != null) {
                if (metadata.isEmpty()) {
                    jgen.writeObjectField("metadata", EMPTY_METADATA);
                } else {
                    jgen.writeObjectField("metadata", metadata);
                }
            }
            this.autoMarshalEligible(info, jgen);
            jgen.writeEndObject();
        }

        private void autoMarshalEligible(Object o, JsonGenerator jgen) {
            try {
                Field[] fields;
                Class<?> c = o.getClass();
                for (Field f : fields = c.getDeclaredFields()) {
                    Auto annotation = f.getAnnotation(Auto.class);
                    if (annotation == null) continue;
                    f.setAccessible(true);
                    if (f.get(o) == null) continue;
                    jgen.writeStringField(f.getName(), String.valueOf(f.get(o)));
                }
            }
            catch (Throwable th) {
                logger.error("Error in marshalling the object", th);
            }
        }
    }

    private static class LeaseInfoDeserializer
    extends JsonDeserializer<LeaseInfo> {
        private static final String ELEM_RENEW_INT = "renewalIntervalInSecs";
        private static final String ELEM_DURATION = "durationInSecs";
        private static final String ELEM_REG_TIMESTAMP = "registrationTimestamp";
        private static final String ELEM_LAST_RENEW_TIMESTAMP = "lastRenewalTimestamp";
        private static final String ELEM_EVICTION_TIMESTAMP = "evictionTimestamp";
        private static final String ELEM_SERVICE_UP_TIMESTAMP = "serviceUpTimestamp";

        private LeaseInfoDeserializer() {
        }

        public LeaseInfo deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            LeaseInfo.Builder builder = LeaseInfo.Builder.newBuilder();
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String nodeName = (String)fieldNames.next();
                if (node.get(nodeName).isNull()) continue;
                long longValue = node.get(nodeName).asLong();
                if (ELEM_DURATION.equals(nodeName)) {
                    builder.setDurationInSecs((int)longValue);
                    continue;
                }
                if (ELEM_EVICTION_TIMESTAMP.equals(nodeName)) {
                    builder.setEvictionTimestamp(longValue);
                    continue;
                }
                if (ELEM_LAST_RENEW_TIMESTAMP.equals(nodeName)) {
                    builder.setRenewalTimestamp(longValue);
                    continue;
                }
                if (ELEM_REG_TIMESTAMP.equals(nodeName)) {
                    builder.setRegistrationTimestamp(longValue);
                    continue;
                }
                if (ELEM_RENEW_INT.equals(nodeName)) {
                    builder.setRenewalIntervalInSecs((int)longValue);
                    continue;
                }
                if (!ELEM_SERVICE_UP_TIMESTAMP.equals(nodeName)) continue;
                builder.setServiceUpTimestamp(longValue);
            }
            return builder.build();
        }
    }

    private class DataCenterInfoDeserializer
    extends JsonDeserializer<DataCenterInfo> {
        private DataCenterInfoDeserializer() {
        }

        public DataCenterInfo deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            final DataCenterInfo.Name name = DataCenterInfo.Name.valueOf(node.get(EurekaJacksonCodec.ELEM_NAME).asText());
            if (name != DataCenterInfo.Name.Amazon) {
                return new DataCenterInfo(){

                    @Override
                    public DataCenterInfo.Name getName() {
                        return name;
                    }
                };
            }
            HashMap<String, String> metaData = new HashMap<String, String>();
            JsonNode metaNode = node.get("metadata");
            Iterator metaNamesIt = metaNode.fieldNames();
            while (metaNamesIt.hasNext()) {
                String key = (String)metaNamesIt.next();
                String value = metaNode.get(key).asText();
                metaData.put(EurekaJacksonCodec.this.cache.cachedValueOf(key), EurekaJacksonCodec.this.cache.cachedValueOf(value));
            }
            AmazonInfo amazonInfo = new AmazonInfo();
            amazonInfo.setMetadata(metaData);
            return amazonInfo;
        }
    }

    private static class DataCenterInfoSerializer
    extends JsonSerializer<DataCenterInfo> {
        private DataCenterInfoSerializer() {
        }

        public void serialize(DataCenterInfo dataCenterInfo, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            if (dataCenterInfo.getName() == DataCenterInfo.Name.Amazon) {
                jgen.writeStringField("@class", "com.netflix.appinfo.AmazonInfo");
            } else {
                jgen.writeStringField("@class", "com.netflix.appinfo.InstanceInfo$DefaultDataCenterInfo");
            }
            jgen.writeStringField(EurekaJacksonCodec.ELEM_NAME, dataCenterInfo.getName().name());
            if (dataCenterInfo.getName() == DataCenterInfo.Name.Amazon) {
                AmazonInfo aInfo = (AmazonInfo)dataCenterInfo;
                jgen.writeObjectField("metadata", aInfo.getMetadata());
            }
            jgen.writeEndObject();
        }
    }
}

