/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.shared.resolver.ClosableResolver;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResolver<T extends EurekaEndpoint>
implements ClosableResolver<T> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncResolver.class);
    private final AtomicBoolean warmedUp = new AtomicBoolean(false);
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final String name;
    private final ClusterResolver<T> delegate;
    private final ScheduledExecutorService executorService;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final TimedSupervisorTask backgroundTask;
    private final AtomicReference<List<T>> resultsRef;
    private final int refreshIntervalMs;
    private final int warmUpTimeoutMs;
    private volatile long lastLoadTimestamp = -1L;
    private final Runnable updateTask = new Runnable(){

        @Override
        public void run() {
            try {
                List newList = AsyncResolver.this.delegate.getClusterEndpoints();
                if (newList != null) {
                    AsyncResolver.this.resultsRef.getAndSet(newList);
                    AsyncResolver.this.lastLoadTimestamp = System.currentTimeMillis();
                } else {
                    logger.warn("Delegate returned null list of cluster endpoints");
                }
                logger.debug("Resolved to {}", newList);
            }
            catch (Exception e) {
                logger.warn("Failed to retrieve cluster endpoints from the delegate", (Throwable)e);
            }
        }
    };

    public AsyncResolver(String name, ClusterResolver<T> delegate, int executorThreadPoolSize, int refreshIntervalMs, int warmUpTimeoutMs) {
        this(name, delegate, Collections.emptyList(), executorThreadPoolSize, refreshIntervalMs, warmUpTimeoutMs);
    }

    public AsyncResolver(String name, ClusterResolver<T> delegate, List<T> initialValues, int executorThreadPoolSize, int refreshIntervalMs) {
        this(name, delegate, initialValues, executorThreadPoolSize, refreshIntervalMs, 0);
        this.warmedUp.set(true);
    }

    AsyncResolver(String name, ClusterResolver<T> delegate, List<T> initialValue, int executorThreadPoolSize, int refreshIntervalMs, int warmUpTimeoutMs) {
        this.name = name;
        this.delegate = delegate;
        this.refreshIntervalMs = refreshIntervalMs;
        this.warmUpTimeoutMs = warmUpTimeoutMs;
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("AsyncResolver-" + name + "-%d").setDaemon(true).build());
        this.threadPoolExecutor = new ThreadPoolExecutor(1, executorThreadPoolSize, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("AsyncResolver-" + name + "-executor-%d").setDaemon(true).build());
        this.backgroundTask = new TimedSupervisorTask(this.getClass().getSimpleName(), this.executorService, this.threadPoolExecutor, refreshIntervalMs, TimeUnit.MILLISECONDS, 5, this.updateTask);
        this.resultsRef = new AtomicReference<List<T>>(initialValue);
        Monitors.registerObject((String)name, (Object)this);
    }

    @Override
    public void shutdown() {
        if (Monitors.isObjectRegistered((String)this.name, (Object)this)) {
            Monitors.unregisterObject((String)this.name, (Object)this);
        }
        this.executorService.shutdown();
        this.threadPoolExecutor.shutdown();
        this.backgroundTask.cancel();
    }

    @Override
    public String getRegion() {
        return this.delegate.getRegion();
    }

    @Override
    public List<T> getClusterEndpoints() {
        long delay = this.refreshIntervalMs;
        if (this.warmedUp.compareAndSet(false, true) && !this.doWarmUp()) {
            delay = 0L;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            this.scheduleTask(delay);
        }
        return this.resultsRef.get();
    }

    boolean doWarmUp() {
        Future<?> future = null;
        try {
            future = this.threadPoolExecutor.submit(this.updateTask);
            future.get(this.warmUpTimeoutMs, TimeUnit.MILLISECONDS);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn("Best effort warm up failed", (Throwable)e);
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
        }
        return false;
    }

    void scheduleTask(long delay) {
        this.executorService.schedule(this.backgroundTask, delay, TimeUnit.MILLISECONDS);
    }

    @Monitor(name="eurekaClient.resolver.lastLoadTimestamp", description="How much time has passed from last successful async load", type=DataSourceType.GAUGE)
    public long getLastLoadTimestamp() {
        return this.lastLoadTimestamp < 0L ? 0L : System.currentTimeMillis() - this.lastLoadTimestamp;
    }

    @Monitor(name="eurekaClient.resolver.endpointsSize", description="How many records are the in the endpoints ref", type=DataSourceType.GAUGE)
    public long getEndpointsSize() {
        return this.resultsRef.get().size();
    }
}

