/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AssignableVMs;
import com.netflix.fenzo.AssignableVirtualMachine;
import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.AutoScaleAction;
import com.netflix.fenzo.AutoScaleRule;
import com.netflix.fenzo.AutoScaler;
import com.netflix.fenzo.AutoScalerInput;
import com.netflix.fenzo.DefaultFitnessCalculator;
import com.netflix.fenzo.ResAllocsEvaluater;
import com.netflix.fenzo.SchedulingResult;
import com.netflix.fenzo.StateMonitor;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTracker;
import com.netflix.fenzo.VMAssignmentResult;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.functions.Action2;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.sla.ResAllocs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScheduler {
    private static final int PARALLEL_SCHED_EVAL_MIN_BATCH_SIZE = 30;
    private final AssignableVMs assignableVMs;
    private static final Logger logger = LoggerFactory.getLogger(TaskScheduler.class);
    private static final long purgeVMsIntervalSecs = 60L;
    private long lastVMPurgeAt = System.currentTimeMillis();
    private final Builder builder;
    private final StateMonitor stateMonitor;
    private final AutoScaler autoScaler;
    private final int EXEC_SVC_THREADS = Runtime.getRuntime().availableProcessors();
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.EXEC_SVC_THREADS);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final ResAllocsEvaluater resAllocsEvaluator;

    private TaskScheduler(Builder builder) {
        if (builder.leaseRejectAction == null) {
            throw new IllegalArgumentException("Lease reject action must be non-null");
        }
        this.builder = builder;
        this.stateMonitor = new StateMonitor();
        TaskTracker taskTracker = new TaskTracker();
        this.resAllocsEvaluator = new ResAllocsEvaluater(taskTracker, builder.resAllocs);
        this.assignableVMs = new AssignableVMs(taskTracker, builder.leaseRejectAction, builder.leaseOfferExpirySecs, builder.maxOffersToReject, builder.autoScaleByAttributeName, builder.singleOfferMode);
        if (builder.autoScaleByAttributeName != null && !builder.autoScaleByAttributeName.isEmpty()) {
            this.autoScaler = new AutoScaler(builder.autoScaleByAttributeName, builder.autoScalerMapHostnameAttributeName, builder.autoScaleDownBalancedByAttributeName, builder.autoScaleRules, this.assignableVMs, null, builder.disableShortfallEvaluation, this.assignableVMs.getActiveVmGroups());
            if (builder.autoscalerCallback != null) {
                this.autoScaler.setCallback(builder.autoscalerCallback);
            }
            if (builder.delayAutoscaleDownBySecs > 0L) {
                this.autoScaler.setDelayScaleDownBySecs(builder.delayAutoscaleDownBySecs);
            }
            if (builder.delayAutoscaleUpBySecs > 0L) {
                this.autoScaler.setDelayScaleUpBySecs(builder.delayAutoscaleUpBySecs);
            }
        } else {
            this.autoScaler = null;
        }
    }

    private void checkIfShutdown() throws IllegalStateException {
        if (this.isShutdown.get()) {
            throw new IllegalStateException("TaskScheduler already shutdown");
        }
    }

    public void setAutoscalerCallback(Action1<AutoScaleAction> callback) throws IllegalStateException {
        this.checkIfShutdown();
        if (this.autoScaler == null) {
            throw new IllegalStateException("No autoScaler setup");
        }
        this.autoScaler.setCallback(callback);
    }

    private TaskAssignmentResult getSuccessfulResult(List<TaskAssignmentResult> results) {
        double bestFitness = 0.0;
        TaskAssignmentResult bestResult = null;
        for (int r = results.size() - 1; r >= 0; --r) {
            TaskAssignmentResult res = results.get(r);
            if (res == null || !res.isSuccessful() || bestResult != null && !(res.getFitness() > bestFitness)) continue;
            bestFitness = res.getFitness();
            bestResult = res;
        }
        return bestResult;
    }

    private boolean isGoodEnough(TaskAssignmentResult result) {
        return (Boolean)this.builder.isFitnessGoodEnoughFunction.call(result.getFitness());
    }

    public Map<String, ResAllocs> getResAllocs() {
        return this.resAllocsEvaluator.getResAllocs();
    }

    public void addOrReplaceResAllocs(ResAllocs resAllocs) {
        this.resAllocsEvaluator.replaceResAllocs(resAllocs);
    }

    public void removeResAllocs(String groupName) {
        this.resAllocsEvaluator.remResAllocs(groupName);
    }

    public Collection<AutoScaleRule> getAutoScaleRules() {
        if (this.autoScaler == null) {
            return Collections.emptyList();
        }
        return this.autoScaler.getRules();
    }

    public void addOrReplaceAutoScaleRule(AutoScaleRule rule) {
        this.autoScaler.replaceRule(rule);
    }

    public void removeAutoScaleRule(String ruleName) {
        this.autoScaler.removeRule(ruleName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SchedulingResult scheduleOnce(List<? extends TaskRequest> requests, List<VirtualMachineLease> newLeases) throws IllegalStateException {
        this.checkIfShutdown();
        try (AutoCloseable ac = this.stateMonitor.enter();){
            long start = System.currentTimeMillis();
            SchedulingResult schedulingResult = this.doSchedule(requests, newLeases);
            if (this.lastVMPurgeAt + 60000L < System.currentTimeMillis()) {
                this.lastVMPurgeAt = System.currentTimeMillis();
                logger.info("Purging inactive VMs");
                this.assignableVMs.purgeInactiveVMs();
            }
            schedulingResult.setRuntime(System.currentTimeMillis() - start);
            SchedulingResult schedulingResult2 = schedulingResult;
            return schedulingResult2;
        }
        catch (Exception e) {
            logger.error("Error with scheduling run: " + e.getMessage(), (Throwable)e);
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            logger.warn("Unexpected exception: " + e.getMessage());
            throw new IllegalStateException("Unexpected exception during scheduling run: " + e.getMessage(), e);
        }
    }

    private SchedulingResult doSchedule(List<? extends TaskRequest> requests, List<VirtualMachineLease> newLeases) {
        AtomicInteger rejectedCount = new AtomicInteger();
        List<AssignableVirtualMachine> avms = this.assignableVMs.prepareAndGetOrderedVMs(newLeases, rejectedCount);
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + avms.size() + " VMs with non-zero offers to assign from");
        }
        boolean hasResAllocs = this.resAllocsEvaluator.prepare();
        int totalNumAllocations = 0;
        HashSet<TaskRequest> failedTasksForAutoScaler = new HashSet<TaskRequest>(requests);
        HashMap<String, VMAssignmentResult> resultMap = new HashMap<String, VMAssignmentResult>(avms.size());
        SchedulingResult schedulingResult = new SchedulingResult(resultMap);
        if (!avms.isEmpty()) {
            for (final TaskRequest taskRequest : requests) {
                Object maxResourceFailure;
                List<TaskAssignmentResult> failures;
                if (hasResAllocs) {
                    if (this.resAllocsEvaluator.taskGroupFailed(taskRequest.taskGroupName())) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Resource allocation limits reached for task: " + taskRequest.getId());
                        continue;
                    }
                    AssignmentFailure resAllocsFailure = this.resAllocsEvaluator.hasResAllocs(taskRequest);
                    if (resAllocsFailure != null) {
                        failures = Collections.singletonList(new TaskAssignmentResult(this.assignableVMs.getDummyVM(), taskRequest, false, Collections.singletonList(resAllocsFailure), null, 0.0));
                        schedulingResult.addFailures(taskRequest, failures);
                        failedTasksForAutoScaler.remove(taskRequest);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Resource allocation limit reached for task " + taskRequest.getId() + ": " + resAllocsFailure);
                        continue;
                    }
                }
                if ((maxResourceFailure = this.assignableVMs.getFailedMaxResource(null, taskRequest)) != null) {
                    failures = Collections.singletonList(new TaskAssignmentResult(this.assignableVMs.getDummyVM(), taskRequest, false, Collections.singletonList(maxResourceFailure), null, 0.0));
                    schedulingResult.addFailures(taskRequest, failures);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Task " + taskRequest.getId() + ": maxResource failure: " + maxResourceFailure);
                    continue;
                }
                final ArrayBlockingQueue<AssignableVirtualMachine> virtualMachines = new ArrayBlockingQueue<AssignableVirtualMachine>(avms.size(), false, avms);
                int nThreads = (int)Math.ceil((double)avms.size() / 30.0);
                ArrayList<Future<EvalResult>> futures = new ArrayList<Future<EvalResult>>();
                if (logger.isDebugEnabled()) {
                    logger.debug("Launching " + nThreads + " threads for evaluating assignments for task " + taskRequest.getId());
                }
                for (int b = 0; b < nThreads && b < this.EXEC_SVC_THREADS; ++b) {
                    futures.add(this.executorService.submit(new Callable<EvalResult>(){

                        @Override
                        public EvalResult call() throws Exception {
                            return TaskScheduler.this.evalAssignments(taskRequest, virtualMachines);
                        }
                    }));
                }
                ArrayList<EvalResult> results = new ArrayList<EvalResult>();
                ArrayList<TaskAssignmentResult> bestResults = new ArrayList<TaskAssignmentResult>();
                for (Future future : futures) {
                    try {
                        EvalResult evalResult = (EvalResult)future.get();
                        if (evalResult.exception != null) {
                            logger.warn("Error during concurrent task assignment eval - " + evalResult.exception.getMessage(), (Throwable)evalResult.exception);
                            schedulingResult.addException(evalResult.exception);
                            continue;
                        }
                        results.add(evalResult);
                        bestResults.add(evalResult.result);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Task " + taskRequest.getId() + ": best result so far: " + evalResult.result);
                        }
                        totalNumAllocations += evalResult.numAllocationTrials;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        logger.error("Unexpected during concurrent task assignment eval - " + e.getMessage(), (Throwable)e);
                    }
                }
                if (!schedulingResult.getExceptions().isEmpty()) break;
                TaskAssignmentResult successfulResult = this.getSuccessfulResult(bestResults);
                ArrayList<TaskAssignmentResult> arrayList = new ArrayList<TaskAssignmentResult>();
                if (successfulResult == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Task " + taskRequest.getId() + ": no successful results");
                    }
                    for (EvalResult er : results) {
                        arrayList.addAll(er.assignmentResults);
                    }
                    schedulingResult.addFailures(taskRequest, arrayList);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Task " + taskRequest.getId() + ": found successful assignment on host " + successfulResult.getHostname());
                }
                successfulResult.assignResult();
                failedTasksForAutoScaler.remove(taskRequest);
            }
        }
        ArrayList<VirtualMachineLease> idleResourcesList = new ArrayList<VirtualMachineLease>();
        if (schedulingResult.getExceptions().isEmpty()) {
            ArrayList<VirtualMachineLease> arrayList = new ArrayList<VirtualMachineLease>();
            for (AssignableVirtualMachine avm : avms) {
                VMAssignmentResult assignmentResult = avm.resetAndGetSuccessfullyAssignedRequests();
                if (assignmentResult == null) {
                    if (!avm.hasPreviouslyAssignedTasks()) {
                        idleResourcesList.add(avm.getCurrTotalLease());
                    }
                    arrayList.add(avm.getCurrTotalLease());
                    continue;
                }
                resultMap.put(avm.getHostname(), assignmentResult);
            }
            rejectedCount.addAndGet(this.assignableVMs.removeLimitedLeases(arrayList));
            AutoScalerInput autoScalerInput = new AutoScalerInput(idleResourcesList, failedTasksForAutoScaler);
            if (this.autoScaler != null) {
                this.autoScaler.scheduleAutoscale(autoScalerInput);
            }
        }
        schedulingResult.setLeasesAdded(newLeases.size());
        schedulingResult.setLeasesRejected(rejectedCount.get());
        schedulingResult.setNumAllocations(totalNumAllocations);
        schedulingResult.setTotalVMsCount(this.assignableVMs.getTotalNumVMs());
        schedulingResult.setIdleVMsCount(idleResourcesList.size());
        return schedulingResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Map<VMResource, Double[]>> getResourceStatus() {
        try (AutoCloseable ac = this.stateMonitor.enter();){
            Map<String, Map<VMResource, Double[]>> map = this.assignableVMs.getResourceStatus();
            return map;
        }
        catch (Exception e) {
            logger.error("Unexpected error from state monitor: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<VirtualMachineCurrentState> getVmCurrentStates() throws IllegalStateException {
        try (AutoCloseable ac = this.stateMonitor.enter();){
            List<VirtualMachineCurrentState> list = this.assignableVMs.getVmCurrentStates();
            return list;
        }
        catch (Exception e) {
            logger.error("Unexpected error from state monitor: " + e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private EvalResult evalAssignments(TaskRequest task, BlockingQueue<AssignableVirtualMachine> virtualMachines) {
        try {
            int N = 10;
            ArrayList buf = new ArrayList(N);
            ArrayList<TaskAssignmentResult> results = new ArrayList<TaskAssignmentResult>();
            block2: while (true) {
                buf.clear();
                int n = virtualMachines.drainTo(buf, N);
                if (n == 0) {
                    return new EvalResult(results, this.getSuccessfulResult(results), results.size(), null);
                }
                int m = 0;
                while (true) {
                    if (m >= n) continue block2;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Evaluting task assignment on host " + ((AssignableVirtualMachine)buf.get(m)).getHostname());
                    }
                    TaskAssignmentResult result = ((AssignableVirtualMachine)buf.get(m)).tryRequest(task, this.builder.fitnessCalculator);
                    results.add(result);
                    if (result.isSuccessful() && ((Boolean)this.builder.isFitnessGoodEnoughFunction.call(result.getFitness())).booleanValue()) {
                        virtualMachines.clear();
                    }
                    ++m;
                }
                break;
            }
        }
        catch (Exception e) {
            return new EvalResult(null, null, 0, e);
        }
    }

    public void expireLease(String leaseId) throws IllegalStateException {
        this.assignableVMs.expireLease(leaseId);
    }

    public void expireAllLeases(String hostname) throws IllegalStateException {
        this.assignableVMs.expireAllLeases(hostname);
    }

    public boolean expireAllLeasesByVMId(String vmId) throws IllegalStateException {
        String hostname = this.assignableVMs.getHostnameFromVMId(vmId);
        if (hostname == null) {
            return false;
        }
        this.expireAllLeases(hostname);
        return true;
    }

    public void expireAllLeases() throws IllegalStateException {
        logger.info("Expiring all leases");
        this.assignableVMs.expireAllLeases();
    }

    public Action2<TaskRequest, String> getTaskAssigner() throws IllegalStateException {
        return new Action2<TaskRequest, String>(){

            @Override
            public void call(TaskRequest request, String hostname) {
                try (AutoCloseable ac = TaskScheduler.this.stateMonitor.enter();){
                    TaskScheduler.this.assignableVMs.setTaskAssigned(request, hostname);
                }
                catch (Exception e) {
                    logger.error("Unexpected error from state monitor: " + e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public Action2<String, String> getTaskUnAssigner() throws IllegalStateException {
        return new Action2<String, String>(){

            @Override
            public void call(String taskId, String hostname) {
                TaskScheduler.this.assignableVMs.unAssignTask(taskId, hostname);
            }
        };
    }

    public void disableVM(String hostname, long durationMillis) throws IllegalStateException {
        logger.info("Disable VM " + hostname + " for " + durationMillis + " millis");
        this.assignableVMs.disableUntil(hostname, System.currentTimeMillis() + durationMillis);
    }

    public boolean disableVMByVMId(String vmID, long durationMillis) throws IllegalStateException {
        String hostname = this.assignableVMs.getHostnameFromVMId(vmID);
        if (hostname == null) {
            return false;
        }
        this.disableVM(hostname, durationMillis);
        return true;
    }

    public void enableVM(String hostname) throws IllegalStateException {
        logger.info("Enabling VM " + hostname);
        this.assignableVMs.enableVM(hostname);
    }

    public void setActiveVmGroupAttributeName(String attributeName) {
        this.assignableVMs.setActiveVmGroupAttributeName(attributeName);
    }

    public void setActiveVmGroups(List<String> vmGroups) {
        this.assignableVMs.setActiveVmGroups(vmGroups);
    }

    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.executorService.shutdown();
            if (this.autoScaler != null) {
                this.autoScaler.shutdown();
            }
        }
    }

    private static class EvalResult {
        List<TaskAssignmentResult> assignmentResults;
        TaskAssignmentResult result;
        int numAllocationTrials;
        Exception exception;

        private EvalResult(List<TaskAssignmentResult> assignmentResults, TaskAssignmentResult result, int numAllocationTrials, Exception e) {
            this.assignmentResults = assignmentResults;
            this.result = result;
            this.numAllocationTrials = numAllocationTrials;
            this.exception = e;
        }
    }

    public static final class Builder {
        private Action1<VirtualMachineLease> leaseRejectAction = null;
        private long leaseOfferExpirySecs = 120L;
        private int maxOffersToReject = 4;
        private boolean rejectAllExpiredOffers = false;
        private VMTaskFitnessCalculator fitnessCalculator = new DefaultFitnessCalculator();
        private String autoScaleByAttributeName = null;
        private String autoScalerMapHostnameAttributeName = null;
        private String autoScaleDownBalancedByAttributeName = null;
        private Action1<AutoScaleAction> autoscalerCallback = null;
        private long delayAutoscaleUpBySecs = 0L;
        private long delayAutoscaleDownBySecs = 0L;
        private List<AutoScaleRule> autoScaleRules = new ArrayList<AutoScaleRule>();
        private Func1<Double, Boolean> isFitnessGoodEnoughFunction = new Func1<Double, Boolean>(){

            @Override
            public Boolean call(Double f) {
                return f > 1.0;
            }
        };
        private boolean disableShortfallEvaluation = false;
        private Map<String, ResAllocs> resAllocs = null;
        private boolean singleOfferMode = false;

        public Builder withLeaseRejectAction(Action1<VirtualMachineLease> leaseRejectAction) {
            this.leaseRejectAction = leaseRejectAction;
            return this;
        }

        public Builder withLeaseOfferExpirySecs(long leaseOfferExpirySecs) {
            this.leaseOfferExpirySecs = leaseOfferExpirySecs;
            return this;
        }

        public Builder withMaxOffersToReject(int maxOffersToReject) {
            if (!this.rejectAllExpiredOffers) {
                this.maxOffersToReject = maxOffersToReject;
            }
            return this;
        }

        public Builder withRejectAllExpiredOffers() {
            this.rejectAllExpiredOffers = true;
            this.maxOffersToReject = Integer.MAX_VALUE;
            return this;
        }

        public Builder withFitnessCalculator(VMTaskFitnessCalculator fitnessCalculator) {
            this.fitnessCalculator = fitnessCalculator;
            return this;
        }

        public Builder withAutoScaleByAttributeName(String name) {
            this.autoScaleByAttributeName = name;
            return this;
        }

        public Builder withAutoScalerMapHostnameAttributeName(String name) {
            this.autoScalerMapHostnameAttributeName = name;
            return this;
        }

        public Builder withAutoScaleDownBalancedByAttributeName(String name) {
            this.autoScaleDownBalancedByAttributeName = name;
            return this;
        }

        public Builder withFitnessGoodEnoughFunction(Func1<Double, Boolean> f) {
            this.isFitnessGoodEnoughFunction = f;
            return this;
        }

        public Builder disableShortfallEvaluation() {
            this.disableShortfallEvaluation = true;
            return this;
        }

        public Builder withInitialResAllocs(Map<String, ResAllocs> resAllocs) {
            this.resAllocs = resAllocs;
            return this;
        }

        public Builder withAutoScaleRule(AutoScaleRule rule) {
            if (this.autoScaleByAttributeName == null || this.autoScaleByAttributeName.isEmpty()) {
                throw new IllegalArgumentException("Auto scale by attribute name must be set before setting rules");
            }
            if (rule.getMinIdleHostsToKeep() < 1) {
                throw new IllegalArgumentException("Min Idle must be >0");
            }
            if (rule.getMinIdleHostsToKeep() > rule.getMaxIdleHostsToKeep()) {
                throw new IllegalArgumentException("Min Idle must be <= Max Idle hosts");
            }
            this.autoScaleRules.add(rule);
            return this;
        }

        public Builder withAutoScalerCallback(Action1<AutoScaleAction> callback) {
            this.autoscalerCallback = callback;
            return this;
        }

        public Builder withDelayAutoscaleUpBySecs(long delayAutoscaleUpBySecs) {
            if (delayAutoscaleUpBySecs < 0L) {
                throw new IllegalArgumentException("Delay secs can't be negative: " + delayAutoscaleUpBySecs);
            }
            this.delayAutoscaleUpBySecs = delayAutoscaleUpBySecs;
            return this;
        }

        public Builder withDelayAutoscaleDownBySecs(long delayAutoscaleDownBySecs) {
            if (delayAutoscaleDownBySecs < 0L) {
                throw new IllegalArgumentException("Delay secs can't be negative: " + delayAutoscaleDownBySecs);
            }
            this.delayAutoscaleDownBySecs = delayAutoscaleDownBySecs;
            return this;
        }

        public Builder withSingleOfferPerVM(boolean b) {
            this.singleOfferMode = b;
            return this;
        }

        public TaskScheduler build() {
            return new TaskScheduler(this);
        }
    }
}

