/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTracker;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.plugins.AttributeUtilities;
import java.util.Set;

public class UniqueHostAttrConstraint
implements ConstraintEvaluator {
    private final Func1<String, Set<String>> coTasksGetter;
    private final String hostAttributeName;
    private final String name;

    public UniqueHostAttrConstraint(Func1<String, Set<String>> coTasksGetter) {
        this(coTasksGetter, "HOSTNAME");
    }

    public UniqueHostAttrConstraint(Func1<String, Set<String>> coTasksGetter, String hostAttributeName) {
        this.coTasksGetter = coTasksGetter;
        this.hostAttributeName = hostAttributeName;
        this.name = UniqueHostAttrConstraint.class.getName() + "-" + hostAttributeName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConstraintEvaluator.Result evaluate(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        Set<String> coTasks = this.coTasksGetter.call(taskRequest.getId());
        String targetHostAttrVal = AttributeUtilities.getAttrValue(targetVM.getCurrAvailableResources(), this.hostAttributeName);
        if (targetHostAttrVal == null || targetHostAttrVal.isEmpty()) {
            return new ConstraintEvaluator.Result(false, this.hostAttributeName + " attribute unavailable on host " + targetVM.getCurrAvailableResources().hostname());
        }
        for (String coTask : coTasks) {
            TaskTracker.ActiveTask activeTask = taskTrackerState.getAllRunningTasks().get(coTask);
            if (activeTask == null) {
                activeTask = taskTrackerState.getAllCurrentlyAssignedTasks().get(coTask);
            }
            if (activeTask == null) continue;
            String usedAttrVal = AttributeUtilities.getAttrValue(activeTask.getTotalLease(), this.hostAttributeName);
            if (usedAttrVal == null || usedAttrVal.isEmpty()) {
                return new ConstraintEvaluator.Result(false, this.hostAttributeName + " attribute unavailable on host " + activeTask.getTotalLease().hostname() + " running co-task " + coTask);
            }
            if (!usedAttrVal.equals(targetHostAttrVal)) continue;
            return new ConstraintEvaluator.Result(false, this.hostAttributeName + " " + targetHostAttrVal + " already used for another co-task " + coTask);
        }
        return new ConstraintEvaluator.Result(true, "");
    }
}

