/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.providers;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.netflix.governator.providers.Advises;
import com.netflix.governator.providers.AdvisesBinder;
import com.netflix.governator.providers.ProvidesWithAdvice;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;

public final class AdvisableAnnotatedMethodScanner
extends ModuleAnnotatedMethodScanner {
    private static final AdvisableAnnotatedMethodScanner INSTANCE = new AdvisableAnnotatedMethodScanner();

    public static AdvisableAnnotatedMethodScanner scanner() {
        return INSTANCE;
    }

    public static Module asModule() {
        return new AbstractModule(){

            protected void configure() {
                this.binder().scanModulesForAnnotatedMethods((ModuleAnnotatedMethodScanner)INSTANCE);
            }
        };
    }

    private AdvisableAnnotatedMethodScanner() {
    }

    public Set<? extends Class<? extends Annotation>> annotationClasses() {
        return new HashSet<Class>(Arrays.asList(ProvidesWithAdvice.class, Advises.class));
    }

    public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
        if (annotation instanceof ProvidesWithAdvice) {
            return AdvisesBinder.getAdvisesKeyForNewItem(binder, key);
        }
        if (annotation instanceof Advises) {
            Method method = (Method)injectionPoint.getMember();
            Preconditions.checkArgument((boolean)UnaryOperator.class.isAssignableFrom(method.getReturnType()), (Object)"Return type fo @Advice method must be UnaryOperator");
            ParameterizedType unaryOperatorType = (ParameterizedType)method.getGenericReturnType();
            Type type = unaryOperatorType.getActualTypeArguments()[0];
            return AdvisesBinder.getAdviceKeyForNewItem(binder, key.ofType(type), ((Advises)annotation).order());
        }
        return key;
    }
}

