/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.providers;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import com.netflix.governator.providers.AdviceElement;
import com.netflix.governator.providers.AdviceElementImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import javax.inject.Provider;

class AdvisedProvider<T>
implements ProviderWithExtensionVisitor<T>,
HasDependencies {
    private final Set<Dependency<?>> dependencies = new HashSet();
    private final String name;
    private final Provider<T> delegate;
    private final List<ProvisionAdviceHolder<UnaryOperator<T>>> adviceBindings = new ArrayList<ProvisionAdviceHolder<UnaryOperator<T>>>();
    private final TypeLiteral<UnaryOperator<T>> advisesType;
    static Comparator<ProvisionAdviceHolder<?>> ByOrder = new Comparator<ProvisionAdviceHolder<?>>(){

        @Override
        public int compare(ProvisionAdviceHolder<?> o1, ProvisionAdviceHolder<?> o2) {
            int rv = Integer.compare(o1.order, o2.order);
            if (rv == 0) {
                return Integer.compare(System.identityHashCode(o1.hashCode()), System.identityHashCode(o2.hashCode()));
            }
            return rv;
        }
    };

    public AdvisedProvider(TypeLiteral<T> typeLiteral, String name, Annotation annotation, Provider<T> delegate) {
        this.name = name;
        this.delegate = delegate;
        this.advisesType = TypeLiteral.get((Type)Types.newParameterizedType(UnaryOperator.class, (Type[])new Type[]{typeLiteral.getType()}));
    }

    public T get() {
        return (T)this.adviceBindings.stream().map(advice -> (UnaryOperator)advice.binding.getProvider().get()).reduce(this.delegate.get(), (advised, advice) -> advice.apply(advised), (current, next) -> next);
    }

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
        return (V)visitor.visit(binding);
    }

    @Toolable
    @Inject
    protected void initialize(Injector injector) {
        for (Binding binding : injector.findBindingsByType(this.advisesType)) {
            AdviceElementImpl adviceElement;
            Key bindingKey = binding.getKey();
            if (!bindingKey.hasAttributes() || !AdviceElement.class.isAssignableFrom(bindingKey.getAnnotationType()) || !this.name.equals((adviceElement = (AdviceElementImpl)bindingKey.getAnnotation()).name())) continue;
            if (adviceElement.type() == AdviceElement.Type.ADVICE) {
                this.adviceBindings.add(new ProvisionAdviceHolder(binding, adviceElement.getOrder()));
            }
            this.dependencies.add(Dependency.get((Key)bindingKey));
        }
        this.adviceBindings.sort(ByOrder);
    }

    static class ProvisionAdviceHolder<T> {
        Binding<T> binding;
        int order;

        public ProvisionAdviceHolder(Binding<T> binding, int order) {
            this.order = order;
            this.binding = binding;
        }
    }
}

