/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.bintray;

import java.io.IOException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nebula.plugin.bintray.BintrayClientKt;
import nebula.plugin.bintray.BintrayService;
import nebula.plugin.bintray.PackageRequest;
import nebula.plugin.bintray.PublishRequest;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedSupplier;
import okhttp3.ResponseBody;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ.\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lnebula/plugin/bintray/BintrayClient;", "", "bintrayService", "Lnebula/plugin/bintray/BintrayService;", "retryConfig", "Lnebula/plugin/bintray/BintrayClient$RetryConfig;", "(Lnebula/plugin/bintray/BintrayService;Lnebula/plugin/bintray/BintrayClient$RetryConfig;)V", "getBintrayService", "()Lnebula/plugin/bintray/BintrayService;", "setBintrayService", "(Lnebula/plugin/bintray/BintrayService;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "retryPolicy", "Lnet/jodah/failsafe/RetryPolicy;", "getRetryPolicy", "()Lnet/jodah/failsafe/RetryPolicy;", "setRetryPolicy", "(Lnet/jodah/failsafe/RetryPolicy;)V", "createOrUpdatePackage", "", "subject", "", "repo", "pkg", "packageRequest", "Lnebula/plugin/bintray/PackageRequest;", "publishVersion", "version", "publishRequest", "Lnebula/plugin/bintray/PublishRequest;", "Builder", "RetryConfig", "nebula-bintray-plugin"})
public final class BintrayClient {
    @NotNull
    private RetryPolicy<Object> retryPolicy;
    private final Logger logger;
    @NotNull
    private BintrayService bintrayService;

    @NotNull
    public final RetryPolicy<Object> getRetryPolicy() {
        return this.retryPolicy;
    }

    public final void setRetryPolicy(@NotNull RetryPolicy<Object> retryPolicy) {
        Intrinsics.checkParameterIsNotNull(retryPolicy, (String)"<set-?>");
        this.retryPolicy = retryPolicy;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final void createOrUpdatePackage(@NotNull String subject, @NotNull String repo, @NotNull String pkg, @NotNull PackageRequest packageRequest) {
        Response createPackageResult2;
        Response getPackageResult2;
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)packageRequest, (String)"packageRequest");
        Response response = getPackageResult2 = (Response)Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).get(new CheckedSupplier<T>(this, subject, repo, pkg){
            final /* synthetic */ BintrayClient this$0;
            final /* synthetic */ String $subject;
            final /* synthetic */ String $repo;
            final /* synthetic */ String $pkg;

            public final Response<ResponseBody> get() {
                return this.this$0.getBintrayService().getPackage(this.$subject, this.$repo, this.$pkg).execute();
            }
            {
                this.this$0 = bintrayClient;
                this.$subject = string;
                this.$repo = string2;
                this.$pkg = string3;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"getPackageResult");
        if (response.isSuccessful()) {
            return;
        }
        if (getPackageResult2.code() != 404) {
            ResponseBody responseBody = getPackageResult2.errorBody();
            throw (Throwable)new GradleException("Could not obtain information for package " + repo + '/' + subject + '/' + pkg + " - " + (responseBody != null ? responseBody.string() : null));
        }
        Response response2 = createPackageResult2 = (Response)Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).get(new CheckedSupplier<T>(this, subject, repo, packageRequest){
            final /* synthetic */ BintrayClient this$0;
            final /* synthetic */ String $subject;
            final /* synthetic */ String $repo;
            final /* synthetic */ PackageRequest $packageRequest;

            public final Response<ResponseBody> get() {
                return this.this$0.getBintrayService().createPackage(this.$subject, this.$repo, this.$packageRequest).execute();
            }
            {
                this.this$0 = bintrayClient;
                this.$subject = string;
                this.$repo = string2;
                this.$packageRequest = packageRequest;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"createPackageResult");
        if (!response2.isSuccessful()) {
            ResponseBody responseBody = getPackageResult2.errorBody();
            throw (Throwable)new GradleException("Could not create or update information for package " + repo + '/' + subject + '/' + pkg + " - " + (responseBody != null ? responseBody.string() : null));
        }
    }

    public final void publishVersion(@NotNull String subject, @NotNull String repo, @NotNull String pkg, @NotNull String version, @NotNull PublishRequest publishRequest) {
        Response publishVersionResult2;
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)publishRequest, (String)"publishRequest");
        Response response = publishVersionResult2 = (Response)Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).get(new CheckedSupplier<T>(this, subject, repo, pkg, version, publishRequest){
            final /* synthetic */ BintrayClient this$0;
            final /* synthetic */ String $subject;
            final /* synthetic */ String $repo;
            final /* synthetic */ String $pkg;
            final /* synthetic */ String $version;
            final /* synthetic */ PublishRequest $publishRequest;

            public final Response<ResponseBody> get() {
                return this.this$0.getBintrayService().publishVersion(this.$subject, this.$repo, this.$pkg, this.$version, this.$publishRequest).execute();
            }
            {
                this.this$0 = bintrayClient;
                this.$subject = string;
                this.$repo = string2;
                this.$pkg = string3;
                this.$version = string4;
                this.$publishRequest = publishRequest;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"publishVersionResult");
        if (!response.isSuccessful()) {
            ResponseBody responseBody = publishVersionResult2.errorBody();
            throw (Throwable)new GradleException("Could not publish " + version + " version for package " + repo + '/' + subject + '/' + pkg + " - " + (responseBody != null ? responseBody.string() : null));
        }
    }

    @NotNull
    public final BintrayService getBintrayService() {
        return this.bintrayService;
    }

    public final void setBintrayService(@NotNull BintrayService bintrayService) {
        Intrinsics.checkParameterIsNotNull((Object)bintrayService, (String)"<set-?>");
        this.bintrayService = bintrayService;
    }

    public BintrayClient(@NotNull BintrayService bintrayService, @NotNull RetryConfig retryConfig) {
        Intrinsics.checkParameterIsNotNull((Object)bintrayService, (String)"bintrayService");
        Intrinsics.checkParameterIsNotNull((Object)retryConfig, (String)"retryConfig");
        this.bintrayService = bintrayService;
        this.logger = LoggerFactory.getLogger(BintrayClient.class);
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handle(IOException.class)).withDelay(Duration.ofSeconds(retryConfig.getRetryDelayInSeconds())).withMaxRetries(retryConfig.getMaxRetries()).onFailedAttempt(new CheckedConsumer<ExecutionAttemptedEvent<R>>(){

            public final void accept(ExecutionAttemptedEvent<Object> e) {
                Logger logger = this.getLogger();
                ExecutionAttemptedEvent<Object> executionAttemptedEvent = e;
                Intrinsics.checkExpressionValueIsNotNull(executionAttemptedEvent, (String)"e");
                logger.error("Trying to publish a new version to Bintray failed.", executionAttemptedEvent.getLastFailure());
            }
        }).onRetry(new CheckedConsumer<ExecutionAttemptedEvent<R>>(){

            public final void accept(ExecutionAttemptedEvent<Object> e) {
                this.getLogger().info("Retrying to publish a new version to Bintray.");
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)retryPolicy, (String)"RetryPolicy()\n          \u2026 version to Bintray.\") })");
        this.retryPolicy = retryPolicy;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003JA\u0010\"\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0007H\u00d6\u0001J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000e\u00a8\u0006("}, d2={"Lnebula/plugin/bintray/BintrayClient$Builder;", "", "user", "", "apiKey", "apiUrl", "maxRetries", "", "retryDelayInSeconds", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IJ)V", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "getApiUrl", "setApiUrl", "getMaxRetries", "()I", "setMaxRetries", "(I)V", "getRetryDelayInSeconds", "()J", "setRetryDelayInSeconds", "(J)V", "getUser", "setUser", "build", "Lnebula/plugin/bintray/BintrayClient;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "nebula-bintray-plugin"})
    public static final class Builder {
        @Nullable
        private String user;
        @Nullable
        private String apiKey;
        @Nullable
        private String apiUrl;
        private int maxRetries;
        private long retryDelayInSeconds;

        @NotNull
        public final Builder user(@NotNull String user) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.user = user;
            return builder;
        }

        @NotNull
        public final Builder apiKey(@NotNull String apiKey) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.apiKey = apiKey;
            return builder;
        }

        @NotNull
        public final Builder apiUrl(@NotNull String apiUrl) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)apiUrl, (String)"apiUrl");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.apiUrl = apiUrl;
            return builder;
        }

        @NotNull
        public final Builder maxRetries(int maxRetries) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.maxRetries = maxRetries;
            return builder;
        }

        @NotNull
        public final Builder retryDelayInSeconds(long retryDelayInSeconds) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.retryDelayInSeconds = retryDelayInSeconds;
            return builder;
        }

        @NotNull
        public final BintrayClient build() {
            String string = this.apiUrl;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = this.user;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = this.apiKey;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            return new BintrayClient(BintrayClientKt.bintray(string, string2, string3), new RetryConfig(this.maxRetries, this.retryDelayInSeconds));
        }

        @Nullable
        public final String getUser() {
            return this.user;
        }

        public final void setUser(@Nullable String string) {
            this.user = string;
        }

        @Nullable
        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(@Nullable String string) {
            this.apiKey = string;
        }

        @Nullable
        public final String getApiUrl() {
            return this.apiUrl;
        }

        public final void setApiUrl(@Nullable String string) {
            this.apiUrl = string;
        }

        public final int getMaxRetries() {
            return this.maxRetries;
        }

        public final void setMaxRetries(int n) {
            this.maxRetries = n;
        }

        public final long getRetryDelayInSeconds() {
            return this.retryDelayInSeconds;
        }

        public final void setRetryDelayInSeconds(long l) {
            this.retryDelayInSeconds = l;
        }

        public Builder(@Nullable String user, @Nullable String apiKey, @Nullable String apiUrl, int maxRetries, long retryDelayInSeconds) {
            this.user = user;
            this.apiKey = apiKey;
            this.apiUrl = apiUrl;
            this.maxRetries = maxRetries;
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        public /* synthetic */ Builder(String string, String string2, String string3, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                string3 = null;
            }
            if ((n2 & 8) != 0) {
                n = 3;
            }
            if ((n2 & 0x10) != 0) {
                l = 15L;
            }
            this(string, string2, string3, n, l);
        }

        public Builder() {
            this(null, null, null, 0, 0L, 31, null);
        }

        @Nullable
        public final String component1() {
            return this.user;
        }

        @Nullable
        public final String component2() {
            return this.apiKey;
        }

        @Nullable
        public final String component3() {
            return this.apiUrl;
        }

        public final int component4() {
            return this.maxRetries;
        }

        public final long component5() {
            return this.retryDelayInSeconds;
        }

        @NotNull
        public final Builder copy(@Nullable String user, @Nullable String apiKey, @Nullable String apiUrl, int maxRetries, long retryDelayInSeconds) {
            return new Builder(user, apiKey, apiUrl, maxRetries, retryDelayInSeconds);
        }

        @NotNull
        public static /* synthetic */ Builder copy$default(Builder builder, String string, String string2, String string3, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = builder.user;
            }
            if ((n2 & 2) != 0) {
                string2 = builder.apiKey;
            }
            if ((n2 & 4) != 0) {
                string3 = builder.apiUrl;
            }
            if ((n2 & 8) != 0) {
                n = builder.maxRetries;
            }
            if ((n2 & 0x10) != 0) {
                l = builder.retryDelayInSeconds;
            }
            return builder.copy(string, string2, string3, n, l);
        }

        @NotNull
        public String toString() {
            return "Builder(user=" + this.user + ", apiKey=" + this.apiKey + ", apiUrl=" + this.apiUrl + ", maxRetries=" + this.maxRetries + ", retryDelayInSeconds=" + this.retryDelayInSeconds + ")";
        }

        public int hashCode() {
            String string = this.user;
            String string2 = this.apiKey;
            String string3 = this.apiUrl;
            return ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + Integer.hashCode(this.maxRetries)) * 31 + Long.hashCode(this.retryDelayInSeconds);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Builder)) break block3;
                    Builder builder = (Builder)object;
                    if (!Intrinsics.areEqual((Object)this.user, (Object)builder.user) || !Intrinsics.areEqual((Object)this.apiKey, (Object)builder.apiKey) || !Intrinsics.areEqual((Object)this.apiUrl, (Object)builder.apiUrl) || !(this.maxRetries == builder.maxRetries) || !(this.retryDelayInSeconds == builder.retryDelayInSeconds)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnebula/plugin/bintray/BintrayClient$RetryConfig;", "", "maxRetries", "", "retryDelayInSeconds", "", "(IJ)V", "getMaxRetries", "()I", "getRetryDelayInSeconds", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "nebula-bintray-plugin"})
    public static final class RetryConfig {
        private final int maxRetries;
        private final long retryDelayInSeconds;

        public final int getMaxRetries() {
            return this.maxRetries;
        }

        public final long getRetryDelayInSeconds() {
            return this.retryDelayInSeconds;
        }

        public RetryConfig(int maxRetries, long retryDelayInSeconds) {
            this.maxRetries = maxRetries;
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        public final int component1() {
            return this.maxRetries;
        }

        public final long component2() {
            return this.retryDelayInSeconds;
        }

        @NotNull
        public final RetryConfig copy(int maxRetries, long retryDelayInSeconds) {
            return new RetryConfig(maxRetries, retryDelayInSeconds);
        }

        @NotNull
        public static /* synthetic */ RetryConfig copy$default(RetryConfig retryConfig, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = retryConfig.maxRetries;
            }
            if ((n2 & 2) != 0) {
                l = retryConfig.retryDelayInSeconds;
            }
            return retryConfig.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "RetryConfig(maxRetries=" + this.maxRetries + ", retryDelayInSeconds=" + this.retryDelayInSeconds + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.maxRetries) * 31 + Long.hashCode(this.retryDelayInSeconds);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RetryConfig)) break block3;
                    RetryConfig retryConfig = (RetryConfig)object;
                    if (!(this.maxRetries == retryConfig.maxRetries) || !(this.retryDelayInSeconds == retryConfig.retryDelayInSeconds)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

