/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import android.util.Log;
import java.lang.ref.WeakReference;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Functions;

public final class OperatorWeakBinding<T, R>
implements Observable.Operator<T, T> {
    private static final String LOG_TAG = "WeakBinding";
    final WeakReference<R> boundRef;
    private final Func1<? super R, Boolean> predicate;

    public OperatorWeakBinding(R bound, Func1<? super R, Boolean> predicate) {
        this.boundRef = new WeakReference<R>(bound);
        this.predicate = predicate;
    }

    public OperatorWeakBinding(R bound) {
        this.boundRef = new WeakReference<R>(bound);
        this.predicate = Functions.alwaysTrue();
    }

    public Subscriber<? super T> call(Subscriber<? super T> child) {
        return new WeakSubscriber(child);
    }

    final class WeakSubscriber
    extends Subscriber<T> {
        final WeakReference<Subscriber<? super T>> subscriberRef;

        private WeakSubscriber(Subscriber<? super T> source) {
            super(source);
            this.subscriberRef = new WeakReference(source);
        }

        public void onCompleted() {
            Subscriber sub = (Subscriber)this.subscriberRef.get();
            if (this.shouldForwardNotification(sub)) {
                sub.onCompleted();
            } else {
                this.handleLostBinding(sub, "onCompleted");
            }
        }

        public void onError(Throwable e) {
            Subscriber sub = (Subscriber)this.subscriberRef.get();
            if (this.shouldForwardNotification(sub)) {
                sub.onError(e);
            } else {
                this.handleLostBinding(sub, "onError");
            }
        }

        public void onNext(T t) {
            Subscriber sub = (Subscriber)this.subscriberRef.get();
            if (this.shouldForwardNotification(sub)) {
                sub.onNext(t);
            } else {
                this.handleLostBinding(sub, "onNext");
            }
        }

        private boolean shouldForwardNotification(Subscriber<? super T> sub) {
            Object target = OperatorWeakBinding.this.boundRef.get();
            return sub != null && target != null && (Boolean)OperatorWeakBinding.this.predicate.call(target) != false;
        }

        private void handleLostBinding(Subscriber<? super T> sub, String context) {
            if (sub == null) {
                this.log("subscriber gone; skipping " + context);
            } else {
                Object r = OperatorWeakBinding.this.boundRef.get();
                if (r != null) {
                    this.log("bound component has become invalid; skipping " + context);
                } else {
                    this.log("bound component gone; skipping " + context);
                }
            }
            this.log("unsubscribing...");
            this.unsubscribe();
        }

        private void log(String message) {
            if (Log.isLoggable((String)OperatorWeakBinding.LOG_TAG, (int)3)) {
                Log.d((String)OperatorWeakBinding.LOG_TAG, (String)message);
            }
        }
    }
}

