/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.histogram.PercentileBuckets;
import com.netflix.spectator.api.patterns.IdBuilder;
import com.netflix.spectator.api.patterns.TagsBuilder;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PercentileDistributionSummary
implements DistributionSummary {
    private static final String[] TAG_VALUES;
    private final Registry registry;
    private final Id id;
    private final DistributionSummary summary;
    private final long min;
    private final long max;
    private final AtomicReferenceArray<Counter> counters;

    private static PercentileDistributionSummary computeIfAbsent(Registry registry, Id id, long min, long max) {
        Object summary = Utils.computeIfAbsent(registry.state(), id, i -> new PercentileDistributionSummary(registry, id, min, max));
        return summary instanceof PercentileDistributionSummary ? ((PercentileDistributionSummary)summary).withRange(min, max) : new PercentileDistributionSummary(registry, id, min, max);
    }

    public static PercentileDistributionSummary get(Registry registry, Id id) {
        return new PercentileDistributionSummary(registry, id, 0L, Long.MAX_VALUE);
    }

    public static IdBuilder<Builder> builder(Registry registry) {
        return new IdBuilder<Builder>(registry){

            @Override
            protected Builder createTypeBuilder(Id id) {
                return new Builder(this.registry, id);
            }
        };
    }

    private PercentileDistributionSummary(Registry registry, Id id, long min, long max) {
        this(registry, id, min, max, new AtomicReferenceArray<Counter>(PercentileBuckets.length()));
    }

    private PercentileDistributionSummary(Registry registry, Id id, long min, long max, AtomicReferenceArray<Counter> counters) {
        this.registry = registry;
        this.id = id;
        this.summary = registry.distributionSummary(id);
        this.min = min;
        this.max = max;
        this.counters = counters;
    }

    private PercentileDistributionSummary withRange(long min, long max) {
        return this.min == min && this.max == max ? this : new PercentileDistributionSummary(this.registry, this.id, min, max, this.counters);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return this.summary.hasExpired();
    }

    private Counter counterFor(int i) {
        Counter c = this.counters.get(i);
        if (c == null) {
            Id counterId = this.id.withTags(Statistic.percentile, new BasicTag("percentile", TAG_VALUES[i]));
            c = this.registry.counter(counterId);
            this.counters.set(i, c);
        }
        return c;
    }

    private long restrict(long amount) {
        long v = Math.min(amount, this.max);
        return Math.max(v, this.min);
    }

    @Override
    public void record(long amount) {
        if (amount >= 0L) {
            this.summary.record(amount);
            this.counterFor(PercentileBuckets.indexOf(this.restrict(amount))).increment();
        }
    }

    public double percentile(double p) {
        long[] counts = new long[PercentileBuckets.length()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.counterFor(i).count();
        }
        return PercentileBuckets.percentile(counts, p);
    }

    @Override
    public long count() {
        return this.summary.count();
    }

    @Override
    public long totalAmount() {
        return this.summary.totalAmount();
    }

    static {
        int length = PercentileBuckets.length();
        TAG_VALUES = new String[length];
        for (int i = 0; i < length; ++i) {
            PercentileDistributionSummary.TAG_VALUES[i] = String.format("D%04X", i);
        }
    }

    public static final class Builder
    extends TagsBuilder<Builder> {
        private Registry registry;
        private Id baseId;
        private long min;
        private long max;

        Builder(Registry registry, Id baseId) {
            this.registry = registry;
            this.baseId = baseId;
            this.min = 0L;
            this.max = Long.MAX_VALUE;
        }

        public Builder withRange(long min, long max) {
            this.min = min;
            this.max = max;
            return this;
        }

        public PercentileDistributionSummary build() {
            Id id = this.baseId.withTags(this.extraTags);
            return new PercentileDistributionSummary(this.registry, id, this.min, this.max);
        }
    }
}

