/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.log4j;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.log4j.LevelTag;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Spectator", category="Core", elementType="appender", printObject=true)
public final class SpectatorAppender
extends AbstractAppender {
    private static final long serialVersionUID = 42L;
    private final transient Registry registry;
    private transient Id[] numMessages;
    private transient Id[] numStackTraces;

    private static void addToRootLogger(Appender appender) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.addAppender(appender, Level.ALL, null);
        context.updateLoggers(config);
    }

    public static void addToRootLogger(Registry registry, String name, boolean ignoreExceptions) {
        SpectatorAppender appender = new SpectatorAppender(registry, name, null, null, ignoreExceptions);
        appender.start();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        SpectatorAppender.addToRootLogger((Appender)appender);
        config.addListener(arg_0 -> SpectatorAppender.lambda$addToRootLogger$0((Appender)appender, arg_0));
    }

    SpectatorAppender(Registry registry, String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.registry = registry;
    }

    @PluginFactory
    public static SpectatorAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.error("no name provided for SpectatorAppender");
            return null;
        }
        return new SpectatorAppender((Registry)Spectator.globalRegistry(), name, filter, layout, ignoreExceptions);
    }

    public void start() {
        LevelTag[] levels = LevelTag.values();
        this.numMessages = new Id[levels.length];
        this.numStackTraces = new Id[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            this.numMessages[i] = this.registry.createId("log4j.numMessages").withTag("appender", this.getName()).withTag((Tag)levels[i]);
            this.numStackTraces[i] = this.registry.createId("log4j.numStackTraces").withTag("appender", this.getName()).withTag((Tag)levels[i]);
        }
        super.start();
    }

    public void append(LogEvent event) {
        LevelTag level = LevelTag.get(event.getLevel());
        this.registry.counter(this.numMessages[level.ordinal()]).increment();
        if (!this.ignoreExceptions() && event.getThrown() != null) {
            String file = event.getSource() == null ? "unknown" : event.getSource().getFileName();
            Id stackTraceId = this.numStackTraces[level.ordinal()].withTag("exception", event.getThrown().getClass().getSimpleName()).withTag("file", file);
            this.registry.counter(stackTraceId).increment();
        }
    }

    private static /* synthetic */ void lambda$addToRootLogger$0(Appender appender, Reconfigurable reconfigurable) {
        SpectatorAppender.addToRootLogger(appender);
    }
}

