/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.log4j;

import com.netflix.spectator.api.Tag;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.spi.StandardLevel;

enum LevelTag implements Tag
{
    OFF(StandardLevel.OFF),
    FATAL(StandardLevel.FATAL),
    ERROR(StandardLevel.ERROR),
    WARN(StandardLevel.WARN),
    INFO(StandardLevel.INFO),
    DEBUG(StandardLevel.DEBUG),
    TRACE(StandardLevel.TRACE),
    ALL(StandardLevel.ALL);

    private final StandardLevel std;
    private final String value;
    private static final LevelTag[] LEVELS;

    private LevelTag(StandardLevel std) {
        this.std = std;
        this.value = String.format("%d_%s", this.ordinal(), std.name());
    }

    public String key() {
        return "loglevel";
    }

    public String value() {
        return this.value;
    }

    StandardLevel standardLevel() {
        return this.std;
    }

    static LevelTag get(Level level) {
        StandardLevel stdLevel = level.getStandardLevel();
        return LEVELS[stdLevel.ordinal()];
    }

    static {
        LEVELS = new LevelTag[8];
        LevelTag[] levelTagArray = LevelTag.values();
        int n = levelTagArray.length;
        for (int i = 0; i < n; ++i) {
            LevelTag level;
            LevelTag.LEVELS[level.ordinal()] = level = levelTagArray[i];
        }
    }
}

