/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.config.EmptyConfig;
import com.netflix.servo.SpectatorContext;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.ExtendedRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import com.netflix.spectator.nflx.Plugin;
import javax.annotation.PreDestroy;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpectatorModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpectatorModule.class);

    protected void configure() {
        this.bind(Plugin.class).toProvider(PluginProvider.class).asEagerSingleton();
        this.bind(StaticManager.class).asEagerSingleton();
        OptionalBinder.newOptionalBinder((Binder)this.binder(), ExtendedRegistry.class).setDefault().toInstance((Object)Spectator.registry());
        OptionalBinder.newOptionalBinder((Binder)this.binder(), Registry.class).setDefault().toProvider(RegistryProvider.class).in(Scopes.SINGLETON);
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    @Singleton
    private static class RegistryProvider
    implements Provider<Registry>,
    AutoCloseable {
        private final AtlasRegistry registry;

        @Inject
        RegistryProvider(OptionalInjections opts) {
            final Config config = opts.config();
            LOGGER.info("using AtlasRegistry and delegating Servo operations to Spectator");
            AtlasConfig cfg = new AtlasConfig(){

                public String get(String k) {
                    String prop = "netflix.spectator.registry." + k;
                    return config.getString(prop, null);
                }

                public boolean enabled() {
                    String v = this.get("atlas.enabled");
                    return v != null && Boolean.valueOf(v) != false;
                }
            };
            this.registry = new AtlasRegistry(opts.clock(), cfg);
            this.registry.start();
            SpectatorContext.setRegistry((Registry)this.registry);
        }

        @Override
        public void close() {
            this.registry.stop();
        }

        public Registry get() {
            return this.registry;
        }
    }

    private static class StaticManager {
        private final Registry registry;

        @Inject
        StaticManager(Registry registry) {
            this.registry = registry;
            Spectator.globalRegistry().add(registry);
        }

        @PreDestroy
        void onShutdown() {
            Spectator.globalRegistry().remove(this.registry);
        }
    }

    private static class OptionalInjections {
        @Inject(optional=true)
        private Config config;
        @Inject(optional=true)
        private Clock clock;

        private OptionalInjections() {
        }

        Config config() {
            if (this.config == null) {
                LOGGER.warn("no archaius2 binding found, using empty configuration");
                this.config = EmptyConfig.INSTANCE;
            }
            return this.config;
        }

        Clock clock() {
            return this.clock == null ? Clock.SYSTEM : this.clock;
        }
    }

    private static class PluginProvider
    implements Provider<Plugin> {
        private final Plugin plugin;

        @Inject
        PluginProvider(Registry registry, OptionalInjections opts) {
            this.plugin = new Plugin(registry, opts.config());
        }

        public Plugin get() {
            return this.plugin;
        }
    }
}

