/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.impl.AtomicDouble;
import java.util.Collections;

class AtlasGauge
extends AtlasMeter
implements Gauge {
    private final AtomicDouble value = new AtomicDouble(0.0);
    private final Id stat;

    AtlasGauge(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stat = id.withTag((Tag)Statistic.gauge).withTags(id.tags()).withTag((Tag)DsType.gauge);
    }

    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.stat, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    public void set(double v) {
        this.value.set(v);
        this.updateLastModTime();
    }

    public double value() {
        return this.value.get();
    }
}

