/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;

final class Rollups {
    private static final Set<String> SUM_STATS = new LinkedHashSet<String>();
    private static final DoubleBinaryOperator SUM;
    private static final DoubleBinaryOperator MAX;

    private Rollups() {
    }

    static List<Measurement> aggregate(Function<Id, Id> idMapper, List<Measurement> measurements) {
        HashMap<Id, Aggregator> aggregates = new HashMap<Id, Aggregator>();
        for (Measurement m : measurements) {
            Id id = idMapper.apply(m.id());
            if (id == null) continue;
            Aggregator aggregator = (Aggregator)aggregates.get(id);
            if (aggregator == null) {
                aggregator = Rollups.newAggregator(id, m);
                aggregates.put(id, aggregator);
                continue;
            }
            aggregator.update(m);
        }
        ArrayList<Measurement> result = new ArrayList<Measurement>(aggregates.size());
        for (Aggregator aggregator : aggregates.values()) {
            result.add(aggregator.toMeasurement());
        }
        return result;
    }

    private static DoubleBinaryOperator nanAwareOp(DoubleBinaryOperator op) {
        return (a, b) -> Double.isNaN(a) ? b : (Double.isNaN(b) ? a : op.applyAsDouble(a, b));
    }

    private static Aggregator newAggregator(Id id, Measurement m) {
        DoubleBinaryOperator af = MAX;
        String statistic = Utils.getTagValue((Id)id, (String)"statistic");
        if (statistic != null && SUM_STATS.contains(statistic)) {
            af = SUM;
        }
        return new Aggregator(id, m.timestamp(), af, m.value());
    }

    static {
        SUM_STATS.add("count");
        SUM_STATS.add("totalAmount");
        SUM_STATS.add("totalTime");
        SUM_STATS.add("totalOfSquares");
        SUM_STATS.add("percentile");
        SUM = Rollups.nanAwareOp((a, b) -> a + b);
        MAX = Rollups.nanAwareOp((a, b) -> a > b ? a : b);
    }

    private static class Aggregator {
        private final Id id;
        private final long timestamp;
        private final DoubleBinaryOperator af;
        private double value;

        Aggregator(Id id, long timestamp, DoubleBinaryOperator af, double init) {
            this.id = id;
            this.timestamp = timestamp;
            this.af = af;
            this.value = init;
        }

        void update(Measurement m) {
            this.value = this.af.applyAsDouble(this.value, m.value());
        }

        Measurement toMeasurement() {
            return new Measurement(this.id, this.timestamp, this.value);
        }
    }
}

