/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.impl.Subscription;
import com.netflix.spectator.atlas.impl.Subscriptions;
import com.netflix.spectator.ipc.http.HttpClient;
import com.netflix.spectator.ipc.http.HttpResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionManager.class);
    private final ObjectMapper mapper;
    private final HttpClient client;
    private final Clock clock;
    private final URI uri;
    private final int connectTimeout;
    private final int readTimeout;
    private final long stepMillis;
    private final long configTTL;
    private final Map<Subscription, Long> subscriptions = new ConcurrentHashMap<Subscription, Long>();
    private Subscriptions payload;
    private String etag;

    SubscriptionManager(ObjectMapper mapper, HttpClient client, Clock clock, AtlasConfig config) {
        this.mapper = mapper;
        this.client = client;
        this.clock = clock;
        this.uri = URI.create(config.configUri());
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.stepMillis = config.step().toMillis();
        this.configTTL = config.configTTL().toMillis();
    }

    List<Subscription> subscriptions() {
        return new ArrayList<Subscription>(this.subscriptions.keySet());
    }

    void refresh() {
        try {
            HttpResponse res = this.client.get(this.uri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).addHeader("If-None-Match", this.etag).send().decompress();
            if (res.status() == 304) {
                LOGGER.debug("no modification to subscriptions");
            } else if (res.status() != 200) {
                LOGGER.warn("failed to update subscriptions, received status {}", (Object)res.status());
            } else {
                this.etag = res.header("ETag");
                this.payload = this.filterByStep((Subscriptions)this.mapper.readValue(res.entity(), Subscriptions.class));
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to update subscriptions (uri={})", (Object)this.uri, (Object)e);
        }
        if (this.payload != null) {
            long now = this.clock.wallTime();
            this.payload.update(this.subscriptions, now, now + this.configTTL);
        }
    }

    private Subscriptions filterByStep(Subscriptions subs) {
        List<Subscription> subscriptions = subs.getExpressions().stream().filter(s -> s.getFrequency() == this.stepMillis).collect(Collectors.toList());
        return new Subscriptions().withExpressions(subscriptions);
    }
}

