/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.AdditionalPropertiesValidator;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ContainsValidator;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ExecutionConfig;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.ExecutionCustomizer;
import com.networknt.schema.ItemsValidator;
import com.networknt.schema.ItemsValidator202012;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.OutputFormat;
import com.networknt.schema.PatternPropertiesValidator;
import com.networknt.schema.PrefixItemsValidator;
import com.networknt.schema.PropertiesValidator;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.walk.DefaultKeywordWalkListenerRunner;
import com.networknt.schema.walk.WalkListenerRunner;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JsonSchema
extends BaseJsonValidator {
    private static final long V201909_VALUE = SpecVersion.VersionFlag.V201909.getVersionFlagValue();
    private List<JsonValidator> validators;
    private final JsonMetaSchema metaSchema;
    private boolean validatorsLoaded = false;
    private boolean dynamicAnchor = false;
    private URI currentUri;
    private JsonValidator requiredValidator = null;
    private TypeValidator typeValidator;
    WalkListenerRunner keywordWalkListenerRunner = null;
    private final String id;
    private final String anchor;
    private static Comparator<JsonValidator> VALIDATOR_SORT = (lhs, rhs) -> {
        String rhsName;
        String lhsName = lhs.getEvaluationPath().getName(-1);
        if (lhsName.equals(rhsName = rhs.getEvaluationPath().getName(-1))) {
            return 0;
        }
        if (lhsName.equals("properties")) {
            return -1;
        }
        if (rhsName.equals("properties")) {
            return 1;
        }
        if (lhsName.equals("patternProperties")) {
            return -1;
        }
        if (rhsName.equals("patternProperties")) {
            return 1;
        }
        if (lhsName.equals("unevaluatedItems")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedItems")) {
            return -1;
        }
        if (lhsName.equals("unevaluatedProperties")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedProperties")) {
            return -1;
        }
        return 0;
    };

    static JsonSchema from(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        return new JsonSchema(validationContext, schemaLocation, evaluationPath, currentUri, schemaNode, parent, suppressSubSchemaRetrieval);
    }

    private JsonSchema(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(schemaLocation, evaluationPath, schemaNode, parent, null, null, validationContext, suppressSubSchemaRetrieval);
        this.validationContext = validationContext;
        this.metaSchema = validationContext.getMetaSchema();
        this.currentUri = this.combineCurrentUriWithIds(currentUri, schemaNode);
        this.initializeConfig();
        this.id = validationContext.resolveSchemaId(this.schemaNode);
        this.anchor = validationContext.getMetaSchema().readAnchor(this.schemaNode);
        if (this.id != null) {
            this.validationContext.getSchemaResources().putIfAbsent(this.currentUri != null ? this.currentUri.toString() : this.id, this);
        }
        if (this.anchor != null) {
            this.validationContext.getSchemaResources().putIfAbsent(this.currentUri.toString() + "#" + this.anchor, this);
        }
        this.getValidators();
    }

    private void initializeConfig() {
        if (this.validationContext.getConfig() != null) {
            this.keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.validationContext.getConfig().getKeywordWalkListenersMap());
        }
    }

    protected JsonSchema(JsonSchema copy) {
        super(copy);
        this.validators = copy.validators;
        this.metaSchema = copy.metaSchema;
        this.validatorsLoaded = copy.validatorsLoaded;
        this.dynamicAnchor = copy.dynamicAnchor;
        this.currentUri = copy.currentUri;
        this.requiredValidator = copy.requiredValidator;
        this.typeValidator = copy.typeValidator;
        this.keywordWalkListenerRunner = copy.keywordWalkListenerRunner;
        this.id = copy.id;
        this.anchor = copy.anchor;
    }

    public JsonSchema fromRef(JsonSchema refEvaluationParentSchema, JsonNodePath refEvaluationPath) {
        JsonSchema copy = new JsonSchema(this);
        copy.validationContext = new ValidationContext(copy.validationContext.getURIFactory(), copy.getValidationContext().getURNFactory(), copy.getValidationContext().getMetaSchema(), copy.getValidationContext().getJsonSchemaFactory(), refEvaluationParentSchema.validationContext.getConfig(), copy.getValidationContext().getSchemaReferences(), copy.getValidationContext().getSchemaResources());
        copy.evaluationPath = refEvaluationPath;
        copy.evaluationParentSchema = refEvaluationParentSchema;
        copy.validatorsLoaded = false;
        copy.requiredValidator = null;
        copy.typeValidator = null;
        copy.validators = null;
        copy.initializeConfig();
        return copy;
    }

    public JsonSchema withConfig(SchemaValidatorsConfig config) {
        if (!this.getValidationContext().getConfig().equals(config)) {
            JsonSchema copy = new JsonSchema(this);
            copy.validationContext = new ValidationContext(copy.validationContext.getURIFactory(), copy.getValidationContext().getURNFactory(), copy.getValidationContext().getMetaSchema(), copy.getValidationContext().getJsonSchemaFactory(), config, copy.getValidationContext().getSchemaReferences(), copy.getValidationContext().getSchemaResources());
            copy.validatorsLoaded = false;
            copy.requiredValidator = null;
            copy.typeValidator = null;
            copy.validators = null;
            copy.initializeConfig();
            return copy;
        }
        return this;
    }

    ValidationContext getValidationContext() {
        return this.validationContext;
    }

    private URI combineCurrentUriWithIds(URI currentUri, JsonNode schemaNode) {
        String id = this.validationContext.resolveSchemaId(schemaNode);
        if (id == null) {
            return currentUri;
        }
        if (JsonSchema.isUriFragmentWithNoContext(currentUri, id)) {
            return null;
        }
        try {
            return this.validationContext.getURIFactory().create(currentUri, id);
        }
        catch (IllegalArgumentException e) {
            SchemaLocation path = this.schemaLocation.append(this.metaSchema.getIdKeyword());
            ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().code(ValidatorTypeCode.ID.getValue())).type(ValidatorTypeCode.ID.getValue())).instanceLocation(path.getFragment())).evaluationPath(path.getFragment())).arguments(currentUri == null ? "null" : currentUri.toString(), id)).messageFormatter(args -> this.validationContext.getConfig().getMessageSource().getMessage(ValidatorTypeCode.ID.getValue(), this.validationContext.getConfig().getLocale(), args))).build();
            throw new JsonSchemaException(validationMessage);
        }
    }

    private static boolean isUriFragmentWithNoContext(URI currentUri, String id) {
        return id.startsWith("#") && (currentUri == null || currentUri.toString().startsWith("#"));
    }

    public URI getCurrentUri() {
        return this.currentUri;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findSchemaResourceRoot();
        JsonNode node = schema.getSchemaNode();
        String jsonPointer = ref;
        if (schema.getId() != null && ref.startsWith(schema.getId())) {
            String refValue;
            jsonPointer = refValue = ref.substring(schema.getId().length());
        }
        if (jsonPointer.startsWith("#/")) {
            jsonPointer = jsonPointer.substring(1);
        }
        if (jsonPointer.startsWith("/")) {
            try {
                jsonPointer = URLDecoder.decode(jsonPointer, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            node = node.at(jsonPointer);
            if (node.isMissingNode()) {
                node = this.handleNullNode(ref, schema);
            }
        } else if ((ref.startsWith("#") && ref.length() > 1 || ref.startsWith("urn:") && ref.length() > 4) && (node = this.metaSchema.getNodeByFragmentRef(ref, node)) == null) {
            node = this.handleNullNode(ref, schema);
        }
        return node;
    }

    public JsonSchema findLexicalRoot() {
        JsonSchema ancestor = this;
        while (ancestor.getId() == null && null != ancestor.getParentSchema()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public JsonSchema findSchemaResourceRoot() {
        JsonSchema ancestor = this;
        while (!ancestor.isSchemaResourceRoot()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public boolean isSchemaResourceRoot() {
        if (this.getId() != null) {
            return true;
        }
        if (this.getParentSchema() == null) {
            return true;
        }
        if (this.getCurrentUri() != null && this.getParentSchema().getCurrentUri() == null) {
            return true;
        }
        if (this.getCurrentUri() == null && this.getParentSchema().getCurrentUri() != null) {
            return true;
        }
        if (this.getCurrentUri() != null && this.getParentSchema().getCurrentUri() != null) {
            if (!Objects.equals(this.getCurrentUri().getScheme(), this.getParentSchema().getCurrentUri().getScheme())) {
                return true;
            }
            if (!Objects.equals(this.getCurrentUri().getHost(), this.getParentSchema().getCurrentUri().getHost())) {
                return true;
            }
            if (!Objects.equals(this.getCurrentUri().getPath(), this.getParentSchema().getCurrentUri().getPath())) {
                return true;
            }
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private List<JsonValidator> read(JsonNode schemaNode) {
        ArrayList<JsonValidator> validators = new ArrayList<JsonValidator>();
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                JsonNodePath path = this.getEvaluationPath().append("true");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("true"), path, "true", schemaNode, this);
                validators.add(validator);
            } else {
                JsonNodePath path = this.getEvaluationPath().append("false");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("false"), path, "false", schemaNode, this);
                validators.add(validator);
            }
        } else {
            JsonValidator refValidator = null;
            Iterator pnames = schemaNode.fieldNames();
            while (pnames.hasNext()) {
                JsonValidator validator;
                String pname = (String)pnames.next();
                JsonNode nodeToUse = schemaNode.get(pname);
                JsonNodePath path = this.getEvaluationPath().append(pname);
                SchemaLocation schemaPath = this.getSchemaLocation().append(pname);
                if ("$recursiveAnchor".equals(pname)) {
                    if (!nodeToUse.isBoolean()) {
                        ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type("$recursiveAnchor")).code("internal.invalidRecursiveAnchor")).message("{0}: The value of a $recursiveAnchor must be a Boolean literal but is {1}")).instanceLocation(path)).evaluationPath(path)).schemaLocation(schemaPath)).arguments(nodeToUse.getNodeType().toString())).build();
                        throw new JsonSchemaException(validationMessage);
                    }
                    this.dynamicAnchor = nodeToUse.booleanValue();
                }
                if ((validator = this.validationContext.newValidator(schemaPath, path, pname, nodeToUse, this)) == null) continue;
                validators.add(validator);
                if ("$ref".equals(pname)) {
                    refValidator = validator;
                    continue;
                }
                if ("required".equals(pname)) {
                    this.requiredValidator = validator;
                    continue;
                }
                if (!"type".equals(pname)) continue;
                this.typeValidator = (TypeValidator)validator;
            }
            if (null != refValidator && this.activeDialect() < V201909_VALUE) {
                validators.clear();
                validators.add(refValidator);
            }
        }
        if (validators.size() > 1) {
            Collections.sort(validators, VALIDATOR_SORT);
        }
        return validators;
    }

    private long activeDialect() {
        return this.validationContext.activeDialect().map(SpecVersion.VersionFlag::getVersionFlagValue).orElse(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        DiscriminatorContext discriminatorContext;
        ObjectNode discriminator;
        ObjectNode discriminator2;
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && null != (discriminator2 = (ObjectNode)this.schemaNode.get("discriminator")) && null != executionContext.getCurrentDiscriminatorContext()) {
            executionContext.getCurrentDiscriminatorContext().registerDiscriminator(this.schemaLocation, discriminator2);
        }
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        LinkedHashSet<ValidationMessage> errors = null;
        CollectorContext collectorContext = executionContext.getCollectorContext();
        JsonSchema.setValidatorState(executionContext, false, true);
        for (JsonValidator v : this.getValidators()) {
            CollectorContext.Scope scope;
            Set<ValidationMessage> results;
            block14: {
                results = null;
                CollectorContext.Scope parentScope = collectorContext.enterDynamicScope(this);
                try {
                    results = v.validate(executionContext, jsonNode, rootNode, instanceLocation);
                    scope = collectorContext.exitDynamicScope();
                    if (results != null && !results.isEmpty()) break block14;
                    parentScope.mergeWith(scope);
                }
                catch (Throwable throwable) {
                    CollectorContext.Scope scope2 = collectorContext.exitDynamicScope();
                    if (results == null || results.isEmpty()) {
                        parentScope.mergeWith(scope2);
                    } else {
                        if (errors == null) {
                            errors = new LinkedHashSet<ValidationMessage>();
                        }
                        errors.addAll(results);
                        if (v instanceof PrefixItemsValidator || v instanceof ItemsValidator || v instanceof ItemsValidator202012 || v instanceof ContainsValidator) {
                            collectorContext.getEvaluatedItems().addAll(scope2.getEvaluatedItems());
                        }
                        if (v instanceof PropertiesValidator || v instanceof AdditionalPropertiesValidator || v instanceof PatternPropertiesValidator) {
                            collectorContext.getEvaluatedProperties().addAll(scope2.getEvaluatedProperties());
                        }
                    }
                    throw throwable;
                }
                continue;
            }
            if (errors == null) {
                errors = new LinkedHashSet();
            }
            errors.addAll(results);
            if (v instanceof PrefixItemsValidator || v instanceof ItemsValidator || v instanceof ItemsValidator202012 || v instanceof ContainsValidator) {
                collectorContext.getEvaluatedItems().addAll(scope.getEvaluatedItems());
            }
            if (!(v instanceof PropertiesValidator) && !(v instanceof AdditionalPropertiesValidator) && !(v instanceof PatternPropertiesValidator)) continue;
            collectorContext.getEvaluatedProperties().addAll(scope.getEvaluatedProperties());
        }
        if (config.isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)this.schemaNode.get("discriminator")) && null != (discriminatorContext = executionContext.getCurrentDiscriminatorContext())) {
            ObjectNode discriminatorToUse;
            ObjectNode discriminatorFromContext = discriminatorContext.getDiscriminatorForPath(this.schemaLocation);
            if (null == discriminatorFromContext) {
                discriminatorContext.registerDiscriminator(this.schemaLocation, discriminator);
                discriminatorToUse = discriminator;
            } else {
                discriminatorToUse = discriminatorFromContext;
            }
            String discriminatorPropertyName = discriminatorToUse.get("propertyName").asText();
            JsonNode discriminatorNode = jsonNode.get(discriminatorPropertyName);
            String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.asText();
            JsonSchema.checkDiscriminatorMatch(discriminatorContext, discriminatorToUse, discriminatorPropertyValue, this);
        }
        return errors == null ? Collections.emptySet() : errors;
    }

    public Set<ValidationMessage> validate(JsonNode rootNode) {
        return this.validate(rootNode, OutputFormat.DEFAULT);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format) {
        return this.validate(rootNode, format, null);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, ExecutionCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, executionCustomizer);
    }

    public ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode node) {
        return this.validateAndCollect(executionContext, node, node, this.atRoot());
    }

    private ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = executionContext.getCollectorContext();
        JsonSchema.setValidatorState(executionContext, false, true);
        Set<ValidationMessage> errors = this.validate(executionContext, jsonNode, rootNode, instanceLocation);
        if (config.doLoadCollectors()) {
            collectorContext.loadCollectors();
        }
        ValidationResult validationResult = new ValidationResult(errors, executionContext);
        return validationResult;
    }

    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(this.createExecutionContext(), node, node, this.atRoot());
    }

    public ValidationResult walk(ExecutionContext executionContext, JsonNode node, boolean shouldValidateSchema) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), shouldValidateSchema);
    }

    public ValidationResult walk(JsonNode node, boolean shouldValidateSchema) {
        return this.walk(this.createExecutionContext(), node, shouldValidateSchema);
    }

    public ValidationResult walkAtNode(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        return this.walkAtNodeInternal(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
    }

    private ValidationResult walkAtNodeInternal(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = executionContext.getCollectorContext();
        JsonSchema.setValidatorState(executionContext, true, shouldValidateSchema);
        Set<ValidationMessage> errors = this.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
        if (config.doLoadCollectors()) {
            collectorContext.loadCollectors();
        }
        ValidationResult validationResult = new ValidationResult(errors, executionContext);
        return validationResult;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        this.getValidators().forEach(jsonWalker -> {
            JsonNodePath evaluationPathWithKeyword = jsonWalker.getEvaluationPath();
            try {
                if (this.keywordWalkListenerRunner.runPreWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, jsonWalker.getEvaluationPath(), jsonWalker.getSchemaLocation(), this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory())) {
                    validationMessages.addAll(jsonWalker.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema));
                }
            }
            finally {
                this.keywordWalkListenerRunner.runPostWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, jsonWalker.getEvaluationPath(), jsonWalker.getSchemaLocation(), this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory(), validationMessages);
            }
        });
        return validationMessages;
    }

    private static void setValidatorState(ExecutionContext executionContext, boolean isWalkEnabled, boolean shouldValidateSchema) {
        ValidatorState validatorState = executionContext.getValidatorState();
        if (validatorState == null) {
            executionContext.setValidatorState(new ValidatorState(isWalkEnabled, shouldValidateSchema));
        }
    }

    @Override
    public String toString() {
        return "\"" + this.getEvaluationPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }

    public boolean hasTypeValidator() {
        return this.getTypeValidator() != null;
    }

    public TypeValidator getTypeValidator() {
        if (this.validators == null) {
            this.getValidators();
        }
        return this.typeValidator;
    }

    public List<JsonValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableList(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            this.validatorsLoaded = true;
            for (JsonValidator validator : this.getValidators()) {
                validator.preloadJsonSchema();
            }
        }
    }

    public boolean isDynamicAnchor() {
        return this.dynamicAnchor;
    }

    public ExecutionContext createExecutionContext() {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        if (config.getExecutionContextSupplier() != null) {
            return config.getExecutionContextSupplier().get();
        }
        CollectorContext collectorContext = new CollectorContext(config.isUnevaluatedItemsAnalysisDisabled(), config.isUnevaluatedPropertiesAnalysisDisabled());
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setLocale(config.getLocale());
        return new ExecutionContext(executionConfig, collectorContext);
    }
}

