/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Annotations;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import java.util.Set;

public interface OutputFormat<T> {
    public static final Default DEFAULT = new Default();
    public static final Flag BOOLEAN = new Flag();
    public static final Flag FLAG = new Flag();

    default public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
    }

    public T format(Set<ValidationMessage> var1, ExecutionContext var2, ValidationContext var3);

    public static class FlagOutput {
        private final boolean valid;

        public FlagOutput(boolean valid) {
            this.valid = valid;
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    public static class Boolean
    implements OutputFormat<java.lang.Boolean> {
        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
            executionContext.getExecutionConfig().setAnnotationAllowedPredicate(Annotations.getDefaultAnnotationAllowListPredicate(validationContext.getMetaSchema()));
        }

        @Override
        public java.lang.Boolean format(Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return validationMessages.isEmpty();
        }
    }

    public static class Flag
    implements OutputFormat<FlagOutput> {
        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
            executionContext.getExecutionConfig().setAnnotationAllowedPredicate(Annotations.getDefaultAnnotationAllowListPredicate(validationContext.getMetaSchema()));
        }

        @Override
        public FlagOutput format(Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return new FlagOutput(validationMessages.isEmpty());
        }
    }

    public static class Default
    implements OutputFormat<Set<ValidationMessage>> {
        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
            executionContext.getExecutionConfig().setAnnotationAllowedPredicate(Annotations.getDefaultAnnotationAllowListPredicate(validationContext.getMetaSchema()));
        }

        @Override
        public Set<ValidationMessage> format(Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return validationMessages;
        }
    }
}

