/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaVersion;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.Version201909;
import com.networknt.schema.Version202012;
import com.networknt.schema.Version4;
import com.networknt.schema.Version6;
import com.networknt.schema.Version7;
import com.networknt.schema.resource.DefaultSchemaLoader;
import com.networknt.schema.resource.SchemaLoader;
import com.networknt.schema.resource.SchemaLoaders;
import com.networknt.schema.resource.SchemaMapper;
import com.networknt.schema.resource.SchemaMappers;
import com.networknt.schema.serialization.JsonMapperFactory;
import com.networknt.schema.serialization.YamlMapperFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaFactory.class);
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;
    private final String defaultMetaSchemaURI;
    private final SchemaLoaders.Builder schemaLoadersBuilder;
    private final SchemaMappers.Builder schemaMappersBuilder;
    private final SchemaLoader schemaLoader;
    private final Map<String, JsonMetaSchema> jsonMetaSchemas;
    private final ConcurrentMap<SchemaLocation, JsonSchema> uriSchemaCache = new ConcurrentHashMap<SchemaLocation, JsonSchema>();
    private final boolean enableUriSchemaCache;
    private static final List<SchemaLoader> DEFAULT_SCHEMA_LOADERS = SchemaLoaders.builder().build();
    private static final List<SchemaMapper> DEFAULT_SCHEMA_MAPPERS = SchemaMappers.builder().build();

    private JsonSchemaFactory(ObjectMapper jsonMapper, ObjectMapper yamlMapper, String defaultMetaSchemaURI, SchemaLoaders.Builder schemaLoadersBuilder, SchemaMappers.Builder schemaMappersBuilder, Map<String, JsonMetaSchema> jsonMetaSchemas, boolean enableUriSchemaCache) {
        if (defaultMetaSchemaURI == null || defaultMetaSchemaURI.trim().isEmpty()) {
            throw new IllegalArgumentException("defaultMetaSchemaURI must not be null or empty");
        }
        if (jsonMetaSchemas == null || jsonMetaSchemas.isEmpty()) {
            throw new IllegalArgumentException("Json Meta Schemas must not be null or empty");
        }
        if (jsonMetaSchemas.get(JsonSchemaFactory.normalizeMetaSchemaUri(defaultMetaSchemaURI)) == null) {
            throw new IllegalArgumentException("Meta Schema for default Meta Schema URI must be provided");
        }
        this.jsonMapper = jsonMapper;
        this.yamlMapper = yamlMapper;
        this.defaultMetaSchemaURI = defaultMetaSchemaURI;
        this.schemaLoadersBuilder = schemaLoadersBuilder;
        this.schemaMappersBuilder = schemaMappersBuilder;
        this.schemaLoader = new DefaultSchemaLoader(schemaLoadersBuilder != null ? schemaLoadersBuilder.build() : DEFAULT_SCHEMA_LOADERS, schemaMappersBuilder != null ? schemaMappersBuilder.build() : DEFAULT_SCHEMA_MAPPERS);
        this.jsonMetaSchemas = jsonMetaSchemas;
        this.enableUriSchemaCache = enableUriSchemaCache;
    }

    public SchemaLoader getSchemaLoader() {
        return this.schemaLoader;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JsonSchemaFactory getInstance(SpecVersion.VersionFlag versionFlag) {
        return JsonSchemaFactory.getInstance(versionFlag, null);
    }

    public static JsonSchemaFactory getInstance(SpecVersion.VersionFlag versionFlag, Consumer<Builder> customizer) {
        JsonSchemaVersion jsonSchemaVersion = JsonSchemaFactory.checkVersion(versionFlag);
        JsonMetaSchema metaSchema = jsonSchemaVersion.getInstance();
        Builder builder = JsonSchemaFactory.builder().defaultMetaSchemaURI(metaSchema.getUri()).addMetaSchema(metaSchema);
        if (customizer != null) {
            customizer.accept(builder);
        }
        return builder.build();
    }

    public static JsonSchemaVersion checkVersion(SpecVersion.VersionFlag versionFlag) {
        if (null == versionFlag) {
            return null;
        }
        switch (versionFlag) {
            case V202012: {
                return new Version202012();
            }
            case V201909: {
                return new Version201909();
            }
            case V7: {
                return new Version7();
            }
            case V6: {
                return new Version6();
            }
            case V4: {
                return new Version4();
            }
        }
        throw new IllegalArgumentException("Unsupported value" + (Object)((Object)versionFlag));
    }

    public static Builder builder(JsonSchemaFactory blueprint) {
        Builder builder = JsonSchemaFactory.builder().addMetaSchemas(blueprint.jsonMetaSchemas.values()).defaultMetaSchemaURI(blueprint.defaultMetaSchemaURI).jsonMapper(blueprint.jsonMapper).yamlMapper(blueprint.yamlMapper);
        if (blueprint.schemaLoadersBuilder != null) {
            builder.schemaLoadersBuilder = SchemaLoaders.builder().with(blueprint.schemaLoadersBuilder);
        }
        if (blueprint.schemaMappersBuilder != null) {
            builder.schemaMappersBuilder = SchemaMappers.builder().with(blueprint.schemaMappersBuilder);
        }
        return builder;
    }

    protected JsonSchema newJsonSchema(SchemaLocation schemaUri, JsonNode schemaNode, SchemaValidatorsConfig config) {
        ValidationContext validationContext = this.createValidationContext(schemaNode, config);
        JsonSchema jsonSchema = this.doCreate(validationContext, this.getSchemaLocation(schemaUri), new JsonNodePath(validationContext.getConfig().getPathType()), schemaNode, null, false);
        if (config.isPreloadJsonSchema()) {
            try {
                jsonSchema.initializeValidators();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jsonSchema;
    }

    public JsonSchema create(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema) {
        return this.doCreate(validationContext, schemaLocation, evaluationPath, schemaNode, parentSchema, false);
    }

    private JsonSchema doCreate(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, boolean suppressSubSchemaRetrieval) {
        return JsonSchema.from(this.withMetaSchema(validationContext, schemaNode), schemaLocation, evaluationPath, schemaNode, parentSchema, suppressSubSchemaRetrieval);
    }

    private ValidationContext withMetaSchema(ValidationContext validationContext, JsonNode schemaNode) {
        JsonMetaSchema metaSchema = this.getMetaSchema(schemaNode, validationContext.getConfig());
        if (metaSchema != null && !metaSchema.getUri().equals(validationContext.getMetaSchema().getUri())) {
            return new ValidationContext(metaSchema, validationContext.getJsonSchemaFactory(), validationContext.getConfig(), validationContext.getSchemaReferences(), validationContext.getSchemaResources(), validationContext.getDynamicAnchors());
        }
        return validationContext;
    }

    protected SchemaLocation getSchemaLocation(SchemaLocation schemaLocation) {
        return schemaLocation != null ? schemaLocation : SchemaLocation.DOCUMENT;
    }

    protected ValidationContext createValidationContext(JsonNode schemaNode, SchemaValidatorsConfig config) {
        JsonMetaSchema jsonMetaSchema = this.getMetaSchemaOrDefault(schemaNode, config);
        return new ValidationContext(jsonMetaSchema, this, config);
    }

    private JsonMetaSchema getMetaSchema(JsonNode schemaNode, SchemaValidatorsConfig config) {
        JsonNode uriNode = schemaNode.get("$schema");
        if (uriNode != null && uriNode.isTextual()) {
            return this.jsonMetaSchemas.computeIfAbsent(JsonSchemaFactory.normalizeMetaSchemaUri(uriNode.textValue()), id -> this.getMetaSchema((String)id, config));
        }
        return null;
    }

    private JsonMetaSchema getMetaSchemaOrDefault(JsonNode schemaNode, SchemaValidatorsConfig config) {
        JsonNode uriNode = schemaNode.get("$schema");
        if (uriNode != null && !uriNode.isNull() && !uriNode.isTextual()) {
            throw new JsonSchemaException("Unknown MetaSchema: " + uriNode.toString());
        }
        String uri = uriNode == null || uriNode.isNull() ? this.defaultMetaSchemaURI : JsonSchemaFactory.normalizeMetaSchemaUri(uriNode.textValue());
        return this.jsonMetaSchemas.computeIfAbsent(uri, id -> this.getMetaSchema((String)id, config));
    }

    public JsonMetaSchema getMetaSchema(String id, SchemaValidatorsConfig config) {
        return SpecVersionDetector.detectOptionalVersion(id).map(JsonSchemaFactory::checkVersion).map(JsonSchemaVersion::getInstance).orElseGet(() -> this.loadMetaSchema(id, config));
    }

    protected JsonMetaSchema loadMetaSchema(String id, SchemaValidatorsConfig config) {
        try {
            JsonNode vocabulary;
            JsonSchema schema = this.getSchema(SchemaLocation.of(id), config);
            JsonMetaSchema.Builder builder = JsonMetaSchema.builder(id, schema.getValidationContext().getMetaSchema());
            SpecVersion.VersionFlag specification = schema.getValidationContext().getMetaSchema().getSpecification();
            if (specification != null && specification.getVersionFlagValue() >= SpecVersion.VersionFlag.V201909.getVersionFlagValue() && (vocabulary = schema.getSchemaNode().get("$vocabulary")) != null) {
                builder.vocabularies(new LinkedHashMap<String, Boolean>());
                for (Map.Entry vocabs : vocabulary.properties()) {
                    builder.vocabulary((String)vocabs.getKey(), ((JsonNode)vocabs.getValue()).booleanValue());
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Unknown MetaSchema: {1}")).arguments(id)).build();
            throw new InvalidSchemaException(validationMessage, e);
        }
    }

    public JsonSchema getSchema(String schema, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.getJsonMapper().readTree(schema);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(String schema) {
        return this.getSchema(schema, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(InputStream schemaStream, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.getJsonMapper().readTree(schemaStream);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(InputStream schemaStream) {
        return this.getSchema(schemaStream, this.createSchemaValidatorsConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSchema getSchema(SchemaLocation schemaUri, SchemaValidatorsConfig config) {
        if (this.enableUriSchemaCache) {
            JsonSchema cachedUriSchema = (JsonSchema)this.uriSchemaCache.get(schemaUri);
            if (cachedUriSchema == null) {
                JsonSchemaFactory jsonSchemaFactory = this;
                synchronized (jsonSchemaFactory) {
                    cachedUriSchema = (JsonSchema)this.uriSchemaCache.get(schemaUri);
                    if (cachedUriSchema == null && (cachedUriSchema = this.getMappedSchema(schemaUri, config)) != null) {
                        this.uriSchemaCache.put(schemaUri, cachedUriSchema);
                    }
                }
            }
            return cachedUriSchema.withConfig(config);
        }
        return this.getMappedSchema(schemaUri, config);
    }

    protected ObjectMapper getYamlMapper() {
        return this.yamlMapper != null ? this.yamlMapper : YamlMapperFactory.getInstance();
    }

    protected ObjectMapper getJsonMapper() {
        return this.jsonMapper != null ? this.jsonMapper : JsonMapperFactory.getInstance();
    }

    protected SchemaValidatorsConfig createSchemaValidatorsConfig() {
        return new SchemaValidatorsConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonSchema getMappedSchema(SchemaLocation schemaUri, SchemaValidatorsConfig config) {
        try (InputStream inputStream = this.schemaLoader.getSchema(schemaUri.getAbsoluteIri()).getInputStream();){
            JsonNode schemaNode222;
            if (inputStream == null) {
                throw new IOException("Cannot load schema at " + schemaUri.toString());
            }
            if (this.isYaml(schemaUri)) {
                JsonNode schemaNode = this.getYamlMapper().readTree(inputStream);
            } else {
                schemaNode222 = this.getJsonMapper().readTree(inputStream);
            }
            JsonMetaSchema jsonMetaSchema = this.getMetaSchemaOrDefault(schemaNode222, config);
            JsonNodePath evaluationPath = new JsonNodePath(config.getPathType());
            if (schemaUri.getFragment() == null || schemaUri.getFragment().getNameCount() == 0) {
                ValidationContext validationContext = new ValidationContext(jsonMetaSchema, this, config);
                JsonSchema jsonSchema = this.doCreate(validationContext, schemaUri, evaluationPath, schemaNode222, null, true);
                return jsonSchema;
            }
            ValidationContext validationContext = this.createValidationContext(schemaNode222, config);
            SchemaLocation documentLocation = new SchemaLocation(schemaUri.getAbsoluteIri());
            JsonSchema document = this.doCreate(validationContext, documentLocation, evaluationPath, schemaNode222, null, false);
            JsonSchema jsonSchema = document.getRefSchema(schemaUri.getFragment());
            return jsonSchema;
        }
        catch (IOException e) {
            logger.error("Failed to load json schema from {}", (Object)schemaUri.getAbsoluteIri(), (Object)e);
            JsonSchemaException exception = new JsonSchemaException("Failed to load json schema from " + schemaUri.getAbsoluteIri());
            exception.initCause(e);
            throw exception;
        }
    }

    public JsonSchema getSchema(URI schemaUri) {
        return this.getSchema(SchemaLocation.of(schemaUri.toString()), this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(SchemaLocation.of(schemaUri.toString()), jsonNode, config);
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode) {
        return this.newJsonSchema(SchemaLocation.of(schemaUri.toString()), jsonNode, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(SchemaLocation schemaUri) {
        return this.getSchema(schemaUri, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(SchemaLocation schemaUri, JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(schemaUri, jsonNode, config);
    }

    public JsonSchema getSchema(SchemaLocation schemaUri, JsonNode jsonNode) {
        return this.newJsonSchema(schemaUri, jsonNode, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(null, jsonNode, config);
    }

    public JsonSchema getSchema(JsonNode jsonNode) {
        return this.newJsonSchema(null, jsonNode, this.createSchemaValidatorsConfig());
    }

    private boolean isYaml(SchemaLocation schemaUri) {
        String schemeSpecificPart = schemaUri.getAbsoluteIri().toString();
        int idx = schemeSpecificPart.lastIndexOf(46);
        if (idx == -1) {
            return false;
        }
        String extension = schemeSpecificPart.substring(idx);
        return ".yml".equals(extension) || ".yaml".equals(extension);
    }

    protected static String normalizeMetaSchemaUri(String id) {
        boolean found = false;
        for (SpecVersion.VersionFlag flag : SpecVersion.VersionFlag.values()) {
            if (!flag.getId().equals(id)) continue;
            found = true;
            break;
        }
        if (!found && id.contains("://json-schema.org/draft")) {
            if (id.contains("/draft-07/")) {
                id = "http://json-schema.org/draft-07/schema#";
            } else if (id.contains("/draft/2019-09/")) {
                id = "https://json-schema.org/draft/2019-09/schema";
            } else if (id.contains("/draft/2020-12/")) {
                id = "https://json-schema.org/draft/2020-12/schema";
            } else if (id.contains("/draft-04/")) {
                id = "http://json-schema.org/draft-04/schema#";
            } else if (id.contains("/draft-06/")) {
                id = "http://json-schema.org/draft-06/schema#";
            }
        }
        return id;
    }

    public static class Builder {
        private ObjectMapper jsonMapper = null;
        private ObjectMapper yamlMapper = null;
        private String defaultMetaSchemaURI;
        private final ConcurrentMap<String, JsonMetaSchema> jsonMetaSchemas = new ConcurrentHashMap<String, JsonMetaSchema>();
        private SchemaLoaders.Builder schemaLoadersBuilder = null;
        private SchemaMappers.Builder schemaMappersBuilder = null;
        private boolean enableUriSchemaCache = true;

        public Builder jsonMapper(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this;
        }

        public Builder yamlMapper(ObjectMapper yamlMapper) {
            this.yamlMapper = yamlMapper;
            return this;
        }

        public Builder defaultMetaSchemaURI(String defaultMetaSchemaURI) {
            this.defaultMetaSchemaURI = defaultMetaSchemaURI;
            return this;
        }

        public Builder addMetaSchema(JsonMetaSchema jsonMetaSchema) {
            this.jsonMetaSchemas.put(JsonSchemaFactory.normalizeMetaSchemaUri(jsonMetaSchema.getUri()), jsonMetaSchema);
            return this;
        }

        public Builder addMetaSchemas(Collection<? extends JsonMetaSchema> jsonMetaSchemas) {
            for (JsonMetaSchema jsonMetaSchema : jsonMetaSchemas) {
                this.addMetaSchema(jsonMetaSchema);
            }
            return this;
        }

        public Builder enableUriSchemaCache(boolean enableUriSchemaCache) {
            this.enableUriSchemaCache = enableUriSchemaCache;
            return this;
        }

        public Builder schemaLoaders(Consumer<SchemaLoaders.Builder> schemaLoadersBuilderCustomizer) {
            if (this.schemaLoadersBuilder == null) {
                this.schemaLoadersBuilder = SchemaLoaders.builder();
            }
            schemaLoadersBuilderCustomizer.accept(this.schemaLoadersBuilder);
            return this;
        }

        public Builder schemaMappers(Consumer<SchemaMappers.Builder> schemaMappersBuilderCustomizer) {
            if (this.schemaMappersBuilder == null) {
                this.schemaMappersBuilder = SchemaMappers.builder();
            }
            schemaMappersBuilderCustomizer.accept(this.schemaMappersBuilder);
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this.jsonMapper, this.yamlMapper, this.defaultMetaSchemaURI, this.schemaLoadersBuilder, this.schemaMappersBuilder, this.jsonMetaSchemas, this.enableUriSchemaCache);
        }
    }
}

