/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.config.Config;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.MediaType;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.Response;
import com.networknt.oas.model.Schema;
import com.networknt.oas.model.impl.SchemaImpl;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.SchemaValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.status.Status;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseValidator {
    private final SchemaValidator schemaValidator = new SchemaValidator(OpenApiHelper.openApi3);
    private final SchemaValidatorsConfig config;
    private static final String VALIDATOR_RESPONSE_CONTENT_UNEXPECTED = "ERR11018";
    private static final String JSON_MEDIA_TYPE = "application/json";
    private static final String GOOD_STATUS_CODE = "200";
    private static final String DEFAULT_STATUS_CODE = "default";
    private static final Logger logger = LoggerFactory.getLogger(ResponseValidator.class);

    public ResponseValidator(SchemaValidatorsConfig config) {
        this.config = config;
    }

    public ResponseValidator() {
        this.config = new SchemaValidatorsConfig();
    }

    public Status validateResponseContent(Object responseContent, String uri, String httpMethod) {
        return this.validateResponseContent(responseContent, uri, httpMethod, GOOD_STATUS_CODE);
    }

    public Status validateResponseContent(Object responseContent, String uri, String httpMethod, String statusCode) {
        return this.validateResponseContent(responseContent, uri, httpMethod, statusCode, JSON_MEDIA_TYPE);
    }

    public Status validateResponseContent(Object responseContent, String uri, String httpMethod, String statusCode, String mediaTypeName) {
        OpenApiOperation operation = null;
        try {
            operation = this.getOpenApiOperation(uri, httpMethod);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
            return new Status(VALIDATOR_RESPONSE_CONTENT_UNEXPECTED, new Object[]{httpMethod, uri});
        }
        if (operation == null) {
            return new Status(VALIDATOR_RESPONSE_CONTENT_UNEXPECTED, new Object[]{httpMethod, uri});
        }
        return this.validateResponseContent(responseContent, operation, statusCode, mediaTypeName);
    }

    public Status validateResponseContent(Object responseContent, OpenApiOperation openApiOperation, String statusCode, String mediaTypeName) {
        JsonNode schema;
        if (responseContent instanceof String) {
            responseContent = this.convertStrToObjTree((String)responseContent);
        }
        if ((schema = this.getContentSchema(openApiOperation, statusCode, mediaTypeName)) == null) {
            schema = this.getContentSchema(openApiOperation, DEFAULT_STATUS_CODE, mediaTypeName);
        }
        if (responseContent != null && schema == null || responseContent == null && schema != null) {
            return new Status(VALIDATOR_RESPONSE_CONTENT_UNEXPECTED, new Object[]{openApiOperation.getMethod(), openApiOperation.getPathString().original()});
        }
        this.config.setTypeLoose(false);
        return this.schemaValidator.validate(responseContent, schema, this.config);
    }

    private Object convertStrToObjTree(String s) {
        Object contentObj;
        block5: {
            contentObj = null;
            if (s != null) {
                s = s.trim();
                try {
                    if (s.startsWith("{")) {
                        contentObj = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                        break block5;
                    }
                    if (s.startsWith("[")) {
                        contentObj = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<Object>>(){});
                        break block5;
                    }
                    logger.error("cannot deserialize json str: {}", (Object)s);
                    return null;
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return contentObj;
    }

    private OpenApiOperation getOpenApiOperation(String uri, String httpMethod) throws URISyntaxException {
        String uriWithoutQuery = new URI(uri).getPath();
        ApiNormalisedPath requestPath = new ApiNormalisedPath(uriWithoutQuery);
        Optional maybeApiPath = OpenApiHelper.findMatchingApiPath((NormalisedPath)requestPath);
        if (!maybeApiPath.isPresent()) {
            return null;
        }
        NormalisedPath openApiPathString = (NormalisedPath)maybeApiPath.get();
        Path path = OpenApiHelper.openApi3.getPath(openApiPathString.original());
        Operation operation = path.getOperation(httpMethod);
        return new OpenApiOperation(openApiPathString, path, httpMethod, operation);
    }

    private JsonNode getContentSchema(OpenApiOperation operation, String statusCode, String mediaTypeStr) {
        Optional<MediaType> mediaType;
        Optional<Response> response = Optional.ofNullable(operation.getOperation().getResponse(String.valueOf(statusCode)));
        if (response.isPresent() && (mediaType = Optional.ofNullable(response.get().getContentMediaType(mediaTypeStr))).isPresent()) {
            Schema schema = mediaType.get().getSchema();
            JsonNode schemaNode = schema == null ? null : Overlay.toJson((JsonOverlay)((SchemaImpl)schema));
            return schemaNode;
        }
        return null;
    }
}

