/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nextapp.echo.app.Component;
import nextapp.echo.app.reflect.ComponentIntrospector;
import nextapp.echo.app.reflect.IntrospectorFactory;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.ComponentSynchronizePeer;
import nextapp.echo.webcontainer.SynchronizePeerFactory;

public abstract class AbstractComponentSynchronizePeer
implements ComponentSynchronizePeer {
    private Set additionalProperties = null;
    private Set stylePropertyNames = null;
    private Set indexedPropertyNames = null;
    private Set referencedProperties = null;
    private Map eventTypeToEventPeer;
    private Set requiredComponentClasses;
    static /* synthetic */ Class class$nextapp$echo$app$update$ClientUpdateManager;

    public AbstractComponentSynchronizePeer() {
        try {
            this.stylePropertyNames = new HashSet();
            this.indexedPropertyNames = new HashSet();
            Class componentClass = this.getComponentClass();
            ComponentIntrospector ci = (ComponentIntrospector)IntrospectorFactory.get((String)componentClass.getName(), (ClassLoader)componentClass.getClassLoader());
            Iterator propertyNameIt = ci.getPropertyNames();
            while (propertyNameIt.hasNext()) {
                String propertyName = (String)propertyNameIt.next();
                if (ci.getStyleConstantName(propertyName) == null) continue;
                this.stylePropertyNames.add(propertyName);
                if (!ci.isIndexedProperty(propertyName)) continue;
                this.indexedPropertyNames.add(propertyName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Internal error.", ex);
        }
    }

    public void addEvent(EventPeer eventPeer) {
        if (this.eventTypeToEventPeer == null) {
            this.eventTypeToEventPeer = new HashMap();
        }
        this.eventTypeToEventPeer.put(eventPeer.getEventType(), eventPeer);
    }

    public void addOutputProperty(String propertyName) {
        this.addOutputProperty(propertyName, false);
    }

    public void addOutputProperty(String propertyName, boolean indexed) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashSet();
        }
        this.additionalProperties.add(propertyName);
        if (indexed) {
            this.indexedPropertyNames.add(propertyName);
        }
    }

    public void addRequiredComponentClass(Class componentClass) {
        if (this.requiredComponentClasses == null) {
            this.requiredComponentClasses = new HashSet();
        }
        this.requiredComponentClasses.add(componentClass);
    }

    public abstract Class getComponentClass();

    public Class getEventDataClass(String eventType) {
        if (this.eventTypeToEventPeer == null) {
            return null;
        }
        EventPeer eventPeer = (EventPeer)this.eventTypeToEventPeer.get(eventType);
        if (eventPeer == null) {
            return null;
        }
        return eventPeer.getEventDataClass();
    }

    public Iterator getEventTypes(Context context, Component component) {
        if (this.eventTypeToEventPeer == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return Collections.unmodifiableSet(this.eventTypeToEventPeer.keySet()).iterator();
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (propertyIndex == -1) {
            return component.getLocalStyle().get(propertyName);
        }
        return component.getLocalStyle().getIndex(propertyName, propertyIndex);
    }

    public Iterator getOutputPropertyIndices(Context context, Component component, String propertyName) {
        return component.getLocalStyle().getPropertyIndices(propertyName);
    }

    public String getOutputPropertyMethodName(Context context, Component component, String propertyName) {
        return null;
    }

    public Iterator getOutputPropertyNames(Context context, Component component) {
        final Iterator styleIterator = component.getLocalStyle().getPropertyNames();
        final Iterator additionalPropertyIterator = this.additionalProperties == null ? null : this.additionalProperties.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return styleIterator.hasNext() || additionalPropertyIterator != null && additionalPropertyIterator.hasNext();
            }

            public Object next() {
                if (styleIterator.hasNext()) {
                    return styleIterator.next();
                }
                return additionalPropertyIterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Class getInputPropertyClass(String propertyName) {
        return null;
    }

    public Iterator getUpdatedOutputPropertyNames(Context context, Component component, ServerComponentUpdate update) {
        if (!update.hasUpdatedProperties()) {
            return Collections.EMPTY_SET.iterator();
        }
        final String[] updatedPropertyNames = update.getUpdatedPropertyNames();
        return new Iterator(){
            private int i = 0;
            private Object nextValue = null;
            {
                this.loadNext();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                if (this.nextValue == null) {
                    throw new IndexOutOfBoundsException();
                }
                Object value = this.nextValue;
                this.loadNext();
                return value;
            }

            private void loadNext() {
                this.nextValue = null;
                while (this.nextValue == null && this.i < updatedPropertyNames.length) {
                    if (AbstractComponentSynchronizePeer.this.stylePropertyNames.contains(updatedPropertyNames[this.i]) || AbstractComponentSynchronizePeer.this.additionalProperties != null && AbstractComponentSynchronizePeer.this.additionalProperties.contains(updatedPropertyNames[this.i])) {
                        this.nextValue = updatedPropertyNames[this.i];
                    }
                    ++this.i;
                }
            }

            public boolean hasNext() {
                return this.nextValue != null;
            }
        };
    }

    public boolean hasListeners(Context context, Component component, String eventType) {
        if (this.eventTypeToEventPeer == null) {
            return false;
        }
        EventPeer eventPeer = (EventPeer)this.eventTypeToEventPeer.get(eventType);
        if (eventPeer == null) {
            return false;
        }
        return eventPeer.hasListeners(context, component);
    }

    public boolean hasUpdatedListeners(Context context, Component component, ServerComponentUpdate update, String eventType) {
        if (this.eventTypeToEventPeer == null) {
            return false;
        }
        EventPeer eventPeer = (EventPeer)this.eventTypeToEventPeer.get(eventType);
        if (eventPeer == null) {
            return false;
        }
        return update.hasUpdatedProperty(eventPeer.getListenerPropertyName());
    }

    public void init(Context context, Component component) {
        if (this.requiredComponentClasses == null) {
            return;
        }
        Iterator componentClassIt = this.requiredComponentClasses.iterator();
        while (componentClassIt.hasNext()) {
            Class componentClass = (Class)componentClassIt.next();
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(componentClass);
            syncPeer.init(context, component);
        }
    }

    public boolean isOutputPropertyIndexed(Context context, Component component, String propertyName) {
        return this.indexedPropertyNames.contains(propertyName);
    }

    public boolean isOutputPropertyReferenced(Context context, Component component, String propertyName) {
        return this.referencedProperties != null && this.referencedProperties.contains(propertyName);
    }

    public void processEvent(Context context, Component component, String eventType, Object eventData) {
        if (this.eventTypeToEventPeer == null) {
            return;
        }
        EventPeer eventPeer = (EventPeer)this.eventTypeToEventPeer.get(eventType);
        if (eventPeer == null) {
            return;
        }
        eventPeer.processEvent(context, component, eventData);
    }

    public void setOutputPropertyReferenced(String propertyName, boolean newValue) {
        if (newValue) {
            if (this.referencedProperties == null) {
                this.referencedProperties = new HashSet();
            }
            this.referencedProperties.add(propertyName);
        } else if (this.referencedProperties != null) {
            this.referencedProperties.remove(propertyName);
        }
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
    }

    public static class EventPeer {
        private Class eventDataClass;
        private String eventType;
        private String listenerPropertyName;

        public EventPeer() {
            this(null, null, null);
        }

        public EventPeer(String eventType, String listenerPropertyName) {
            this(eventType, listenerPropertyName, null);
        }

        public EventPeer(String eventType, String listenerPropertyName, Class eventDataClass) {
            this.eventType = eventType;
            this.listenerPropertyName = listenerPropertyName;
            this.eventDataClass = eventDataClass;
        }

        public String getEventType() {
            return this.eventType;
        }

        public String getListenerPropertyName() {
            return this.listenerPropertyName;
        }

        public Class getEventDataClass() {
            return this.eventDataClass;
        }

        public boolean hasListeners(Context context, Component c) {
            return true;
        }

        public void processEvent(Context context, Component component, Object eventData) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(class$nextapp$echo$app$update$ClientUpdateManager == null ? (class$nextapp$echo$app$update$ClientUpdateManager = AbstractComponentSynchronizePeer.class$("nextapp.echo.app.update.ClientUpdateManager")) : class$nextapp$echo$app$update$ClientUpdateManager);
            clientUpdateManager.setComponentAction(component, this.eventType, eventData);
        }
    }
}

