/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.sync.component;

import nextapp.echo.app.Component;
import nextapp.echo.app.text.TextComponent;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class TextComponentPeer
extends AbstractComponentSynchronizePeer {
    public static final int SYNC_ON_ACTION = 0;
    public static final int SYNC_ON_CHANGE = 1;
    public static final String PROPERTY_SYNC_MODE = "syncMode";
    public static final String PROPERTY_SYNC_DELAY = "syncDelay";
    public static final String PROPERTY_SYNC_INITIAL_DELAY = "syncInitialDelay";
    public static final String INPUT_CHANGE = "change";
    private static final Service TEXT_COMPONENT_SERVICE = JavaScriptService.forResources("Echo.TextComponent", new String[]{"nextapp/echo/webcontainer/resource/Sync.TextComponent.js", "nextapp/echo/webcontainer/resource/Sync.RemoteTextComponent.js"});

    public TextComponentPeer() {
        this.addOutputProperty("text");
        this.addOutputProperty(PROPERTY_SYNC_MODE);
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("action", "actionListeners"){

            public boolean hasListeners(Context context, Component c) {
                return ((TextComponent)c).hasActionListeners();
            }
        });
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer(INPUT_CHANGE, PROPERTY_SYNC_MODE){

            public boolean hasListeners(Context context, Component c) {
                return (Integer)c.getRenderProperty(TextComponentPeer.PROPERTY_SYNC_MODE, (Object)new Integer(0)) == 1;
            }
        });
    }

    public String getClientComponentType(boolean mode) {
        return mode ? "TC" : "TextComponent";
    }

    public Class getComponentClass() {
        return TextComponent.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if ("text".equals(propertyName)) {
            return String.class;
        }
        return null;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (propertyName.equals("text")) {
            TextComponent textComponent = (TextComponent)component;
            return textComponent.getText();
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(TEXT_COMPONENT_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int propertyIndex, Object newValue) {
        if (propertyName.equals("text")) {
            if (newValue == null) {
                newValue = "";
            }
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            if (!Boolean.FALSE.equals(component.getRenderProperty("editable"))) {
                clientUpdateManager.setComponentProperty(component, "text", newValue);
            }
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(TEXT_COMPONENT_SERVICE);
    }
}

