/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.sync.component;

import nextapp.echo.app.Component;
import nextapp.echo.app.button.ToggleButton;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import nextapp.echo.webcontainer.sync.component.AbstractButtonPeer;

public class ToggleButtonPeer
extends AbstractButtonPeer {
    protected static final Service TOGGLE_BUTTON_SERVICE = JavaScriptService.forResource("Echo.ToggleButton", "nextapp/echo/webcontainer/resource/Sync.ToggleButton.js");

    public ToggleButtonPeer() {
        this.addOutputProperty("selected");
    }

    public String getClientComponentType(boolean mode) {
        return mode ? "TB" : "ToggleButton";
    }

    public Class getComponentClass() {
        return ToggleButton.class;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if ("selected".equals(propertyName)) {
            ToggleButton toggleButton = (ToggleButton)component;
            return toggleButton.isSelected();
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public Class getInputPropertyClass(String propertyName) {
        if ("selected".equals(propertyName)) {
            return Boolean.class;
        }
        return super.getInputPropertyClass(propertyName);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(TOGGLE_BUTTON_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        if ("selected".equals(propertyName)) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "selected", newValue);
        } else {
            super.storeInputProperty(context, component, propertyName, index, newValue);
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(TOGGLE_BUTTON_SERVICE);
    }
}

