/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.sync.property;

import nextapp.echo.app.Extent;
import nextapp.echo.app.HttpImageReference;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.property.ExtentPeer;
import nextapp.echo.app.serial.property.ImageReferencePeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class HttpImageReferencePeer
implements ImageReferencePeer {
    public String getImageUrl(Context context, ImageReference imageReference) throws SerialException {
        HttpImageReference httpImageReference = (HttpImageReference)imageReference;
        return httpImageReference.getUri();
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        Element iElement = DomUtil.getChildElementByTagName((Element)propertyElement, (String)"i");
        if (iElement == null) {
            return new HttpImageReference(DomUtil.getElementText((Element)propertyElement));
        }
        String url = DomUtil.getElementText((Element)iElement);
        if (url == null) {
            url = iElement.getAttribute("u");
        }
        Extent width = iElement.hasAttribute("w") ? ExtentPeer.fromString((String)iElement.getAttribute("w")) : null;
        Extent height = iElement.hasAttribute("h") ? ExtentPeer.fromString((String)iElement.getAttribute("h")) : null;
        HttpImageReference httpImage = new HttpImageReference(url, width, height);
        return httpImage;
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        HttpImageReference httpImage = (HttpImageReference)propertyValue;
        propertyElement.setAttribute("t", (serialContext.getFlags() & 1) == 0 ? "ImageReference" : "I");
        Text urlText = serialContext.getDocument().createTextNode(httpImage.getUri());
        Extent width = httpImage.getWidth();
        Extent height = httpImage.getHeight();
        if (width == null && height == null) {
            propertyElement.appendChild(urlText);
        } else {
            Element iElement = serialContext.getDocument().createElement("i");
            iElement.appendChild(urlText);
            if (width != null) {
                iElement.setAttribute("w", ExtentPeer.toString((Extent)width));
            }
            if (height != null) {
                iElement.setAttribute("h", ExtentPeer.toString((Extent)height));
            }
            propertyElement.appendChild(iElement);
        }
    }
}

