/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Resource {
    private static final int BUFFER_SIZE = 4096;

    public static String getResourceAsString(String resourceName) {
        return Resource.getResource(resourceName).toString();
    }

    public static byte[] getResourceAsByteArray(String resourceName) {
        return Resource.getResource(resourceName).toByteArray();
    }

    private static ByteArrayOutputStream getResource(String resourceName) {
        InputStream in = null;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream out = null;
        int bytesRead = 0;
        try {
            in = Resource.class.getClassLoader().getResourceAsStream(resourceName);
            if (in == null) {
                throw new ResourceException("Resource does not exist: \"" + resourceName + "\".", null);
            }
            out = new ByteArrayOutputStream();
            do {
                if ((bytesRead = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
        }
        catch (IOException ex) {
            throw new ResourceException("Cannot get resource: \"" + resourceName + "\".", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
        return out;
    }

    private Resource() {
    }

    public static class ResourceException
    extends RuntimeException {
        private static final long serialVersionUID = 20070101L;

        private ResourceException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

