/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JWK;
import com.nimbusds.jose.ReadOnlyCommonSEHeader;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public abstract class CommonSEHeader
extends Header
implements ReadOnlyCommonSEHeader {
    private URL jku;
    private JWK jwk;
    private URL x5u;
    private Base64URL x5t;
    private Base64[] x5c;
    private String kid;

    protected CommonSEHeader(Algorithm alg) {
        super(alg);
    }

    public URL getJWKURL() {
        return this.jku;
    }

    public void setJWKURL(URL jku) {
        this.jku = jku;
    }

    public JWK getJWK() {
        return this.jwk;
    }

    public void setJWK(JWK jwk) {
        this.jwk = jwk;
    }

    public URL getX509CertURL() {
        return this.x5u;
    }

    public void setX509CertURL(URL x5u) {
        this.x5u = x5u;
    }

    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public void setX509CertThumbprint(Base64URL x5t) {
        this.x5t = x5t;
    }

    public Base64[] getX509CertChain() {
        return this.x5c;
    }

    public void setX509CertChain(Base64[] x5c) {
        this.x5c = x5c;
    }

    public String getKeyID() {
        return this.kid;
    }

    public void setKeyID(String kid) {
        this.kid = kid;
    }

    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        if (this.jku != null) {
            o.put((Object)"jku", (Object)this.jku.toString());
        }
        if (this.jwk != null) {
            o.put((Object)"jwk", (Object)this.jwk.toJSONObject());
        }
        if (this.x5u != null) {
            o.put((Object)"x5u", (Object)this.x5u.toString());
        }
        if (this.x5t != null) {
            o.put((Object)"x5t", (Object)this.x5t.toString());
        }
        if (this.x5c != null) {
            o.put((Object)"x5c", Arrays.asList(this.x5c));
        }
        if (this.kid != null) {
            o.put((Object)"kid", (Object)this.kid);
        }
        return o;
    }

    protected static Base64[] parseX509CertChain(JSONArray jsonArray) throws ParseException {
        Base64[] chain = new Base64[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object item = jsonArray.get(i);
            if (item == null) {
                throw new ParseException("The X.509 certificate at position " + i + " must not be null", 0);
            }
            if (!(item instanceof String)) {
                throw new ParseException("The X.509 certificate must be encoded as a Base64 string", 0);
            }
            chain[i] = new Base64((String)item);
        }
        return chain;
    }
}

