/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEAlgorithmProvider;
import java.security.Key;
import java.security.Provider;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RSAProvider
implements JWEAlgorithmProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;

    RSAProvider() {
    }

    @Override
    public Set<JWEAlgorithm> supportedAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return SUPPORTED_ENCRYPTION_METHODS;
    }

    protected int keyLengthForMethod(EncryptionMethod method) {
        if (method.equals(EncryptionMethod.A128CBC_HS256) || method.equals(EncryptionMethod.A128GCM)) {
            return 128;
        }
        if (method.equals(EncryptionMethod.A256GCM) || method.equals(EncryptionMethod.A256CBC_HS512)) {
            return 256;
        }
        throw new IllegalArgumentException("Unsupported encryption method, must be A128GCM, A256GCM, A128CBC_HS256 or A256CBC_HS512");
    }

    protected byte[] aesgcmDecrypt(IvParameterSpec ivParamSpec, SecretKey secretKey, byte[] cipherText) throws JOSEException {
        return this.aesgcm(ivParamSpec, secretKey, cipherText, 2);
    }

    protected byte[] aesgcmEncrypt(IvParameterSpec ivParamSpec, SecretKey secretKey, byte[] cipherText) throws JOSEException {
        return this.aesgcm(ivParamSpec, secretKey, cipherText, 1);
    }

    private byte[] aesgcm(IvParameterSpec ivParamSpec, SecretKey secretKey, byte[] cipherText, int encryptMode) throws JOSEException {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", (Provider)new BouncyCastleProvider());
            cipher.init(encryptMode, (Key)secretKey, ivParamSpec);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage());
        }
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.RSA_OAEP);
        algs.add(JWEAlgorithm.RSA1_5);
        SUPPORTED_ALGORITHMS = algs;
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A256GCM);
        methods.add(EncryptionMethod.A128GCM);
        SUPPORTED_ENCRYPTION_METHODS = methods;
    }
}

