/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import javax.crypto.SecretKey;
import net.jcip.annotations.Immutable;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

class AESGCM {
    public static final int IV_BIT_LENGTH = 96;
    public static final int AUTH_TAG_BIT_LENGTH = 128;

    AESGCM() {
    }

    private static AESEngine createAESCipher(SecretKey secretKey, boolean forEncryption) {
        AESEngine cipher = new AESEngine();
        KeyParameter cipherParams = new KeyParameter(secretKey.getEncoded());
        cipher.init(forEncryption, (CipherParameters)cipherParams);
        return cipher;
    }

    private static GCMBlockCipher createAESGCMCipher(SecretKey secretKey, boolean forEncryption, byte[] iv, byte[] authData) {
        AESEngine cipher = AESGCM.createAESCipher(secretKey, forEncryption);
        GCMBlockCipher gcm = new GCMBlockCipher((BlockCipher)cipher);
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(secretKey.getEncoded()), 128, iv, authData);
        gcm.init(forEncryption, (CipherParameters)aeadParams);
        return gcm;
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] cipherText, byte[] authData, byte[] authTag, byte[] iv) throws JOSEException {
        GCMBlockCipher cipher = AESGCM.createAESGCMCipher(secretKey, false, iv, authData);
        byte[] input = new byte[cipherText.length + authTag.length];
        System.arraycopy(cipherText, 0, input, 0, cipherText.length);
        System.arraycopy(authTag, 0, input, cipherText.length, authTag.length);
        int outputLength = cipher.getOutputSize(input.length);
        byte[] output = new byte[outputLength];
        int outputOffset = cipher.processBytes(input, 0, input.length, output, 0);
        try {
            outputOffset += cipher.doFinal(output, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new JOSEException("Couldn't validate GCM authentication tag: " + e.getMessage(), e);
        }
        return output;
    }

    public static Result encrypt(SecretKey secretKey, byte[] plainText, byte[] authData, byte[] iv) throws JOSEException {
        GCMBlockCipher cipher = AESGCM.createAESGCMCipher(secretKey, true, iv, authData);
        int outputLength = cipher.getOutputSize(plainText.length);
        byte[] output = new byte[outputLength];
        int outputOffset = cipher.processBytes(plainText, 0, plainText.length, output, 0);
        try {
            outputOffset += cipher.doFinal(output, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new JOSEException("Couldn't generate GCM authentication tag: " + e.getMessage(), e);
        }
        int authTagLength = 16;
        byte[] cipherText = new byte[outputOffset - authTagLength];
        byte[] authTag = new byte[authTagLength];
        System.arraycopy(output, 0, cipherText, 0, cipherText.length);
        System.arraycopy(output, outputOffset - authTagLength, authTag, 0, authTag.length);
        return new Result(cipherText, authTag);
    }

    @Immutable
    public static class Result {
        private final byte[] cipherText;
        private final byte[] authTag;

        public Result(byte[] cipherText, byte[] authTag) {
            this.cipherText = cipherText;
            this.authTag = authTag;
        }

        public byte[] getCipherText() {
            return this.cipherText;
        }

        public byte[] getAuthenticationTag() {
            return this.authTag;
        }
    }
}

