/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.ECKey;
import com.nimbusds.jose.KeyType;
import com.nimbusds.jose.RSAKey;
import com.nimbusds.jose.Use;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public abstract class JWK
implements JSONAware {
    private final KeyType kty;
    private final Use use;
    private final Algorithm alg;
    private final String kid;

    public JWK(KeyType kty, Use use, Algorithm alg, String kid) {
        if (kty == null) {
            throw new IllegalArgumentException("The key type \"kty\" must not be null");
        }
        this.kty = kty;
        this.use = use;
        this.alg = alg;
        this.kid = kid;
    }

    public KeyType getKeyType() {
        return this.kty;
    }

    public Use getKeyUse() {
        return this.use;
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public String getKeyID() {
        return this.kid;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"kty", (Object)this.kty.getValue());
        if (this.use != null) {
            if (this.use == Use.SIGNATURE) {
                o.put((Object)"use", (Object)"sig");
            }
            if (this.use == Use.ENCRYPTION) {
                o.put((Object)"use", (Object)"enc");
            }
        }
        if (this.alg != null) {
            o.put((Object)"alg", (Object)this.alg.getName());
        }
        if (this.kid != null) {
            o.put((Object)"kid", (Object)this.kid);
        }
        return o;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWK parse(String s) throws ParseException {
        return JWK.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static JWK parse(JSONObject jsonObject) throws ParseException {
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty == KeyType.EC) {
            return ECKey.parse(jsonObject);
        }
        if (kty == KeyType.RSA) {
            return RSAKey.parse(jsonObject);
        }
        throw new ParseException("Unsupported key type \"kty\" parameter: " + kty, 0);
    }

    protected static Use parseKeyUse(JSONObject jsonObject) throws ParseException {
        if (jsonObject.get((Object)"use") == null) {
            return null;
        }
        String useStr = JSONObjectUtils.getString(jsonObject, "use");
        if (useStr.equals("sig")) {
            return Use.SIGNATURE;
        }
        if (useStr.equals("enc")) {
            return Use.ENCRYPTION;
        }
        throw new ParseException("Invalid or unsupported key use \"use\" parameter, must be \"sig\" or \"enc\"", 0);
    }

    protected static Algorithm parseAlgorithm(JSONObject jsonObject) throws ParseException {
        if (jsonObject.get((Object)"alg") == null) {
            return null;
        }
        String algStr = JSONObjectUtils.getString(jsonObject, "alg");
        return new Algorithm(algStr);
    }

    protected static String parseKeyID(JSONObject jsonObject) throws ParseException {
        if (jsonObject.get((Object)"kid") == null) {
            return null;
        }
        return JSONObjectUtils.getString(jsonObject, "kid");
    }
}

