/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertChainUtils;
import java.net.URI;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONObject;

final class JWKMetadata {
    JWKMetadata() {
    }

    public static KeyType parseKeyType(JSONObject o) throws ParseException {
        return KeyType.parse(JSONObjectUtils.getString(o, "kty"));
    }

    public static KeyUse parseKeyUse(JSONObject o) throws ParseException {
        if (o.containsKey((Object)"use")) {
            return KeyUse.parse(JSONObjectUtils.getString(o, "use"));
        }
        return null;
    }

    public static Set<KeyOperation> parseKeyOperations(JSONObject o) throws ParseException {
        if (o.containsKey((Object)"key_ops")) {
            return KeyOperation.parse(JSONObjectUtils.getStringList(o, "key_ops"));
        }
        return null;
    }

    public static Algorithm parseAlgorithm(JSONObject o) throws ParseException {
        if (o.containsKey((Object)"alg")) {
            return new Algorithm(JSONObjectUtils.getString(o, "alg"));
        }
        return null;
    }

    public static String parseKeyID(JSONObject o) throws ParseException {
        if (o.containsKey((Object)"kid")) {
            return JSONObjectUtils.getString(o, "kid");
        }
        return null;
    }

    public static URI parseX509CertURL(JSONObject o) throws ParseException {
        if (o.containsKey((Object)"x5u")) {
            return JSONObjectUtils.getURI(o, "x5u");
        }
        return null;
    }

    public static Base64URL parseX509CertThumbprint(JSONObject o) throws ParseException {
        if (o.containsKey((Object)"x5t")) {
            return new Base64URL(JSONObjectUtils.getString(o, "x5t"));
        }
        return null;
    }

    public static List<Base64> parseX509CertChain(JSONObject o) throws ParseException {
        if (o.containsKey((Object)"x5c")) {
            return X509CertChainUtils.parseX509CertChain(JSONObjectUtils.getJSONArray(o, "x5c"));
        }
        return null;
    }
}

