/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt.proc;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsVerifier;
import java.util.Date;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWTClaimsVerifier
implements JWTClaimsVerifier {
    private static final BadJWTException EXPIRED_JWT_EXCEPTION = new BadJWTException("Expired JWT");
    private static final BadJWTException JWT_BEFORE_USE_EXCEPTION = new BadJWTException("JWT before use time");

    @Override
    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        Date now = new Date();
        Date exp = claimsSet.getExpirationTime();
        if (exp != null && now.after(exp)) {
            throw EXPIRED_JWT_EXCEPTION;
        }
        Date nbf = claimsSet.getNotBeforeTime();
        if (nbf != null && now.before(nbf)) {
            throw JWT_BEFORE_USE_EXCEPTION;
        }
    }
}

