/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class AuthorizationSuccessResponse
extends AuthorizationResponse
implements SuccessResponse {
    private final AuthorizationCode code;
    private final AccessToken accessToken;

    public AuthorizationSuccessResponse(URL redirectURI, AuthorizationCode code, State state) {
        this(redirectURI, code, null, state);
        if (code == null) {
            throw new IllegalArgumentException("The authorization code must not be null");
        }
    }

    public AuthorizationSuccessResponse(URL redirectURI, AccessToken accessToken, State state) {
        this(redirectURI, null, accessToken, state);
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    public AuthorizationSuccessResponse(URL redirectURI, AuthorizationCode code, AccessToken accessToken, State state) {
        super(redirectURI, state);
        this.code = code;
        this.accessToken = accessToken;
    }

    public ResponseType getImpliedResponseType() {
        ResponseType rt = new ResponseType();
        if (this.code != null) {
            rt.add(ResponseType.Value.CODE);
        }
        if (this.accessToken != null) {
            rt.add(ResponseType.Value.TOKEN);
        }
        return rt;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Map<String, String> toParameters() throws SerializeException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.code != null) {
            params.put("code", this.code.getValue());
        }
        if (this.accessToken != null) {
            for (Map.Entry entry : this.accessToken.toJSONObject().entrySet()) {
                params.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        if (this.getState() != null) {
            params.put("state", this.getState().getValue());
        }
        return params;
    }

    @Override
    public URL toURI() throws SerializeException {
        StringBuilder sb = new StringBuilder(this.getRedirectURI().toString());
        if (this.accessToken != null) {
            sb.append('#');
        } else {
            sb.append('?');
        }
        sb.append(URLUtils.serializeParameters(this.toParameters()));
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new SerializeException("Couldn't serialize response: " + e.getMessage(), e);
        }
    }

    public static AuthorizationSuccessResponse parse(URL redirectURI, Map<String, String> params) throws ParseException {
        AuthorizationCode code = null;
        if (params.get("code") != null) {
            code = new AuthorizationCode(params.get("code"));
        }
        AccessToken accessToken = null;
        if (params.get("access_token") != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll(params);
            accessToken = AccessToken.parse(jsonObject);
        }
        State state = State.parse(params.get("state"));
        return new AuthorizationSuccessResponse(redirectURI, code, accessToken, state);
    }

    public static AuthorizationSuccessResponse parse(URL uri) throws ParseException {
        String paramString = null;
        if (uri.getQuery() != null) {
            paramString = uri.getQuery();
        } else if (uri.getRef() != null) {
            paramString = uri.getRef();
        } else {
            throw new ParseException("Missing authorization response parameters");
        }
        Map<String, String> params = URLUtils.parseParameters(paramString);
        if (params == null) {
            throw new ParseException("Missing or invalid authorization response parameters");
        }
        return AuthorizationSuccessResponse.parse(URLUtils.getBaseURL(uri), params);
    }

    public static AuthorizationSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 302) {
            throw new ParseException("Unexpected HTTP status code, must be 302 (Found): " + httpResponse.getStatusCode());
        }
        URL location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirect URL / HTTP Location header");
        }
        return AuthorizationSuccessResponse.parse(location);
    }
}

