/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class Secret {
    private byte[] value;
    private final Date expDate;

    public Secret(String value) {
        this(value, null);
    }

    public Secret(byte[] value) {
        this(value, null);
    }

    public Secret(String value, Date expDate) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("The value must not be null or empty string");
        }
        this.value = value.getBytes(Charset.forName("utf-8"));
        this.expDate = expDate;
    }

    public Secret(byte[] value, Date expDate) {
        if (ArrayUtils.isEmpty((byte[])value)) {
            throw new IllegalArgumentException("The value must not be null or empty array");
        }
        this.value = value;
        this.expDate = expDate;
    }

    public Secret(int length) {
        this(RandomStringUtils.randomAlphanumeric((int)length));
    }

    public Secret() {
        this(32);
    }

    public String getValue() {
        if (ArrayUtils.isEmpty((byte[])this.value)) {
            return null;
        }
        return new String(this.value, Charset.forName("utf-8"));
    }

    public byte[] getValueBytes() {
        return this.value;
    }

    public void erase() {
        if (ArrayUtils.isEmpty((byte[])this.value)) {
            return;
        }
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
        this.value = null;
    }

    public Date getExpirationDate() {
        return this.expDate;
    }

    public boolean expired() {
        if (this.expDate == null) {
            return false;
        }
        Date now = new Date();
        return !this.expDate.after(now);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Secret && this.getValue().equals(((Secret)object).getValue());
    }
}

