/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.net.URL;
import net.jcip.annotations.Immutable;

@Immutable
public final class UserInfoRequest
extends ProtectedResourceRequest {
    private final HTTPRequest.Method httpMethod;

    public UserInfoRequest(URL uri, BearerAccessToken accessToken) {
        this(uri, HTTPRequest.Method.GET, accessToken);
    }

    public UserInfoRequest(URL uri, HTTPRequest.Method httpMethod, BearerAccessToken accessToken) {
        super(uri, accessToken);
        if (httpMethod == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.httpMethod = httpMethod;
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    public HTTPRequest.Method getMethod() {
        return this.httpMethod;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        if (this.getURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(this.httpMethod, this.getURI());
        switch (this.httpMethod) {
            case GET: {
                httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
                httpRequest.setQuery("schema=openid");
                break;
            }
            case POST: {
                httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
                httpRequest.setQuery("schema=openid&access_token=" + this.getAccessToken().getValue());
                break;
            }
            default: {
                throw new SerializeException("Unexpected HTTP method: " + (Object)((Object)this.httpMethod));
            }
        }
        return httpRequest;
    }

    public static UserInfoRequest parse(HTTPRequest httpRequest) throws ParseException {
        HTTPRequest.Method httpMethod = httpRequest.getMethod();
        BearerAccessToken accessToken = BearerAccessToken.parse(httpRequest);
        return new UserInfoRequest(httpRequest.getURL(), httpMethod, accessToken);
    }
}

