/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class AuthorizationSuccessResponse
extends AuthorizationResponse
implements SuccessResponse {
    private final AuthorizationCode code;
    private final AccessToken accessToken;

    public AuthorizationSuccessResponse(URI redirectURI, AuthorizationCode code, AccessToken accessToken, State state, ResponseMode rm) {
        super(redirectURI, state, rm);
        this.code = code;
        this.accessToken = accessToken;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public ResponseType impliedResponseType() {
        ResponseType rt = new ResponseType();
        if (this.code != null) {
            rt.add(ResponseType.Value.CODE);
        }
        if (this.accessToken != null) {
            rt.add(ResponseType.Value.TOKEN);
        }
        return rt;
    }

    @Override
    public ResponseMode impliedResponseMode() {
        if (this.getResponseMode() != null) {
            return this.getResponseMode();
        }
        if (this.accessToken != null) {
            return ResponseMode.FRAGMENT;
        }
        return ResponseMode.QUERY;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Map<String, String> toParameters() throws SerializeException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.code != null) {
            params.put("code", this.code.getValue());
        }
        if (this.accessToken != null) {
            for (Map.Entry entry : this.accessToken.toJSONObject().entrySet()) {
                params.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        if (this.getState() != null) {
            params.put("state", this.getState().getValue());
        }
        return params;
    }

    public static AuthorizationSuccessResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        AuthorizationCode code = null;
        if (params.get("code") != null) {
            code = new AuthorizationCode(params.get("code"));
        }
        AccessToken accessToken = null;
        if (params.get("access_token") != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll(params);
            accessToken = AccessToken.parse(jsonObject);
        }
        State state = State.parse(params.get("state"));
        return new AuthorizationSuccessResponse(redirectURI, code, accessToken, state, null);
    }

    public static AuthorizationSuccessResponse parse(URI uri) throws ParseException {
        Map<String, String> params;
        if (uri.getRawFragment() != null) {
            params = URLUtils.parseParameters(uri.getRawFragment());
        } else if (uri.getRawQuery() != null) {
            params = URLUtils.parseParameters(uri.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthorizationSuccessResponse.parse(URIUtils.getBaseURI(uri), params);
    }

    public static AuthorizationSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        URI location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirection URL / HTTP Location header");
        }
        return AuthorizationSuccessResponse.parse(location);
    }

    public static AuthorizationSuccessResponse parse(HTTPRequest httpRequest) throws ParseException {
        URI baseURI;
        try {
            baseURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (httpRequest.getQuery() != null) {
            return AuthorizationSuccessResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getQuery()));
        }
        if (httpRequest.getFragment() != null) {
            return AuthorizationSuccessResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }
}

