/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase;

import com.alipay.oceanbase.hbase.constants.OHConstants;
import com.alipay.oceanbase.hbase.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.hbase.exception.OperationTimeoutException;
import com.alipay.oceanbase.hbase.execute.ServerCallable;
import com.alipay.oceanbase.hbase.filter.HBaseFilterUtils;
import com.alipay.oceanbase.hbase.result.ClientStreamScanner;
import com.alipay.oceanbase.hbase.util.OHBaseFuncUtils;
import com.alipay.oceanbase.hbase.util.ObTableClientManager;
import com.alipay.oceanbase.hbase.util.Preconditions;
import com.alipay.oceanbase.hbase.util.TableHBaseLoggerFactory;
import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableAbstractOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutate;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObHTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncRequest;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryAsyncStreamResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;

public class OHTable
implements HTableInterface {
    private static final Logger logger = TableHBaseLoggerFactory.getLogger(OHTable.class);
    private final ObTableClient obTableClient;
    private final byte[] tableName;
    private final String tableNameString;
    private int operationTimeout;
    private boolean cleanupPoolOnClose = true;
    private boolean closeClientOnClose = true;
    private final ExecutorService executePool;
    private final int maxThreads;
    private final long keepAliveTime;
    private boolean operationExecuteInPool = false;
    private final ArrayList<Put> writeBuffer = new ArrayList();
    private long writeBufferSize;
    private int putWriteBufferCheck;
    private boolean clearBufferOnFail = true;
    private boolean autoFlush = true;
    private long currentWriteBufferSize;
    private int maxKeyValueSize;
    private final Configuration configuration;

    public OHTable(Configuration configuration, String tableName) throws IOException {
        Preconditions.checkArgument(configuration != null, "configuration is null.");
        Preconditions.checkArgument(StringUtils.isNotBlank((String)tableName), "tableNameString is blank.");
        this.configuration = configuration;
        this.tableName = tableName.getBytes();
        this.tableNameString = tableName;
        this.maxThreads = configuration.getInt("hbase.htable.privatethreads.max", Integer.MAX_VALUE);
        this.keepAliveTime = configuration.getLong("hbase.htable.threads.keepalivetime", 60L);
        this.executePool = OHTable.createDefaultThreadPoolExecutor(1, this.maxThreads, this.keepAliveTime);
        this.obTableClient = ObTableClientManager.getOrCreateObTableClient(configuration);
        this.finishSetUp();
    }

    public OHTable(Configuration configuration, byte[] tableName) throws IOException {
        this(configuration, Arrays.toString(tableName));
    }

    public OHTable(Configuration configuration, byte[] tableName, ExecutorService executePool) throws IOException {
        Preconditions.checkArgument(configuration != null, "configuration is null.");
        Preconditions.checkArgument(tableName != null, "tableNameString is blank.");
        Preconditions.checkArgument(executePool != null && !executePool.isShutdown(), "executePool is null or executePool is shutdown");
        this.configuration = configuration;
        this.executePool = executePool;
        this.tableName = tableName;
        this.tableNameString = Bytes.toString((byte[])tableName);
        this.cleanupPoolOnClose = false;
        this.maxThreads = configuration.getInt("hbase.htable.privatethreads.max", Integer.MAX_VALUE);
        this.keepAliveTime = configuration.getLong("hbase.htable.threads.keepalivetime", 60L);
        this.obTableClient = ObTableClientManager.getOrCreateObTableClient(configuration);
        this.finishSetUp();
    }

    public OHTable(byte[] tableName, ObTableClient obTableClient, ExecutorService executePool) {
        Preconditions.checkArgument(tableName != null, "tableNameString is blank.");
        Preconditions.checkArgument(executePool != null && !executePool.isShutdown(), "executePool is null or executePool is shutdown");
        this.tableName = tableName;
        this.tableNameString = Bytes.toString((byte[])tableName);
        this.cleanupPoolOnClose = false;
        this.closeClientOnClose = false;
        this.maxThreads = Integer.MAX_VALUE;
        this.keepAliveTime = 60L;
        this.executePool = executePool;
        this.obTableClient = obTableClient;
        this.configuration = new Configuration();
        this.finishSetUp();
    }

    public static ThreadPoolExecutor createDefaultThreadPoolExecutor(int coreSize, int maxThreads, long keepAliveTime) {
        if (System.getProperty("sofa_thread_pool_logging_capability") == null) {
            System.setProperty("sofa_thread_pool_logging_capability", "false");
        }
        SofaThreadPoolExecutor executor = new SofaThreadPoolExecutor(coreSize, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue(), "OHTableDefaultExecutePool", "oceanbase-table-hbase");
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private void finishSetUp() {
        Preconditions.checkArgument(this.configuration != null, "configuration is null.");
        Preconditions.checkArgument(this.tableName != null, "tableNameString is null.");
        Preconditions.checkArgument(this.tableNameString != null, "tableNameString is null.");
        this.operationTimeout = this.configuration.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
        this.operationExecuteInPool = this.configuration.getBoolean("hbase.client.operation.executeinpool", this.operationTimeout != Integer.MAX_VALUE);
        this.maxKeyValueSize = this.configuration.getInt("hbase.client.keyvalue.maxsize", -1);
        this.putWriteBufferCheck = this.configuration.getInt("hbase.htable.put.write.buffer.check", 10);
        this.writeBufferSize = this.configuration.getLong("hbase.client.write.buffer", 0x200000L);
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HTableDescriptor getTableDescriptor() {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public boolean exists(Get get) throws IOException {
        Result r = this.get(get);
        return !r.isEmpty();
    }

    public void batch(List<? extends Row> actions, Object[] results) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public Object[] batch(List<? extends Row> actions) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public void getKeyValueFromResult(AbstractQueryStreamResult clientQueryStreamResult, List<KeyValue> keyValueList, boolean isTableGroup, byte[] family) throws Exception {
        Object familyAndQualifier = new byte[2][];
        while (clientQueryStreamResult.next()) {
            List row = clientQueryStreamResult.getRow();
            if (isTableGroup) {
                familyAndQualifier = OHBaseFuncUtils.extractFamilyFromQualifier((byte[])((ObObj)row.get(1)).getValue());
            } else {
                familyAndQualifier[0] = family;
                familyAndQualifier[1] = (byte[])((ObObj)row.get(1)).getValue();
            }
            KeyValue kv = new KeyValue((byte[])((ObObj)row.get(0)).getValue(), familyAndQualifier[0], familyAndQualifier[1], ((Long)((ObObj)row.get(2)).getValue()).longValue(), (byte[])((ObObj)row.get(3)).getValue());
            keyValueList.add(kv);
        }
    }

    public Result get(final Get get) throws IOException {
        if (get.getFamilyMap().keySet() != null && get.getFamilyMap().keySet().size() != 0) {
            this.checkFamilyViolation(get.getFamilyMap().keySet());
        }
        ServerCallable<Result> serverCallable = new ServerCallable<Result>(this.configuration, this.obTableClient, this.tableNameString, get.getRow(), get.getRow(), this.operationTimeout){

            @Override
            public Result call() throws IOException {
                ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>();
                byte[] family = new byte[]{};
                try {
                    if (get.getFamilyMap().keySet() == null || get.getFamilyMap().keySet().size() == 0) {
                        ObHTableFilter filter = OHTable.this.buildObHTableFilter(get.getFilter(), get.getTimeRange(), get.getMaxVersions(), null);
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, get.getRow(), true, get.getRow(), true, -1);
                        ObTableQueryRequest request = OHTable.this.buildObTableQueryRequest(obTableQuery, this.tableNameString);
                        ObTableClientQueryStreamResult clientQueryStreamResult = (ObTableClientQueryStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                        OHTable.this.getKeyValueFromResult((AbstractQueryStreamResult)clientQueryStreamResult, keyValueList, true, family);
                    } else {
                        for (Map.Entry entry : get.getFamilyMap().entrySet()) {
                            family = (byte[])entry.getKey();
                            ObHTableFilter filter = OHTable.this.buildObHTableFilter(get.getFilter(), get.getTimeRange(), get.getMaxVersions(), (Collection)entry.getValue());
                            ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, get.getRow(), true, get.getRow(), true, -1);
                            ObTableQueryRequest request = OHTable.this.buildObTableQueryRequest(obTableQuery, OHTable.this.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family)));
                            ObTableClientQueryStreamResult clientQueryStreamResult = (ObTableClientQueryStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                            OHTable.this.getKeyValueFromResult((AbstractQueryStreamResult)clientQueryStreamResult, keyValueList, false, family);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(TableHBaseLoggerFactory.LCD.convert("01-00002"), new Object[]{this.tableNameString, Bytes.toString((byte[])family), e});
                    throw new IOException("query table:" + this.tableNameString + " family " + Bytes.toString((byte[])family) + " error.", e);
                }
                return new Result(keyValueList);
            }
        };
        return this.executeServerCallable(serverCallable);
    }

    public Result[] get(List<Get> gets) throws IOException {
        Result[] results = new Result[gets.size()];
        for (int i = 0; i < gets.size(); ++i) {
            results[i] = this.get(gets.get(i));
        }
        return results;
    }

    public Result getRowOrBefore(byte[] row, byte[] family) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public ResultScanner getScanner(final Scan scan) throws IOException {
        if (scan.getFamilyMap().keySet() != null && scan.getFamilyMap().keySet().size() != 0) {
            this.checkFamilyViolation(scan.getFamilyMap().keySet());
        }
        ServerCallable<ResultScanner> serverCallable = new ServerCallable<ResultScanner>(this.configuration, this.obTableClient, this.tableNameString, scan.getStartRow(), scan.getStopRow(), this.operationTimeout){

            @Override
            public ResultScanner call() throws IOException {
                byte[] family = new byte[]{};
                try {
                    if (scan.getFamilyMap().keySet() == null || scan.getFamilyMap().keySet().size() == 0) {
                        ObHTableFilter filter = OHTable.this.buildObHTableFilter(scan.getFilter(), scan.getTimeRange(), scan.getMaxVersions(), null);
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, scan.getStartRow(), true, scan.getStopRow(), false, scan.getBatch());
                        ObTableQueryAsyncRequest request = OHTable.this.buildObTableQueryAsyncRequest(obTableQuery, this.tableNameString);
                        ObTableClientQueryAsyncStreamResult clientQueryAsyncStreamResult = (ObTableClientQueryAsyncStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                        return new ClientStreamScanner(clientQueryAsyncStreamResult, this.tableNameString, family, true);
                    }
                    Iterator iterator = scan.getFamilyMap().entrySet().iterator();
                    if (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        family = (byte[])entry.getKey();
                        ObHTableFilter filter = OHTable.this.buildObHTableFilter(scan.getFilter(), scan.getTimeRange(), scan.getMaxVersions(), (Collection)entry.getValue());
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, scan.getStartRow(), true, scan.getStopRow(), false, scan.getBatch());
                        ObTableQueryAsyncRequest request = OHTable.this.buildObTableQueryAsyncRequest(obTableQuery, OHTable.this.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family)));
                        ObTableClientQueryAsyncStreamResult clientQueryAsyncStreamResult = (ObTableClientQueryAsyncStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                        return new ClientStreamScanner(clientQueryAsyncStreamResult, this.tableNameString, family, false);
                    }
                }
                catch (Exception e) {
                    logger.error(TableHBaseLoggerFactory.LCD.convert("01-00003"), new Object[]{this.tableNameString, Bytes.toString((byte[])family), e});
                    throw new IOException("scan table:" + this.tableNameString + " family " + Bytes.toString((byte[])family) + " error.", e);
                }
                throw new IOException("scan table:" + this.tableNameString + "has no family");
            }
        };
        return this.executeServerCallable(serverCallable);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put) throws IOException {
        this.doPut(Collections.singletonList(put));
    }

    public void put(List<Put> puts) throws IOException {
        this.doPut(puts);
    }

    private void doPut(List<Put> puts) throws IOException {
        int n = 0;
        for (Put put : puts) {
            this.validatePut(put);
            this.checkFamilyViolation(put.getFamilyMap().keySet());
            this.writeBuffer.add(put);
            this.currentWriteBufferSize += put.heapSize();
            if (++n % this.putWriteBufferCheck != 0 || this.currentWriteBufferSize <= this.writeBufferSize) continue;
            this.flushCommits();
        }
        if (this.autoFlush || this.currentWriteBufferSize > this.writeBufferSize) {
            this.flushCommits();
        }
    }

    private void validatePut(Put put) {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (this.maxKeyValueSize > 0) {
            for (Map.Entry entry : put.getFamilyMap().entrySet()) {
                if (entry.getKey() == null || ((byte[])entry.getKey()).length == 0) {
                    throw new IllegalArgumentException("family is empty");
                }
                for (KeyValue kv : (List)entry.getValue()) {
                    if (kv.getLength() <= this.maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.checkAndMutation(row, family, qualifier, value, (Mutation)put);
    }

    private void innerDelete(Delete delete) throws IOException {
        Preconditions.checkArgument(delete.getRow() != null, "row is null");
        Preconditions.checkArgument(!delete.isEmpty(), "delete is empty");
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        try {
            this.checkFamilyViolation(delete.getFamilyMap().keySet());
            Map.Entry entry = delete.getFamilyMap().entrySet().iterator().next();
            ObTableBatchOperation batch = this.buildObTableBatchOperation((List)entry.getValue(), false, null);
            ObTableBatchOperationRequest request = this.buildObTableBatchOperationRequest(batch, this.getTargetTableName(this.tableNameString, Bytes.toString((byte[])((byte[])entry.getKey()))));
            ObTableBatchOperationResult result = (ObTableBatchOperationResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            boolean hasError = false;
            int throwErrorCode = 0;
            for (ObTableOperationResult obTableOperationResult : result.getResults()) {
                int errorCode = obTableOperationResult.getHeader().getErrno();
                errorCodeList.add(errorCode);
                if (errorCode == 0) continue;
                hasError = true;
                throwErrorCode = errorCode;
            }
            if (hasError) {
                ExceptionUtil.throwObTableException((int)throwErrorCode);
            }
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00004"), new Object[]{this.tableNameString, errorCodeList, e});
            throw new IOException("delete  table " + this.tableNameString + " error codes " + errorCodeList, e);
        }
    }

    public void delete(Delete delete) throws IOException {
        this.checkFamilyViolation(delete.getFamilyMap().keySet());
        this.innerDelete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.innerDelete(delete);
        }
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndMutation(row, family, qualifier, value, (Mutation)delete);
    }

    private boolean checkAndMutation(byte[] row, byte[] family, byte[] qualifier, byte[] value, Mutation mutation) throws IOException {
        try {
            Preconditions.checkArgument(row != null, "row is null");
            Preconditions.checkArgument(StringUtils.isNotBlank((String)Bytes.toString((byte[])family)), "family is blank");
            Preconditions.checkArgument(Bytes.equals((byte[])row, (byte[])mutation.getRow()), "mutation row is not equal check row");
            Preconditions.checkArgument(!mutation.isEmpty(), "mutation is empty");
            String filterString = this.buildCheckAndMutateFilterString(family, qualifier, value);
            ObHTableFilter filter = this.buildObHTableFilter(filterString, null, 1, new byte[][]{qualifier});
            this.checkFamilyViolation(mutation.getFamilyMap().keySet());
            Map.Entry entry = mutation.getFamilyMap().entrySet().iterator().next();
            Preconditions.checkArgument(Arrays.equals(family, (byte[])entry.getKey()), "mutation family is not equal check family");
            ObTableQuery obTableQuery = this.buildObTableQuery(filter, row, true, row, true, -1);
            ObTableBatchOperation batch = this.buildObTableBatchOperation((List)entry.getValue(), false, null);
            ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batch, this.getTargetTableName(this.tableNameString, Bytes.toString((byte[])((byte[])entry.getKey()))));
            ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            return result.getAffectedRows() > 0L;
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00005"), new Object[]{mutation.getClass().getSimpleName(), this.tableNameString, e});
            throw new IOException("checkAndMutation type " + mutation.getClass().getSimpleName() + " table " + this.tableNameString + " error.", e);
        }
    }

    public void mutateRow(RowMutations rm) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public Result append(Append append) throws IOException {
        this.checkFamilyViolation(append.getFamilyMap().keySet());
        Preconditions.checkArgument(!append.isEmpty(), "append is empty.");
        try {
            byte[] r = append.getRow();
            Map.Entry entry = append.getFamilyMap().entrySet().iterator().next();
            byte[] f = (byte[])entry.getKey();
            ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
            ObTableBatchOperation batchOperation = this.buildObTableBatchOperation((List)entry.getValue(), true, qualifiers);
            ObHTableFilter filter = this.buildObHTableFilter(null, null, 1, qualifiers);
            ObTableQuery obTableQuery = this.buildObTableQuery(filter, r, true, r, true, -1);
            ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
            queryAndMutate.setTableQuery(obTableQuery);
            queryAndMutate.setMutations(batchOperation);
            ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batchOperation, this.getTargetTableName(this.tableNameString, Bytes.toString((byte[])f)));
            request.setReturningAffectedEntity(true);
            ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            ObTableQueryResult queryResult = result.getAffectedEntity();
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
            for (List row : queryResult.getPropertiesRows()) {
                byte[] k = (byte[])((ObObj)row.get(0)).getValue();
                byte[] q = (byte[])((ObObj)row.get(1)).getValue();
                long t = (Long)((ObObj)row.get(2)).getValue();
                byte[] v = (byte[])((ObObj)row.get(3)).getValue();
                KeyValue kv = new KeyValue(k, f, q, t, v);
                keyValues.add(kv);
            }
            return new Result(keyValues);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00006"), (Object)this.tableNameString, (Object)e);
            throw new IOException("append table " + this.tableNameString + " error.", e);
        }
    }

    public Result increment(Increment increment) throws IOException {
        this.checkFamilyViolation(increment.getFamilyMap().keySet());
        try {
            ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
            byte[] rowKey = increment.getRow();
            Map.Entry entry = increment.getFamilyMap().entrySet().iterator().next();
            byte[] f = (byte[])entry.getKey();
            ObTableBatchOperation batch = new ObTableBatchOperation();
            for (Map.Entry qualifiersIncrements : ((NavigableMap)entry.getValue()).entrySet()) {
                byte[] qualifier = (byte[])qualifiersIncrements.getKey();
                qualifiers.add(qualifier);
                batch.addTableOperation(ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.INCREMENT, (Object[])new Object[]{rowKey, qualifier, Long.MAX_VALUE}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{Bytes.toBytes((long)((Long)qualifiersIncrements.getValue()))}));
            }
            ObHTableFilter filter = this.buildObHTableFilter(null, increment.getTimeRange(), 1, qualifiers);
            ObTableQuery obTableQuery = this.buildObTableQuery(filter, rowKey, true, rowKey, true, -1);
            ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
            queryAndMutate.setMutations(batch);
            queryAndMutate.setTableQuery(obTableQuery);
            ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batch, this.getTargetTableName(this.tableNameString, Bytes.toString((byte[])f)));
            request.setReturningAffectedEntity(true);
            ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            ObTableQueryResult queryResult = result.getAffectedEntity();
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
            for (List row : queryResult.getPropertiesRows()) {
                byte[] k = (byte[])((ObObj)row.get(0)).getValue();
                byte[] q = (byte[])((ObObj)row.get(1)).getValue();
                long t = (Long)((ObObj)row.get(2)).getValue();
                byte[] v = (byte[])((ObObj)row.get(3)).getValue();
                KeyValue kv = new KeyValue(k, f, q, t, v);
                keyValues.add(kv);
            }
            return new Result(keyValues);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00007"), (Object)this.tableNameString, (Object)e);
            throw new IOException("increment table " + this.tableNameString + " error.", e);
        }
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        try {
            ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
            qualifiers.add(qualifier);
            ObTableBatchOperation batch = new ObTableBatchOperation();
            batch.addTableOperation(ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.INCREMENT, (Object[])new Object[]{row, qualifier, Long.MAX_VALUE}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{Bytes.toBytes((long)amount)}));
            ObHTableFilter filter = this.buildObHTableFilter(null, null, 1, qualifiers);
            ObTableQuery obTableQuery = this.buildObTableQuery(filter, row, true, row, true, -1);
            ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
            queryAndMutate.setMutations(batch);
            queryAndMutate.setTableQuery(obTableQuery);
            ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batch, this.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family)));
            request.setReturningAffectedEntity(true);
            ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            ObTableQueryResult queryResult = result.getAffectedEntity();
            if (queryResult.getPropertiesRows().size() != 1) {
                throw new IllegalStateException("the increment result size illegal " + queryResult.getPropertiesRows().size());
            }
            return Bytes.toLong((byte[])((byte[])((ObObj)((List)queryResult.getPropertiesRows().get(0)).get(3)).getValue()));
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00007"), (Object)this.tableNameString, (Object)e);
            throw new IOException("increment table " + this.tableNameString + " error.", e);
        }
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCommits() throws IOException {
        try {
            boolean[] resultSuccess = new boolean[this.writeBuffer.size()];
            try {
                HashMap<String, Pair> familyMap = new HashMap<String, Pair>();
                for (int i = 0; i < this.writeBuffer.size(); ++i) {
                    Put aPut = this.writeBuffer.get(i);
                    Map innerFamilyMap = aPut.getFamilyMap();
                    for (Map.Entry entry : innerFamilyMap.entrySet()) {
                        String family = Bytes.toString((byte[])((byte[])entry.getKey()));
                        Pair keyValueWithIndex = (Pair)familyMap.get(family);
                        if (keyValueWithIndex == null) {
                            keyValueWithIndex = new Pair(new ArrayList(), new ArrayList());
                            familyMap.put(family, keyValueWithIndex);
                        }
                        ((List)keyValueWithIndex.getFirst()).add(i);
                        ((List)keyValueWithIndex.getSecond()).addAll((Collection)entry.getValue());
                    }
                }
                for (Map.Entry entry : familyMap.entrySet()) {
                    ArrayList<Integer> errorCodeList = new ArrayList<Integer>(((List)((Pair)entry.getValue()).getSecond()).size());
                    try {
                        String targetTableName = this.getTargetTableName(this.tableNameString, (String)entry.getKey());
                        ObTableBatchOperation batch = this.buildObTableBatchOperation((List)((Pair)entry.getValue()).getSecond(), false, null);
                        ObTableBatchOperationRequest request = this.buildObTableBatchOperationRequest(batch, targetTableName);
                        ObTableBatchOperationResult result = (ObTableBatchOperationResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                        List obTableOperationResults = result.getResults();
                        ObTableOperationResult throwResult = null;
                        for (ObTableOperationResult obTableOperationResult : obTableOperationResults) {
                            int errorCode = obTableOperationResult.getHeader().getErrno();
                            errorCodeList.add(errorCode);
                            if (errorCode == 0) continue;
                            throwResult = obTableOperationResult;
                        }
                        for (Integer index : (List)((Pair)entry.getValue()).getFirst()) {
                            resultSuccess[index.intValue()] = throwResult == null;
                        }
                        if (throwResult == null) continue;
                        ExceptionUtil.throwObTableException((String)throwResult.getExecuteHost(), (int)throwResult.getExecutePort(), (long)throwResult.getSequence(), (long)throwResult.getUniqueId(), (int)throwResult.getHeader().getErrno(), (String)"HBase Error");
                    }
                    catch (Exception e) {
                        logger.error(TableHBaseLoggerFactory.LCD.convert("01-00008"), new Object[]{this.tableNameString, errorCodeList, this.autoFlush, this.writeBuffer.size(), e});
                        throw new IOException("put table " + this.tableNameString + " error codes " + errorCodeList + "auto flush " + this.autoFlush + " current buffer size " + this.writeBuffer.size(), e);
                    }
                }
            }
            finally {
                for (int i = resultSuccess.length - 1; i >= 0; --i) {
                    if (!resultSuccess[i]) continue;
                    this.writeBuffer.remove(i);
                }
            }
        }
        finally {
            if (this.clearBufferOnFail) {
                this.writeBuffer.clear();
                this.currentWriteBufferSize = 0L;
            } else {
                this.currentWriteBufferSize = 0L;
                for (Put aPut : this.writeBuffer) {
                    this.currentWriteBufferSize += aPut.heapSize();
                }
            }
        }
    }

    public void close() throws IOException {
        if (this.cleanupPoolOnClose) {
            this.executePool.shutdown();
        }
    }

    public RowLock lockRow(byte[] row) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public void unlockRow(RowLock rl) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public void setAutoFlush(boolean autoFlush) {
        this.setAutoFlush(autoFlush, autoFlush);
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.autoFlush = autoFlush;
        this.clearBufferOnFail = autoFlush || clearBufferOnFail;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flushCommits();
        }
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        this.operationExecuteInPool = this.configuration.getBoolean("hbase.client.operation.executeinpool", this.operationTimeout != Integer.MAX_VALUE);
    }

    public void setRuntimeBatchExecutor(ExecutorService runtimeBatchExecutor) {
        this.obTableClient.setRuntimeBatchExecutor(runtimeBatchExecutor);
    }

    <T> T executeServerCallable(ServerCallable<T> serverCallable) throws IOException {
        if (!this.operationExecuteInPool) {
            return serverCallable.withRetries();
        }
        long startTime = System.currentTimeMillis();
        Future<T> future = this.executePool.submit(serverCallable);
        try {
            return future.get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw new IOException("Interrupted");
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                IOException ie;
                Throwable rootCause = ie = (IOException)e.getCause();
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                throw ie;
            }
            throw new IOException(e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            String hostPort = "unknown";
            String regionEncodedName = "unknown";
            throw new OperationTimeoutException("Failed executing operation for table '" + Bytes.toString((byte[])this.tableName) + "' on server " + hostPort + ",region=" + regionEncodedName + ",operationTimeout=" + this.operationTimeout + ",waitTime=" + (System.currentTimeMillis() - startTime));
        }
    }

    private String getTargetTableName(String tableNameString, String familyString) {
        Preconditions.checkArgument(tableNameString != null, "tableNameString is null");
        Preconditions.checkArgument(familyString != null, "familyString is null");
        if (this.configuration.getBoolean("hbase.htable.test.load.enable", false)) {
            return this.getTestLoadTargetTableName(tableNameString, familyString);
        }
        return this.getNormalTargetTableName(tableNameString, familyString);
    }

    private String getNormalTargetTableName(String tableNameString, String familyString) {
        return tableNameString + "$" + familyString;
    }

    private String getTestLoadTargetTableName(String tableNameString, String familyString) {
        String suffix = this.configuration.get("hbase.htable.test.load.suffix", "_t");
        return tableNameString + suffix + "$" + familyString;
    }

    private ObHTableFilter buildObHTableFilter(Filter filter, TimeRange timeRange, int maxVersion, Collection<byte[]> columnQualifiers) {
        ObHTableFilter obHTableFilter = new ObHTableFilter();
        if (filter != null) {
            obHTableFilter.setFilterString(HBaseFilterUtils.toParseableString(filter));
        }
        if (timeRange != null) {
            obHTableFilter.setMaxStamp(timeRange.getMax());
            obHTableFilter.setMinStamp(timeRange.getMin());
        }
        obHTableFilter.setMaxVersions(maxVersion);
        if (columnQualifiers != null) {
            for (byte[] columnQualifier : columnQualifiers) {
                if (columnQualifier == null) {
                    obHTableFilter.addSelectColumnQualifier(new byte[0]);
                    continue;
                }
                obHTableFilter.addSelectColumnQualifier(columnQualifier);
            }
        }
        return obHTableFilter;
    }

    private String buildCheckAndMutateFilterString(byte[] family, byte[] qualifier, byte[] value) {
        if (value != null) {
            return "CheckAndMutateFilter(=, 'binary:" + Bytes.toString((byte[])value) + "', '" + Bytes.toString((byte[])family) + "', '" + (qualifier == null ? "" : Bytes.toString((byte[])qualifier)) + "', false)";
        }
        return "CheckAndMutateFilter(=, 'binary:', '" + Bytes.toString((byte[])family) + "', '" + (qualifier == null ? "" : Bytes.toString((byte[])qualifier)) + "', true)";
    }

    private ObHTableFilter buildObHTableFilter(String filterString, TimeRange timeRange, int maxVersion, byte[] ... columnQualifiers) {
        ObHTableFilter obHTableFilter = new ObHTableFilter();
        if (filterString != null) {
            obHTableFilter.setFilterString(filterString);
        }
        if (timeRange != null) {
            obHTableFilter.setMaxStamp(timeRange.getMax());
            obHTableFilter.setMinStamp(timeRange.getMin());
        }
        obHTableFilter.setMaxVersions(maxVersion);
        if (columnQualifiers != null) {
            for (byte[] columnQualifier : columnQualifiers) {
                if (columnQualifier == null) {
                    obHTableFilter.addSelectColumnQualifier(new byte[0]);
                    continue;
                }
                obHTableFilter.addSelectColumnQualifier(columnQualifier);
            }
        }
        return obHTableFilter;
    }

    private ObTableQuery buildObTableQuery(ObHTableFilter filter, byte[] start, boolean includeStart, byte[] stop, boolean includeStop, int batchSize) {
        ObNewRange obNewRange = new ObNewRange();
        if (Arrays.equals(start, HConstants.EMPTY_BYTE_ARRAY)) {
            obNewRange.setStartKey(ObRowKey.getInstance((ObObj[])new ObObj[]{ObObj.getMin(), ObObj.getMin(), ObObj.getMin()}));
        } else if (includeStart) {
            obNewRange.setStartKey(ObRowKey.getInstance((Object[])new Object[]{start, ObObj.getMin(), ObObj.getMin()}));
        } else {
            obNewRange.setStartKey(ObRowKey.getInstance((Object[])new Object[]{start, ObObj.getMax(), ObObj.getMax()}));
        }
        if (Arrays.equals(stop, HConstants.EMPTY_BYTE_ARRAY)) {
            obNewRange.setEndKey(ObRowKey.getInstance((ObObj[])new ObObj[]{ObObj.getMax(), ObObj.getMax(), ObObj.getMax()}));
        } else if (includeStop) {
            obNewRange.setEndKey(ObRowKey.getInstance((Object[])new Object[]{stop, ObObj.getMax(), ObObj.getMax()}));
        } else {
            obNewRange.setEndKey(ObRowKey.getInstance((Object[])new Object[]{stop, ObObj.getMin(), ObObj.getMin()}));
        }
        return this.buildObTableQuery(filter, obNewRange, batchSize);
    }

    private ObTableQuery buildObTableQuery(ObHTableFilter filter, ObNewRange obNewRange, int batchSize) {
        ObTableQuery obTableQuery = new ObTableQuery();
        obTableQuery.setIndexName("PRIMARY");
        obTableQuery.sethTableFilter(filter);
        for (String column : OHConstants.ALL_COLUMNS) {
            obTableQuery.addSelectColumn(column);
        }
        if (obNewRange != null) {
            obTableQuery.addKeyRange(obNewRange);
        }
        if (batchSize > 0) {
            obTableQuery.setBatchSize(batchSize);
        }
        return obTableQuery;
    }

    private ObTableBatchOperation buildObTableBatchOperation(List<KeyValue> keyValueList, boolean putToAppend, List<byte[]> qualifiers) {
        ObTableBatchOperation batch = new ObTableBatchOperation();
        for (KeyValue kv : keyValueList) {
            if (qualifiers != null) {
                qualifiers.add(kv.getQualifier());
            }
            batch.addTableOperation(this.buildObTableOperation(kv, putToAppend));
        }
        batch.setSameType(true);
        batch.setSamePropertiesNames(true);
        return batch;
    }

    private ObTableOperation buildObTableOperation(KeyValue kv, boolean putToAppend) {
        KeyValue.Type kvType = KeyValue.Type.codeToType((byte)kv.getType());
        switch (kvType) {
            case Put: {
                ObTableOperationType operationType = putToAppend ? ObTableOperationType.APPEND : ObTableOperationType.INSERT_OR_UPDATE;
                return ObTableOperation.getInstance((ObTableOperationType)operationType, (Object[])new Object[]{kv.getRow(), kv.getQualifier(), kv.getTimestamp()}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{kv.getValue()});
            }
            case Delete: {
                return ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (Object[])new Object[]{kv.getRow(), kv.getQualifier(), kv.getTimestamp()}, null, null);
            }
            case DeleteColumn: {
                return ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (Object[])new Object[]{kv.getRow(), kv.getQualifier(), -kv.getTimestamp()}, null, null);
            }
            case DeleteFamily: {
                return ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (Object[])new Object[]{kv.getRow(), null, -kv.getTimestamp()}, null, null);
            }
        }
        throw new IllegalArgumentException("illegal mutation type " + kvType);
    }

    private ObTableQueryRequest buildObTableQueryRequest(ObTableQuery obTableQuery, String targetTableName) {
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setEntityType(ObTableEntityType.HKV);
        request.setTableQuery(obTableQuery);
        request.setTableName(targetTableName);
        return request;
    }

    private ObTableQueryAsyncRequest buildObTableQueryAsyncRequest(ObTableQuery obTableQuery, String targetTableName) {
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setEntityType(ObTableEntityType.HKV);
        request.setTableQuery(obTableQuery);
        request.setTableName(targetTableName);
        ObTableQueryAsyncRequest asyncRequest = new ObTableQueryAsyncRequest();
        asyncRequest.setEntityType(ObTableEntityType.HKV);
        asyncRequest.setTableName(targetTableName);
        asyncRequest.setObTableQueryRequest(request);
        return asyncRequest;
    }

    private ObTableBatchOperationRequest buildObTableBatchOperationRequest(ObTableBatchOperation obTableBatchOperation, String targetTableName) {
        ObTableBatchOperationRequest request = new ObTableBatchOperationRequest();
        request.setTableName(targetTableName);
        request.setReturningAffectedRows(true);
        request.setEntityType(ObTableEntityType.HKV);
        request.setBatchOperation(obTableBatchOperation);
        return request;
    }

    private ObTableQueryAndMutateRequest buildObTableQueryAndMutateRequest(ObTableQuery obTableQuery, ObTableBatchOperation obTableBatchOperation, String targetTableName) {
        ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
        queryAndMutate.setTableQuery(obTableQuery);
        queryAndMutate.setMutations(obTableBatchOperation);
        ObTableQueryAndMutateRequest request = new ObTableQueryAndMutateRequest();
        request.setTableName(targetTableName);
        request.setTableQueryAndMutate(queryAndMutate);
        request.setEntityType(ObTableEntityType.HKV);
        request.setReturningAffectedEntity(true);
        return request;
    }

    private void checkFamilyViolation(Collection<byte[]> families) {
        if (families == null || families.size() == 0) {
            throw new FeatureNotSupportedException("family is empty.");
        }
        if (families.size() > 1) {
            throw new FeatureNotSupportedException("multi family is not supported yet.");
        }
        for (byte[] family : families) {
            if (!StringUtils.isBlank((String)Bytes.toString((byte[])family))) continue;
            throw new IllegalArgumentException("family is blank");
        }
    }

    public void refreshTableEntry(String familyString, boolean hasTestLoad) throws Exception {
        if (this.obTableClient.isOdpMode()) {
            return;
        }
        this.obTableClient.getOrRefreshTableEntry(this.getNormalTargetTableName(this.tableNameString, familyString), true, true);
        if (hasTestLoad) {
            this.obTableClient.getOrRefreshTableEntry(this.getTestLoadTargetTableName(this.tableNameString, familyString), true, true);
        }
    }

    public byte[][] getStartKeys() throws IOException {
        Object startKeys = new byte[][]{};
        try {
            startKeys = this.obTableClient.getHBaseTableStartKeys(this.tableNameString);
        }
        catch (Exception e) {
            throw new IOException("Fail to get start keys of HBase Table: " + this.tableNameString, e);
        }
        return startKeys;
    }

    public byte[][] getEndKeys() throws IOException {
        Object endKeys = new byte[][]{};
        try {
            endKeys = this.obTableClient.getHBaseTableEndKeys(this.tableNameString);
        }
        catch (Exception e) {
            throw new IOException("Fail to get start keys of HBase Table: " + this.tableNameString, e);
        }
        return endKeys;
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return new Pair((Object)this.getStartKeys(), (Object)this.getEndKeys());
    }
}

