/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.util.RandomUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;

public class ObHashPartDesc
extends ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObHashPartDesc.class);
    private List<Long> completeWorks;
    private int partSpace = 0;
    private int partNum = 0;

    public ObHashPartDesc() {
        this.setPartFuncType(ObPartFuncType.HASH);
    }

    public int getPartSpace() {
        return this.partSpace;
    }

    public void setPartSpace(int partSpace) {
        this.partSpace = partSpace;
    }

    @Override
    public int getPartNum() {
        return this.partNum;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
        ArrayList<Long> partIds = new ArrayList<Long>();
        for (long i = 0L; i < (long)partNum; ++i) {
            partIds.add(i);
        }
        this.completeWorks = Collections.unmodifiableList(partIds);
    }

    @Override
    public void prepare() {
        super.prepare();
    }

    @Override
    public List<Long> getPartIds(Object[] start, boolean startInclusive, Object[] end, boolean endInclusive) {
        try {
            List<Object> startValues = this.evalRowKeyValues(start);
            Object startValue = startValues.get(0);
            List<Object> endValues = this.evalRowKeyValues(end);
            Object endValue = endValues.get(0);
            Long startLongValue = ObObjType.parseToLongOrNull(startValue);
            Long endLongValue = ObObjType.parseToLongOrNull(endValue);
            if (startLongValue == null || endLongValue == null) {
                throw new NumberFormatException("can not parseToComparable start value [" + startValue + "] or end value [" + endValue + "] to long");
            }
            long startHashValue = startLongValue - (long)(startInclusive ? 0 : -1);
            long endHashValue = endLongValue - (long)(endInclusive ? 0 : 1);
            if (endHashValue - startHashValue + 1L >= (long)this.partNum) {
                return this.completeWorks;
            }
            ArrayList<Long> partIds = new ArrayList<Long>();
            for (long i = startHashValue; i <= endHashValue; ++i) {
                partIds.add(this.innerHash(i));
            }
            return partIds;
        }
        catch (IllegalArgumentException e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00002"), (Throwable)e);
            throw new IllegalArgumentException("ObHashPartDesc get part id come across illegal params", e);
        }
    }

    @Override
    public Long getRandomPartId() {
        return this.partNum > 0 ? Long.valueOf(RandomUtil.getRandomNum(0, this.partNum)) : null;
    }

    @Override
    public Long getPartId(Object ... rowKey) {
        ArrayList<Object[]> rowKeys = new ArrayList<Object[]>();
        rowKeys.add(rowKey);
        return this.getPartId(rowKeys, false);
    }

    @Override
    public Long getPartId(List<Object[]> rowKeys, boolean consistency) {
        if (rowKeys == null || rowKeys.size() == 0) {
            throw new IllegalArgumentException("invalid row keys :" + rowKeys);
        }
        Long partId = null;
        try {
            for (Object[] rowKey : rowKeys) {
                List<Object> evalValues = this.evalRowKeyValues(rowKey);
                Object value = evalValues.get(0);
                Long longValue = ObObjType.parseToLongOrNull(value);
                if (longValue == null) {
                    throw new IllegalArgumentException("can not parseToComparable value [" + value + "] to long");
                }
                long currentPartId = this.innerHash(longValue);
                if (partId == null) {
                    partId = currentPartId;
                }
                if (!consistency) break;
                if (partId.equals(currentPartId)) continue;
                throw new ObTablePartitionConsistentException("across partition operation may cause consistent problem " + rowKeys);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("ObHashPartDesc get part id come across illegal params", e);
        }
        return partId;
    }

    private Long innerHash(long hashValue) {
        hashValue = Math.abs(hashValue);
        return (long)(this.partSpace << 28) | hashValue % (long)this.partNum;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("partSpace", this.partSpace).append("partNum", this.partNum).append("partFuncType", (Object)this.getPartFuncType()).append("partExpr", (Object)this.getPartExpr()).toString();
    }
}

