/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.location.model.ObReadConsistency;
import com.alipay.oceanbase.rpc.location.model.ObRoutePolicy;
import com.alipay.oceanbase.rpc.location.model.ObServerLdcLocation;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.ReplicaLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ObPartitionLocation {
    private ReplicaLocation leader;
    private List<ReplicaLocation> replicas = new ArrayList<ReplicaLocation>(3);
    private List<ReplicaLocation> sameIdc = new ArrayList<ReplicaLocation>();
    private List<ReplicaLocation> sameRegion = new ArrayList<ReplicaLocation>();
    private List<ReplicaLocation> otherRegion = new ArrayList<ReplicaLocation>();

    public ReplicaLocation getLeader() {
        return this.leader;
    }

    public List<ReplicaLocation> getReplicas() {
        return this.replicas;
    }

    public List<ReplicaLocation> getSameIdc() {
        return this.sameIdc;
    }

    public List<ReplicaLocation> getSameRegion() {
        return this.sameRegion;
    }

    public List<ReplicaLocation> getOtherRegion() {
        return this.otherRegion;
    }

    public void addReplicaLocation(ReplicaLocation replica) {
        if (replica.isLeader()) {
            this.leader = replica;
        }
        this.replicas.add(replica);
    }

    public ReplicaLocation getReplica(ObServerRoute route) {
        if (route.getReadConsistency() == ObReadConsistency.STRONG) {
            return this.leader;
        }
        if (route.isLdcEnabled()) {
            return this.getReadReplicaByLDC(route);
        }
        return this.getReadReplicaNoLdc(route);
    }

    public ReplicaLocation getReadReplicaByLDC(ObServerRoute route) {
        if (route.getReadRoutePolicy() == ObRoutePolicy.FOLLOWER_FIRST && !route.isInBlackList(this.leader.getIp())) {
            route.addToBlackList(this.leader.getIp());
        }
        for (ReplicaLocation r : this.sameIdc) {
            if (route.isInBlackList(r.getAddr().getIp())) continue;
            return r;
        }
        for (ReplicaLocation r : this.sameRegion) {
            if (route.isInBlackList(r.getAddr().getIp())) continue;
            return r;
        }
        for (ReplicaLocation r : this.otherRegion) {
            if (route.isInBlackList(r.getAddr().getIp())) continue;
            return r;
        }
        return this.leader;
    }

    public ReplicaLocation getReadReplicaNoLdc(ObServerRoute route) {
        for (ReplicaLocation r : this.replicas) {
            if (route.isInBlackList(r.getIp()) || r.isLeader() && route.getReadRoutePolicy() == ObRoutePolicy.FOLLOWER_FIRST) continue;
            return r;
        }
        return this.leader;
    }

    public void prepareForWeakRead(ObServerLdcLocation ldcLocation) {
        Collections.shuffle(this.replicas);
        if (ldcLocation != null && ldcLocation.isLdcUsed()) {
            for (ReplicaLocation replica : this.replicas) {
                if (ldcLocation.inSameIDC(replica.getIp())) {
                    this.sameIdc.add(replica);
                    continue;
                }
                if (ldcLocation.inSameRegion(replica.getIp())) {
                    this.sameRegion.add(replica);
                    continue;
                }
                this.otherRegion.add(replica);
            }
        }
    }

    public String toString() {
        return "ObPartitionLocation{leader=" + this.leader + ", replicas=" + this.replicas + ", sameIdc=" + this.sameIdc + ", sameRegion=" + this.sameRegion + ", otherRegion=" + this.otherRegion + '}';
    }
}

