/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl;

import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObObjMeta
implements ObSimplePayload {
    private ObObjType type;
    private ObCollationLevel csLevel;
    private ObCollationType csType;
    private byte scale;

    public ObObjMeta() {
    }

    public ObObjMeta(ObObjType type, ObCollationLevel csLevel, ObCollationType csType, byte scale) {
        this.type = type;
        this.csLevel = csLevel;
        this.csType = csType;
        this.scale = scale;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[this.getEncodedSize()];
        int idx = 0;
        System.arraycopy(Serialization.encodeI8(this.type.getByteValue()), 0, bytes, idx, 1);
        System.arraycopy(Serialization.encodeI8(this.csLevel.getByteValue()), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.csType.getByteValue()), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.scale), 0, bytes, ++idx, 1);
        return bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeI8(buf, this.type.getByteValue());
        Serialization.encodeI8(buf, this.csLevel.getByteValue());
        Serialization.encodeI8(buf, this.csType.getByteValue());
        Serialization.encodeI8(buf, this.scale);
    }

    @Override
    public Object decode(ByteBuf buf) {
        this.type = ObObjType.valueOf(Serialization.decodeI8(buf.readByte()));
        this.csLevel = ObCollationLevel.valueOf(Serialization.decodeI8(buf.readByte()));
        this.csType = ObCollationType.valueOf(Serialization.decodeI8(buf.readByte()));
        this.scale = Serialization.decodeI8(buf.readByte());
        return this;
    }

    @Override
    public int getEncodedSize() {
        return 4;
    }

    public ObObjType getType() {
        return this.type;
    }

    public void setType(ObObjType type) {
        this.type = type;
    }

    public ObCollationLevel getCsLevel() {
        return this.csLevel;
    }

    public void setCsLevel(ObCollationLevel csLevel) {
        this.csLevel = csLevel;
    }

    public ObCollationType getCsType() {
        return this.csType;
    }

    public void setCsType(ObCollationType csType) {
        this.csType = csType;
    }

    public byte getScale() {
        return this.scale;
    }

    public void setScale(byte scale) {
        this.scale = scale;
    }

    public String toString() {
        return "ObObjMeta{type=" + (Object)((Object)this.type) + ", csLevel=" + (Object)((Object)this.csLevel) + ", csType=" + (Object)((Object)this.csType) + ", scale=" + this.scale + '}';
    }
}

