/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl;

import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjMeta;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.ObVString;
import com.alipay.oceanbase.rpc.util.Serialization;
import com.alipay.oceanbase.rpc.util.TimeUtils;
import io.netty.buffer.ByteBuf;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

public enum ObObjType {
    ObNullType(0){

        @Override
        public byte[] encode(Object obj) {
            return new byte[0];
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return null;
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 0;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_IGNORABLE, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return null;
        }
    }
    ,
    ObTinyIntType(1){

        @Override
        public byte[] encode(Object obj) {
            if (obj instanceof Boolean) {
                return new byte[]{(Boolean)obj != false ? (byte)1 : 0};
            }
            return new byte[]{(Byte)obj};
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeI8(buf.readByte());
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 1;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Byte parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            Long value = 2.parseToLongOrNull(o);
            if (value != null && value >= -128L && value <= 127L) {
                return value.byteValue();
            }
            throw new IllegalArgumentException("ObTinyIntType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObSmallIntType(2){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi32(((Number)obj).intValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return (short)Serialization.decodeVi32(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).intValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Short parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            Long value = 3.parseToLongOrNull(o);
            if (value != null && value >= -32768L && value <= 32767L) {
                return value.shortValue();
            }
            throw new IllegalArgumentException("ObSmallIntType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObMediumIntType(3){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi32(((Number)obj).intValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi32(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).intValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Integer parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObMediumIntType is not supported.");
        }
    }
    ,
    ObInt32Type(4){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi32(((Number)obj).intValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi32(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).intValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Integer parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            Long value = 5.parseToLongOrNull(o);
            if (value != null && value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                return value.intValue();
            }
            throw new IllegalArgumentException("ObInt32Type can not parseToComparable argument:" + o);
        }
    }
    ,
    ObInt64Type(5){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi64(((Number)obj).longValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi64(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).longValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Long parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 6.parseLong(this, o, ct);
        }
    }
    ,
    ObUTinyIntType(6){

        @Override
        public byte[] encode(Object obj) {
            return new byte[]{(Byte)obj};
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeI8(buf.readByte());
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 1;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Short parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            Long value = 7.parseToLongOrNull(o);
            if (value != null && value >= 0L && value <= 255L) {
                return value.shortValue();
            }
            throw new IllegalArgumentException("ObUTinyIntType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObUSmallIntType(7){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi32(((Number)obj).intValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi32(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).intValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Integer parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            Long smallIntValue = 8.parseToLongOrNull(o);
            if (smallIntValue != null && smallIntValue >= 0L && smallIntValue <= 65535L) {
                return smallIntValue.intValue();
            }
            throw new IllegalArgumentException("ObUSmallIntType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObUMediumIntType(8){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi32(((Number)obj).intValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi32(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).intValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Integer parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            Long mediumIntValue = 9.parseToLongOrNull(o);
            if (mediumIntValue != null && mediumIntValue >= 0L && mediumIntValue <= 0xFFFFFFL) {
                return mediumIntValue.intValue();
            }
            throw new IllegalArgumentException("ObUMediumIntType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObUInt32Type(9){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi32(((Number)obj).intValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi32(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).intValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, -1);
        }

        @Override
        public Long parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            Long value = 10.parseToLongOrNull(o);
            if (value != null && value >= 0L && value <= 0xFFFFFFFFL) {
                return value;
            }
            throw new IllegalArgumentException("ObUInt32Type can not parseToComparable argument:" + o);
        }
    }
    ,
    ObUInt64Type(10){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi64(((Number)obj).longValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi64(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).longValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Long parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 11.parseLong(this, o, ct);
        }
    }
    ,
    ObFloatType(11){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeFloat(((Float)obj).floatValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Float.valueOf(Serialization.decodeFloat(buf));
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Float)obj).floatValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Float parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            if (o instanceof Float) {
                return (Float)o;
            }
            if (o instanceof String) {
                return Float.valueOf((String)o);
            }
            if (o instanceof ObVString) {
                return Float.valueOf(((ObVString)o).getStringVal());
            }
            throw new IllegalArgumentException("ObFloatType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObDoubleType(12){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeDouble((Double)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeDouble(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes((Double)obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Double parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            if (o instanceof Double) {
                return (Double)o;
            }
            if (o instanceof String) {
                return Double.valueOf((String)o);
            }
            if (o instanceof ObVString) {
                return Double.valueOf(((ObVString)o).getStringVal());
            }
            throw new IllegalArgumentException("ObDoubleType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObUFloatType(13){

        @Override
        public byte[] encode(Object obj) {
            return new byte[0];
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return null;
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 0;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Float parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObUFloatType is not supported .");
        }
    }
    ,
    ObUDoubleType(14){

        @Override
        public byte[] encode(Object obj) {
            return new byte[0];
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return null;
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 0;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Double parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObUDoubleType is not supported.");
        }
    }
    ,
    ObNumberType(15){

        @Override
        public byte[] encode(Object obj) {
            return new byte[0];
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return null;
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 0;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObNumberType is not supported .");
        }
    }
    ,
    ObUNumberType(16){

        @Override
        public byte[] encode(Object obj) {
            return new byte[0];
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return null;
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 0;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObUNumberType is not supported .");
        }
    }
    ,
    ObDateTimeType(17){

        @Override
        public byte[] encode(Object obj) {
            long targetTs = ((java.util.Date)obj).getTime() + (long)OffsetDateTime.now().getOffset().getTotalSeconds() * 1000L;
            return Serialization.encodeVi64(targetTs * 1000L);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return new java.util.Date(Serialization.decodeVi64(buf) / 1000L - (long)OffsetDateTime.now().getOffset().getTotalSeconds() * 1000L);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((java.util.Date)obj).getTime() * 1000L);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Timestamp parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 18.parseTimestamp(this, o, ct);
        }
    }
    ,
    ObTimestampType(18){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi64(((java.util.Date)obj).getTime() * 1000L);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return new Timestamp(Serialization.decodeVi64(buf) / 1000L);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((java.util.Date)obj).getTime() * 1000L);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Timestamp parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 19.parseTimestamp(this, o, ct);
        }
    }
    ,
    ObDateType(19){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi32((int)((java.util.Date)obj).getTime());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return new java.util.Date((long)Serialization.decodeVi32(buf) * 1000L);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes((int)((java.util.Date)obj).getTime());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public java.util.Date parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            if (o instanceof java.util.Date) {
                return (java.util.Date)o;
            }
            if (o instanceof String) {
                return TimeUtils.strToDate((String)o);
            }
            if (o instanceof ObVString) {
                return TimeUtils.strToDate(((ObVString)o).getStringVal());
            }
            if (o instanceof Long) {
                return new java.util.Date((Long)o);
            }
            throw new IllegalArgumentException("ObDateType can not parseToComparable argument:" + o);
        }
    }
    ,
    ObTimeType(20){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi64((int)((java.util.Date)obj).getTime());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return new Timestamp(Serialization.decodeVi64(buf));
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes((int)((java.util.Date)obj).getTime());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Timestamp parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObTimeType is not supported .");
        }
    }
    ,
    ObYearType(21){

        @Override
        public byte[] encode(Object obj) {
            return new byte[]{(Byte)obj};
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeI8(buf.readByte());
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 1;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObYearType is not supported .");
        }
    }
    ,
    ObVarcharType(22){

        @Override
        public byte[] encode(Object obj) {
            if (obj instanceof byte[]) {
                ObBytesString bytesString = new ObBytesString((byte[])obj);
                return Serialization.encodeBytesString(bytesString);
            }
            if (obj instanceof ObVString) {
                return ((ObVString)obj).getEncodeBytes();
            }
            return Serialization.encodeVString((String)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return this.decodeText(buf, type);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 23.getTextEncodedSize(obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_EXPLICIT, ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 23.parseTextToComparable(this, o, ct);
        }
    }
    ,
    ObCharType(23){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVString((String)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return this.decodeText(buf, type);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 24.getTextEncodedSize(obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_EXPLICIT, ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 24.parseTextToComparable(this, o, ct);
        }
    }
    ,
    ObHexStringType(24){

        @Override
        public byte[] encode(Object obj) {
            return new byte[0];
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return null;
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 0;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        public String parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObHexStringType is not supported .");
        }
    }
    ,
    ObExtendType(25){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi64((Long)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi64(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes((Long)obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObUnknownType is not supported .");
        }
    }
    ,
    ObUnknownType(26){

        @Override
        public byte[] encode(Object obj) {
            return new byte[0];
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return null;
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 0;
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            throw new FeatureNotSupportedException("ObUnknownType is not supported .");
        }
    }
    ,
    ObTinyTextType(27){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVString((String)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return this.decodeText(buf, type);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 28.getTextEncodedSize(obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 28.parseTextToComparable(this, o, ct);
        }
    }
    ,
    ObTextType(28){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVString((String)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return this.decodeText(buf, type);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 29.getTextEncodedSize(obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) throws IllegalArgumentException, FeatureNotSupportedException {
            return 29.parseTextToComparable(this, o, ct);
        }
    }
    ,
    ObMediumTextType(29){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVString((String)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return this.decodeText(buf, type);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 30.getTextEncodedSize(obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) {
            return 30.parseTextToComparable(this, o, ct);
        }
    }
    ,
    ObLongTextType(30){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVString((String)obj);
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return this.decodeText(buf, type);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return 31.getTextEncodedSize(obj);
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) {
            return 31.parseTextToComparable(this, o, ct);
        }
    }
    ,
    ObBitType(31){

        @Override
        public byte[] encode(Object obj) {
            return Serialization.encodeVi64(((Number)obj).longValue());
        }

        @Override
        public Object decode(ByteBuf buf, ObCollationType type) {
            return Serialization.decodeVi64(buf);
        }

        @Override
        public int getEncodedSize(Object obj) {
            return Serialization.getNeedBytes(((Number)obj).longValue());
        }

        @Override
        public ObObjMeta getDefaultObjMeta() {
            return new ObObjMeta(this, ObCollationLevel.CS_LEVEL_NUMERIC, ObCollationType.CS_TYPE_BINARY, 10);
        }

        @Override
        public Comparable parseToComparable(Object o, ObCollationType ct) {
            throw new FeatureNotSupportedException("ObBitType is not supported .");
        }
    };

    private int value;
    private static Map<Integer, ObObjType> map;

    private ObObjType(int value) {
        this.value = value;
    }

    public static ObObjMeta defaultObjMeta(Object object) {
        return ObObjType.valueOfType(object).getDefaultObjMeta();
    }

    public static ObObjType valueOfType(Object object) {
        if (object == null) {
            return ObNullType;
        }
        if (object instanceof Boolean) {
            return ObTinyIntType;
        }
        if (object instanceof Byte) {
            return ObTinyIntType;
        }
        if (object instanceof Short) {
            return ObSmallIntType;
        }
        if (object instanceof Integer) {
            return ObInt32Type;
        }
        if (object instanceof Long) {
            return ObInt64Type;
        }
        if (object instanceof String) {
            return ObVarcharType;
        }
        if (object instanceof byte[]) {
            return ObVarcharType;
        }
        if (object instanceof ObVString) {
            return ObVarcharType;
        }
        if (object instanceof Double) {
            return ObDoubleType;
        }
        if (object instanceof Float) {
            return ObFloatType;
        }
        if (object instanceof Timestamp) {
            return ObTimestampType;
        }
        if (object instanceof Date) {
            return ObDateTimeType;
        }
        if (object instanceof java.util.Date) {
            return ObDateTimeType;
        }
        if (object instanceof ObObj) {
            return ((ObObj)object).getMeta().getType();
        }
        throw new IllegalArgumentException("cannot get ObObjType, invalid object type: " + object.getClass().getName());
    }

    public static ObObjType valueOf(int value) {
        return map.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public byte getByteValue() {
        return (byte)this.value;
    }

    public abstract byte[] encode(Object var1);

    public abstract Object decode(ByteBuf var1, ObCollationType var2);

    public abstract int getEncodedSize(Object var1);

    public abstract ObObjMeta getDefaultObjMeta();

    public abstract Comparable parseToComparable(Object var1, ObCollationType var2) throws IllegalArgumentException, FeatureNotSupportedException;

    public static Long parseToLongOrNull(Object object) {
        Long value = null;
        if (object instanceof String) {
            value = Long.valueOf((String)object);
        } else if (object instanceof ObVString) {
            value = Long.valueOf(((ObVString)object).getStringVal());
        } else if (object instanceof Long) {
            value = (Long)object;
        } else if (object instanceof Integer) {
            value = (long)((Integer)object);
        } else if (object instanceof Short) {
            value = (long)((Short)object);
        } else if (object instanceof Byte) {
            value = (long)((Byte)object);
        }
        return value;
    }

    public Object decodeText(ByteBuf buf, ObCollationType type) {
        if (ObCollationType.CS_TYPE_BINARY.equals((Object)type)) {
            return Serialization.decodeBytesString((ByteBuf)buf).bytes;
        }
        return Serialization.decodeVString(buf);
    }

    public static int getTextEncodedSize(Object obj) {
        if (obj instanceof byte[]) {
            ObBytesString bytesString = new ObBytesString((byte[])obj);
            return Serialization.getNeedBytes(bytesString);
        }
        if (obj instanceof ObVString) {
            return ((ObVString)obj).getEncodeNeedBytes();
        }
        return Serialization.getNeedBytes((String)obj);
    }

    public static Comparable parseTextToComparable(ObObjType obObjType, Object object, ObCollationType collationType) {
        if (collationType == ObCollationType.CS_TYPE_BINARY) {
            if (object instanceof ObBytesString) {
                return (ObBytesString)object;
            }
            if (object instanceof byte[]) {
                return new ObBytesString((byte[])object);
            }
            if (object instanceof String) {
                return new ObBytesString((String)object);
            }
            if (object instanceof ObVString) {
                return new ObBytesString(((ObVString)object).getBytesVal());
            }
        } else {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof ObBytesString) {
                return Serialization.decodeVString(((ObBytesString)object).bytes);
            }
            if (object instanceof byte[]) {
                try {
                    return Serialization.decodeVString((byte[])object);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(obObjType.name() + "can not parseToComparable byte array to string with utf-8 charset", e);
                }
            }
            if (object instanceof ObVString) {
                return ((ObVString)object).getStringVal();
            }
        }
        throw new IllegalArgumentException(obObjType.name() + "can not parseToComparable argument:" + object);
    }

    public static Timestamp parseTimestamp(ObObjType obObjType, Object object, ObCollationType collationType) {
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof String) {
            return TimeUtils.strToTimestamp((String)object);
        }
        if (object instanceof ObVString) {
            return TimeUtils.strToTimestamp(((ObVString)object).getStringVal());
        }
        if (object instanceof Long) {
            return new Timestamp((Long)object);
        }
        throw new IllegalArgumentException(obObjType.name() + "can not parseToComparable with " + (Object)((Object)collationType) + "argument:" + object);
    }

    public static Long parseLong(ObObjType obObjType, Object object, ObCollationType collationType) {
        Long value = ObObjType.parseToLongOrNull(object);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("ObUInt64Type can not parseToComparable argument:" + object);
    }

    static {
        map = new HashMap<Integer, ObObjType>();
        for (ObObjType type : ObObjType.values()) {
            map.put(type.value, type);
        }
    }
}

