/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObAddr;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadOperationType;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableDirectLoadResult
extends AbstractPayload {
    private Header header = new Header();
    private ObBytesString resContent = new ObBytesString();

    public ObTableDirectLoadResult() {
        this.setVersion(2L);
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public ObBytesString getResContent() {
        return this.resContent;
    }

    public void setResContent(ObBytesString resContent) {
        if (resContent == null) {
            throw new NullPointerException();
        }
        this.resContent = resContent;
    }

    @Override
    public int getPcode() {
        return 4387;
    }

    @Override
    public byte[] encode() {
        long payloadContentSize = this.getPayloadContentSize();
        int needBytes = (int)(Serialization.getObUniVersionHeaderLength(this.getVersion(), payloadContentSize) + payloadContentSize);
        ObByteBuf buf = new ObByteBuf(needBytes);
        Serialization.encodeObUniVersionHeader(buf, this.getVersion(), payloadContentSize);
        this.header.encode(buf);
        Serialization.encodeBytesString(buf, this.resContent);
        return buf.bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.header.decode(buf);
        this.resContent = Serialization.decodeBytesString(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return this.header.getEncodedSize() + Serialization.getNeedBytes(this.resContent);
    }

    public static class Header
    implements ObSimplePayload {
        private ObAddr addr = new ObAddr();
        private ObTableDirectLoadOperationType operationType = ObTableDirectLoadOperationType.MAX_TYPE;

        public ObAddr getAddr() {
            return this.addr;
        }

        public void setAddr(ObAddr addr) {
            this.addr = addr;
        }

        public ObTableDirectLoadOperationType getOperationType() {
            return this.operationType;
        }

        public void setOperationType(ObTableDirectLoadOperationType operationType) {
            this.operationType = operationType;
        }

        @Override
        public byte[] encode() {
            int needBytes = this.getEncodedSize();
            ObByteBuf buf = new ObByteBuf(needBytes);
            this.encode(buf);
            return buf.bytes;
        }

        @Override
        public void encode(ObByteBuf buf) {
            this.addr.encode(buf);
            Serialization.encodeI8(buf, this.operationType.getByteValue());
        }

        @Override
        public Header decode(ByteBuf buf) {
            this.addr = new ObAddr();
            this.addr.decode(buf);
            this.operationType = ObTableDirectLoadOperationType.valueOf(Serialization.decodeI8(buf));
            return this;
        }

        @Override
        public int getEncodedSize() {
            return this.addr.getEncodedSize() + 1;
        }
    }
}

