/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObITableEntity;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public abstract class AbstractObTableEntity
extends AbstractPayload
implements ObITableEntity {
    private long version = 1L;

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        long rowkeySize = this.getRowKeySize();
        int len = Serialization.getNeedBytes(rowkeySize);
        System.arraycopy(Serialization.encodeVi64(rowkeySize), 0, bytes, idx += headerLen, len);
        idx += len;
        int i = 0;
        while ((long)i < rowkeySize) {
            ObObj obObj = this.getRowKeyValue(i);
            byte[] objBytes = obObj.encode();
            System.arraycopy(objBytes, 0, bytes, idx, objBytes.length);
            idx += objBytes.length;
            ++i;
        }
        long propertiesCount = this.getPropertiesCount();
        len = Serialization.getNeedBytes(propertiesCount);
        System.arraycopy(Serialization.encodeVi64(propertiesCount), 0, bytes, idx, len);
        idx += len;
        Map<String, ObObj> properties = this.getProperties();
        for (Map.Entry<String, ObObj> entry : properties.entrySet()) {
            String name = entry.getKey();
            ObObj property = entry.getValue();
            int keyLen = Serialization.getNeedBytes(name);
            System.arraycopy(Serialization.encodeVString(name), 0, bytes, idx, keyLen);
            byte[] objBytes = property.encode();
            System.arraycopy(objBytes, 0, bytes, idx += keyLen, objBytes.length);
            idx += objBytes.length;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        long rowkeySize = Serialization.decodeVi64(buf);
        for (long i = 0L; i < rowkeySize; ++i) {
            ObObj obj = new ObObj();
            this.addRowKeyValue(obj.decode(buf));
        }
        long propertiesCount = Serialization.decodeVi64(buf);
        int i = 0;
        while ((long)i < propertiesCount) {
            String name = Serialization.decodeVString(buf);
            ObObj property = new ObObj();
            this.setProperty(name, property.decode(buf));
            ++i;
        }
        return this;
    }

    @Override
    public long getPayloadSize() {
        long contentSize = this.getPayloadContentSize();
        return Serialization.getObUniVersionHeaderLength(this.getVersion(), contentSize) + contentSize;
    }

    @Override
    public long getPayloadContentSize() {
        int size = Serialization.getNeedBytes(this.getRowKeySize()) + Serialization.getNeedBytes(this.getPropertiesCount());
        for (long i = 0L; i < this.getRowKeySize(); ++i) {
            size += this.getRowKeyValue(i).getEncodedSize();
        }
        for (Map.Entry<String, ObObj> entry : this.getProperties().entrySet()) {
            size += Serialization.getNeedBytes(entry.getKey());
            size += entry.getValue().getEncodedSize();
        }
        return size;
    }
}

