/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.location.model.ObReadConsistency;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableStreamRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.QueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObQueryOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractQueryStreamResult
extends AbstractPayload
implements QueryStreamResult {
    private ReentrantLock lock = new ReentrantLock();
    private volatile boolean initialized = false;
    private volatile boolean closed = false;
    protected volatile List<ObObj> row = null;
    protected volatile int rowIndex = -1;
    protected ObTableQuery tableQuery;
    protected long operationTimeout = -1L;
    protected String tableName;
    protected ObTableEntityType entityType;
    private Map<Long, ObPair<Long, ObTableParam>> expectant;
    private List<String> cacheProperties = new LinkedList<String>();
    private LinkedList<List<ObObj>> cacheRows = new LinkedList();
    private LinkedList<ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>> partitionLastResult = new LinkedList();
    private ObReadConsistency readConsistency = ObReadConsistency.STRONG;

    @Override
    public int getPcode() {
        return 4356;
    }

    @Override
    public byte[] encode() {
        throw new FeatureNotSupportedException("stream result can not decode from bytes");
    }

    @Override
    public Object decode(ByteBuf buf) {
        throw new FeatureNotSupportedException("stream result can not decode from bytes");
    }

    @Override
    public long getPayloadContentSize() {
        throw new FeatureNotSupportedException("stream result has no pay load size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws Exception {
        this.checkStatus();
        this.lock.lock();
        try {
            ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult> referLastResult;
            if (this.cacheRows.size() > 0) {
                this.nextRow();
                boolean bl = true;
                return bl;
            }
            while ((referLastResult = this.partitionLastResult.poll()) != null) {
                ObTableQueryResult lastResult = referLastResult.getRight();
                if (!lastResult.isStream() || !lastResult.isStreamNext()) continue;
                ObTableQueryResult tableQueryResult = this.referToLastStreamResult(referLastResult.getLeft(), lastResult);
                if (tableQueryResult.getRowCount() == 0L) continue;
                this.nextRow();
                boolean bl = true;
                return bl;
            }
            boolean hasNext = false;
            ArrayList<Map.Entry<Long, ObPair<Long, ObTableParam>>> referPartition = new ArrayList<Map.Entry<Long, ObPair<Long, ObTableParam>>>();
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : this.expectant.entrySet()) {
                referPartition.add(entry);
                ObTableQueryResult tableQueryResult = this.referToNewPartition(entry.getValue());
                if (tableQueryResult.getRowCount() == 0L) continue;
                hasNext = true;
                this.nextRow();
                break;
            }
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : referPartition) {
                this.expectant.remove(entry.getKey());
            }
            boolean bl = hasNext;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void nextRow() {
        ++this.rowIndex;
        this.row = this.cacheRows.poll();
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("table " + this.tableName + "query stream result is not initialized");
        }
        if (this.closed) {
            throw new IllegalStateException("table " + this.tableName + " query stream result is  closed");
        }
    }

    protected ObTableQueryResult checkObTableQueryResult(Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableQueryResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName() + "expect " + ObTableQueryResult.class.getName());
        }
        return (ObTableQueryResult)result;
    }

    protected ObTableQueryAsyncResult checkObTableQuerySyncResult(Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableQueryAsyncResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName() + "expect " + ObTableQueryAsyncResult.class.getName());
        }
        return (ObTableQueryAsyncResult)result;
    }

    private ObTableQueryResult referToLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult lastResult) throws Exception {
        ObTableStreamRequest streamRequest = new ObTableStreamRequest();
        streamRequest.setSessionId(lastResult.getSessionId());
        streamRequest.setStreamNext();
        if (this.operationTimeout > 0L) {
            streamRequest.setTimeout(this.operationTimeout);
        } else {
            streamRequest.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        return this.execute(partIdWithObTable, streamRequest);
    }

    private void closeLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult lastResult) throws Exception {
        ObTableStreamRequest streamRequest = new ObTableStreamRequest();
        streamRequest.setSessionId(lastResult.getSessionId());
        streamRequest.setStreamLast();
        if (this.operationTimeout > 0L) {
            streamRequest.setTimeout(this.operationTimeout);
        } else {
            streamRequest.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        partIdWithObTable.getRight().getObTable().execute(streamRequest);
    }

    private ObTableQueryResult referToNewPartition(ObPair<Long, ObTableParam> partIdWithObTable) throws Exception {
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setTableName(this.tableName);
        request.setTableQuery(this.tableQuery);
        request.setPartitionId(partIdWithObTable.getRight().getPartitionId());
        request.setTableId(partIdWithObTable.getRight().getTableId());
        request.setEntityType(this.entityType);
        if (this.operationTimeout > 0L) {
            request.setTimeout(this.operationTimeout);
        } else {
            request.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        request.setConsistencyLevel(this.getReadConsistency().toObTableConsistencyLevel());
        return this.execute(partIdWithObTable, request);
    }

    private ObTableQueryAsyncResult referToNewPartition(ObPair<Long, ObTableParam> partIdWithObTable, ObQueryOperationType type, long sessionID) throws Exception {
        ObTableQueryAsyncRequest asyncRequest = new ObTableQueryAsyncRequest();
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setTableName(this.tableName);
        request.setTableQuery(this.tableQuery);
        request.setPartitionId(partIdWithObTable.getRight().getPartitionId());
        request.setTableId(partIdWithObTable.getRight().getTableId());
        request.setEntityType(this.entityType);
        asyncRequest.setObTableQueryRequest(request);
        asyncRequest.setQueryType(type);
        asyncRequest.setQuerySessionId(sessionID);
        if (this.operationTimeout > 0L) {
            asyncRequest.setTimeout(this.operationTimeout);
        } else {
            asyncRequest.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        return this.executeAsync(partIdWithObTable, asyncRequest);
    }

    protected abstract ObTableQueryResult execute(ObPair<Long, ObTableParam> var1, ObPayload var2) throws Exception;

    protected abstract ObTableQueryAsyncResult executeAsync(ObPair<Long, ObTableParam> var1, ObPayload var2) throws Exception;

    private void cacheResultRows(ObTableQueryResult tableQueryResult) {
        this.cacheRows.addAll(tableQueryResult.getPropertiesRows());
        this.cacheProperties = tableQueryResult.getPropertiesNames();
    }

    protected void cacheStreamNext(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult tableQueryResult) {
        this.cacheResultRows(tableQueryResult);
        if (tableQueryResult.isStream() && tableQueryResult.isStreamNext()) {
            this.partitionLastResult.addLast(new ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>(partIdWithObTable, tableQueryResult));
        }
    }

    private void cacheResultRows(ObTableQueryAsyncResult tableQuerySyncResult) {
        this.cacheRows.addAll(tableQuerySyncResult.getAffectedEntity().getPropertiesRows());
        this.cacheProperties = tableQuerySyncResult.getAffectedEntity().getPropertiesNames();
    }

    protected void cacheStreamNext(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryAsyncResult tableQuerySyncResult) {
        this.cacheResultRows(tableQuerySyncResult);
        if (tableQuerySyncResult.getAffectedEntity().isStream() && tableQuerySyncResult.getAffectedEntity().isStreamNext()) {
            this.partitionLastResult.addLast(new ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>(partIdWithObTable, tableQuerySyncResult.getAffectedEntity()));
        }
    }

    @Override
    public List<ObObj> getRow() {
        if (this.rowIndex == -1) {
            throw new IllegalStateException("before result set start");
        }
        return this.row;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.tableQuery.getBatchSize() == -1) {
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : this.expectant.entrySet()) {
                this.referToNewPartition(entry.getValue());
            }
        } else {
            throw new ObTableException("query not support BatchSize, use queryByBatch / queryByBatchV2 instead, BatchSize:" + this.tableQuery.getBatchSize());
        }
        this.expectant.clear();
        this.initialized = true;
    }

    public void init(ObQueryOperationType type, long sessionID) throws Exception {
        if (this.initialized) {
            return;
        }
        for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : this.expectant.entrySet()) {
            this.referToNewPartition(entry.getValue(), type, sessionID);
        }
        this.expectant.clear();
        this.initialized = true;
    }

    public void init(ObQueryOperationType type, ObPair<Long, ObTableParam> entry, long sessionID) throws Exception {
        if (this.initialized) {
            return;
        }
        this.referToNewPartition(entry, type, sessionID);
        this.expectant.clear();
        this.initialized = true;
    }

    @Override
    public void close() throws Exception {
        ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult> referLastResult;
        if (this.closed) {
            return;
        }
        this.closed = true;
        while ((referLastResult = this.partitionLastResult.poll()) != null) {
            ObTableQueryResult lastResult = referLastResult.getRight();
            this.closeLastStreamResult(referLastResult.getLeft(), lastResult);
        }
    }

    @Override
    public List<String> getCacheProperties() {
        return this.cacheProperties;
    }

    @Override
    public LinkedList<List<ObObj>> getCacheRows() {
        return this.cacheRows;
    }

    public LinkedList<ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>> getPartitionLastResult() {
        return this.partitionLastResult;
    }

    public ObTableQuery getTableQuery() {
        return this.tableQuery;
    }

    public void setTableQuery(ObTableQuery tableQuery) {
        this.tableQuery = tableQuery;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ObTableEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(ObTableEntityType entityType) {
        this.entityType = entityType;
    }

    public Map<Long, ObPair<Long, ObTableParam>> getExpectant() {
        return this.expectant;
    }

    public void setExpectant(Map<Long, ObPair<Long, ObTableParam>> expectant) {
        this.expectant = expectant;
    }

    public ObReadConsistency getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ObReadConsistency readConsistency) {
        this.readConsistency = readConsistency;
    }
}

