/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObBorderFlag;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObNewRange
implements ObSimplePayload {
    private long tableId = -1L;
    private ObBorderFlag borderFlag = new ObBorderFlag();
    private ObRowKey startKey;
    private ObRowKey endKey;
    private long flag = 0L;

    public ObNewRange() {
        this.borderFlag.setInclusiveStart();
        this.borderFlag.setInclusiveEnd();
    }

    @Override
    public byte[] encode() {
        byte[] objBytes;
        ObObj obObj;
        byte[] bytes = new byte[this.getEncodedSize()];
        int idx = 0;
        int len = Serialization.getNeedBytes(this.tableId);
        System.arraycopy(Serialization.encodeVi64(this.tableId), 0, bytes, idx, len);
        System.arraycopy(Serialization.encodeI8(this.borderFlag.getValue()), 0, bytes, idx += len, 1);
        long rowkeySize = this.startKey.getObjCount();
        len = Serialization.getNeedBytes(rowkeySize);
        System.arraycopy(Serialization.encodeVi64(rowkeySize), 0, bytes, ++idx, len);
        idx += len;
        int i = 0;
        while ((long)i < rowkeySize) {
            obObj = this.startKey.getObj(i);
            objBytes = obObj.encode();
            System.arraycopy(objBytes, 0, bytes, idx, objBytes.length);
            idx += objBytes.length;
            ++i;
        }
        rowkeySize = this.endKey.getObjCount();
        len = Serialization.getNeedBytes(rowkeySize);
        System.arraycopy(Serialization.encodeVi64(rowkeySize), 0, bytes, idx, len);
        idx += len;
        i = 0;
        while ((long)i < rowkeySize) {
            obObj = this.endKey.getObj(i);
            objBytes = obObj.encode();
            System.arraycopy(objBytes, 0, bytes, idx, objBytes.length);
            idx += objBytes.length;
            ++i;
        }
        if (ObGlobal.obVsnMajor() >= 4) {
            len = Serialization.getNeedBytes(this.flag);
            System.arraycopy(Serialization.encodeVi64(this.flag), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeVi64(buf, this.tableId);
        Serialization.encodeI8(buf, this.borderFlag.getValue());
        long startKeyObjCount = this.startKey.getObjCount();
        Serialization.encodeVi64(buf, startKeyObjCount);
        int i = 0;
        while ((long)i < startKeyObjCount) {
            this.startKey.getObj(i).encode(buf);
            ++i;
        }
        long endKeyObjCount = this.endKey.getObjCount();
        Serialization.encodeVi64(buf, endKeyObjCount);
        int i2 = 0;
        while ((long)i2 < endKeyObjCount) {
            this.endKey.getObj(i2).encode(buf);
            ++i2;
        }
        if (ObGlobal.obVsnMajor() >= 4) {
            Serialization.encodeVi64(buf, this.flag);
        }
    }

    @Override
    public Object decode(ByteBuf buf) {
        ObObj obObj;
        this.tableId = Serialization.decodeVi64(buf);
        this.borderFlag = ObBorderFlag.valueOf(Serialization.decodeI8(buf.readByte()));
        long rowkeySize = Serialization.decodeVi64(buf);
        this.startKey = new ObRowKey();
        int i = 0;
        while ((long)i < rowkeySize) {
            obObj = new ObObj();
            obObj.decode(buf);
            this.startKey.addObj(obObj);
            ++i;
        }
        rowkeySize = Serialization.decodeVi64(buf);
        this.endKey = new ObRowKey();
        i = 0;
        while ((long)i < rowkeySize) {
            obObj = new ObObj();
            obObj.decode(buf);
            this.endKey.addObj(obObj);
            ++i;
        }
        if (ObGlobal.obVsnMajor() >= 4) {
            this.flag = Serialization.decodeVi64(buf);
        }
        return this;
    }

    @Override
    public int getEncodedSize() {
        ObObj obObj;
        int encodedSize = 0;
        encodedSize += Serialization.getNeedBytes(this.tableId);
        ++encodedSize;
        long rowkeySize = this.startKey.getObjCount();
        encodedSize += Serialization.getNeedBytes(rowkeySize);
        int i = 0;
        while ((long)i < rowkeySize) {
            obObj = this.startKey.getObj(i);
            encodedSize += obObj.getEncodedSize();
            ++i;
        }
        rowkeySize = this.endKey.getObjCount();
        encodedSize += Serialization.getNeedBytes(rowkeySize);
        i = 0;
        while ((long)i < rowkeySize) {
            obObj = this.endKey.getObj(i);
            encodedSize += obObj.getEncodedSize();
            ++i;
        }
        if (ObGlobal.obVsnMajor() >= 4) {
            encodedSize += Serialization.getNeedBytes(this.flag);
        }
        return encodedSize;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public ObBorderFlag getBorderFlag() {
        return this.borderFlag;
    }

    public void setBorderFlag(ObBorderFlag borderFlag) {
        this.borderFlag = borderFlag;
    }

    public ObRowKey getStartKey() {
        return this.startKey;
    }

    public void setStartKey(ObRowKey startKey) {
        this.startKey = startKey;
    }

    public ObRowKey getEndKey() {
        return this.endKey;
    }

    public void setEndKey(ObRowKey endKey) {
        this.endKey = endKey;
    }

    public static ObNewRange getWholeRange() {
        ObNewRange range = new ObNewRange();
        range.startKey = ObRowKey.getInstance(ObObj.getMin());
        range.endKey = ObRowKey.getInstance(ObObj.getMax());
        range.borderFlag.unsetInclusiveStart();
        range.borderFlag.unsetInclusiveEnd();
        return range;
    }
}

