/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.table.ConcurrentTask;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConcurrentTaskExecutor {
    private final CountDownLatch taskCountDownLatch;
    private final AtomicBoolean stopped;
    private final ExecutorService executor;
    private final List<Throwable> throwableList = Collections.synchronizedList(new LinkedList());

    public ConcurrentTaskExecutor(ExecutorService executor, int taskNum) {
        this.taskCountDownLatch = new CountDownLatch(taskNum);
        this.stopped = new AtomicBoolean(false);
        this.executor = executor;
    }

    public void execute(ConcurrentTask task) {
        task.init(this.stopped, this.taskCountDownLatch);
        this.executor.execute(task);
    }

    public boolean isComplete() {
        return this.taskCountDownLatch.getCount() == 0L;
    }

    public boolean waitComplete(long timeout, TimeUnit unit) throws InterruptedException {
        return this.taskCountDownLatch.await(timeout, unit);
    }

    public void stop() {
        this.stopped.compareAndSet(false, true);
    }

    public void collectExceptions(Throwable e) {
        this.throwableList.add(e);
    }

    public List<Throwable> getThrowableList() {
        return this.throwableList;
    }
}

