/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObBorderFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObQueryOperationType;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.stream.async.ObTableClientQueryAsyncStreamResult;
import com.alipay.oceanbase.rpc.stream.async.ObTableQueryAsyncClientResultSet;
import com.alipay.oceanbase.rpc.table.AbstractTableQueryImpl;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObTableClientQueryAsyncImpl
extends AbstractTableQueryImpl {
    private final String tableName;
    private final ObTableClient obTableClient;
    private long sessionId;
    private Map<Long, ObPair<Long, ObTableParam>> partitionObTables;
    private boolean hasMore;

    public ObTableClientQueryAsyncImpl(String tableName, ObTableClient client) {
        this.tableName = tableName;
        this.obTableClient = client;
        this.tableQuery = new ObTableQuery();
    }

    public ObTableClientQueryAsyncImpl(String tableName, ObTableQuery tableQuery, ObTableClient client) {
        this.tableName = tableName;
        this.obTableClient = client;
        this.tableQuery = tableQuery;
    }

    @Override
    public ObTableQuery getObTableQuery() {
        return this.tableQuery;
    }

    public TableQuery getTableQuery() {
        return this;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public QueryResultSet execute() throws Exception {
        return new QueryResultSet(new ObTableQueryAsyncClientResultSet(this));
    }

    public QueryResultSet execute(ObQueryOperationType type, ObPair<Long, ObTableParam> entry) throws Exception {
        ObTableClientQueryAsyncStreamResult obTableClientQueryAsyncStreamResult = this.executeInternal(type, entry);
        QueryResultSet queryResultSet = new QueryResultSet(obTableClientQueryAsyncStreamResult);
        queryResultSet.setHasMore(obTableClientQueryAsyncStreamResult.hasMore());
        queryResultSet.setSessionId(obTableClientQueryAsyncStreamResult.getSessionId());
        return queryResultSet;
    }

    @Override
    public QueryResultSet executeInit(ObPair<Long, ObTableParam> entry) throws Exception {
        return this.execute(ObQueryOperationType.QUERY_START, entry);
    }

    @Override
    public QueryResultSet executeNext(ObPair<Long, ObTableParam> entry) throws Exception {
        return this.execute(ObQueryOperationType.QUERY_NEXT, entry);
    }

    @Override
    public TableQuery setKeys(String ... keys) {
        throw new IllegalArgumentException("Not needed");
    }

    @Override
    public void clear() {
    }

    public ObTableClientQueryAsyncStreamResult executeInternal(ObQueryOperationType type) throws Exception {
        Map<Long, ObPair<Long, ObTableParam>> partitionObTables = this.getPartitions();
        ObTableClientQueryAsyncStreamResult obTableClientQueryASyncStreamResult = new ObTableClientQueryAsyncStreamResult();
        obTableClientQueryASyncStreamResult.setTableQuery(this.tableQuery);
        obTableClientQueryASyncStreamResult.setEntityType(this.entityType);
        obTableClientQueryASyncStreamResult.setTableName(this.tableName);
        obTableClientQueryASyncStreamResult.setExpectant(partitionObTables);
        obTableClientQueryASyncStreamResult.setOperationTimeout(this.operationTimeout);
        obTableClientQueryASyncStreamResult.setClient(this.obTableClient);
        obTableClientQueryASyncStreamResult.init(type, this.sessionId);
        QueryResultSet querySyncResultSet = new QueryResultSet(obTableClientQueryASyncStreamResult);
        this.hasMore = !obTableClientQueryASyncStreamResult.isEnd();
        querySyncResultSet.setHasMore(this.hasMore);
        obTableClientQueryASyncStreamResult.setHasMore(this.hasMore);
        querySyncResultSet.setSessionId(obTableClientQueryASyncStreamResult.getSessionId());
        this.sessionId = obTableClientQueryASyncStreamResult.getSessionId();
        return obTableClientQueryASyncStreamResult;
    }

    public ObTableClientQueryAsyncStreamResult executeInternal(ObQueryOperationType type, ObPair<Long, ObTableParam> entry) throws Exception {
        ObTableClientQueryAsyncStreamResult obTableClientQueryASyncStreamResult = new ObTableClientQueryAsyncStreamResult();
        obTableClientQueryASyncStreamResult.setTableQuery(this.tableQuery);
        obTableClientQueryASyncStreamResult.setEntityType(this.entityType);
        obTableClientQueryASyncStreamResult.setTableName(this.tableName);
        obTableClientQueryASyncStreamResult.setExpectant(this.partitionObTables);
        obTableClientQueryASyncStreamResult.setOperationTimeout(this.operationTimeout);
        obTableClientQueryASyncStreamResult.setClient(this.obTableClient);
        obTableClientQueryASyncStreamResult.init(type, entry, this.sessionId);
        QueryResultSet querySyncResultSet = new QueryResultSet(obTableClientQueryASyncStreamResult);
        this.hasMore = !obTableClientQueryASyncStreamResult.isEnd();
        querySyncResultSet.setHasMore(this.hasMore);
        obTableClientQueryASyncStreamResult.setHasMore(this.hasMore);
        querySyncResultSet.setSessionId(obTableClientQueryASyncStreamResult.getSessionId());
        this.sessionId = obTableClientQueryASyncStreamResult.getSessionId();
        return obTableClientQueryASyncStreamResult;
    }

    public Map<Long, ObPair<Long, ObTableParam>> getPartitions() throws Exception {
        this.partitionObTables = new HashMap<Long, ObPair<Long, ObTableParam>>();
        for (ObNewRange rang : this.tableQuery.getKeyRanges()) {
            int i;
            ObRowKey startKey = rang.getStartKey();
            int startKeySize = startKey.getObjs().size();
            ObRowKey endKey = rang.getEndKey();
            int endKeySize = endKey.getObjs().size();
            Object[] start = new Object[startKeySize];
            Object[] end = new Object[endKeySize];
            for (i = 0; i < startKeySize; ++i) {
                start[i] = startKey.getObj(i).getValue();
            }
            for (i = 0; i < endKeySize; ++i) {
                end[i] = endKey.getObj(i).getValue();
            }
            ObBorderFlag borderFlag = rang.getBorderFlag();
            List<ObPair<Long, ObTableParam>> pairs = this.obTableClient.getTables(this.tableName, start, borderFlag.isInclusiveStart(), end, borderFlag.isInclusiveEnd(), false, false);
            for (ObPair<Long, ObTableParam> pair : pairs) {
                this.partitionObTables.put(pair.getLeft(), pair);
            }
        }
        return this.partitionObTables;
    }

    public long getSessionId() {
        return this.sessionId;
    }
}

