/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObBorderFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.table.AbstractTableQueryImpl;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import com.alipay.oceanbase.rpc.util.MonitorUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObTableClientQueryImpl
extends AbstractTableQueryImpl {
    private final String tableName;
    private final ObTableClient obTableClient;
    private Row rowKey;

    public void addAggregation(ObTableAggregationType aggType, String aggColumn) {
        this.tableQuery.addAggregation(aggType, aggColumn);
    }

    public ObTableClientQueryImpl() {
        this.tableName = null;
        this.obTableClient = null;
        this.tableQuery = new ObTableQuery();
        this.rowKey = null;
    }

    public ObTableClientQueryImpl(String tableName, ObTableClient client) {
        this.tableName = tableName;
        this.obTableClient = client;
        this.tableQuery = new ObTableQuery();
        this.rowKey = null;
    }

    public ObTableClientQueryImpl(String tableName, ObTableQuery tableQuery, ObTableClient client) {
        this.tableName = tableName;
        this.obTableClient = client;
        this.tableQuery = tableQuery;
        this.rowKey = null;
    }

    @Override
    public QueryResultSet execute() throws Exception {
        return new QueryResultSet(this.executeInternal());
    }

    @Override
    public QueryResultSet executeInit(ObPair<Long, ObTableParam> entry) throws Exception {
        throw new IllegalArgumentException("not support executeInit");
    }

    @Override
    public QueryResultSet executeNext(ObPair<Long, ObTableParam> entry) throws Exception {
        throw new IllegalArgumentException("not support executeInit");
    }

    @Override
    public TableQuery setKeys(String ... keys) {
        throw new IllegalArgumentException("Not needed");
    }

    @Override
    public TableQuery setRowKey(Row rowKey) throws Exception {
        this.rowKey = rowKey;
        return this;
    }

    public ObTableClientQueryStreamResult executeInternal() throws Exception {
        if (null == this.obTableClient) {
            throw new ObTableException("table client is null");
        }
        long startTime = System.currentTimeMillis();
        HashMap<Long, ObPair<Long, ObTableParam>> partitionObTables = new HashMap<Long, ObPair<Long, ObTableParam>>();
        if (this.tableQuery.getKeyRanges().isEmpty()) {
            this.tableQuery.addKeyRange(ObNewRange.getWholeRange());
        }
        if (this.obTableClient.isOdpMode()) {
            if (this.tableQuery.getScanRangeColumns().isEmpty() && this.tableQuery.getIndexName() != null && !this.tableQuery.getIndexName().equalsIgnoreCase("primary")) {
                throw new ObTableException("key range columns must be specified when use index");
            }
            partitionObTables.put(0L, new ObPair<Long, ObTableParam>(0L, new ObTableParam(this.obTableClient.getOdpTable())));
        } else {
            for (ObNewRange obNewRange : this.tableQuery.getKeyRanges()) {
                int i;
                ObRowKey obRowKey = obNewRange.getStartKey();
                int startKeySize = obRowKey.getObjs().size();
                ObRowKey endKey = obNewRange.getEndKey();
                int endKeySize = endKey.getObjs().size();
                Object[] start = new Object[startKeySize];
                Object[] end = new Object[endKeySize];
                for (i = 0; i < startKeySize; ++i) {
                    start[i] = obRowKey.getObj(i).getValue();
                }
                for (i = 0; i < endKeySize; ++i) {
                    end[i] = endKey.getObj(i).getValue();
                }
                ObBorderFlag borderFlag = obNewRange.getBorderFlag();
                List<ObPair<Long, ObTableParam>> pairs = this.obTableClient.getTables(this.tableName, start, borderFlag.isInclusiveStart(), end, borderFlag.isInclusiveEnd(), false, false, this.obTableClient.getReadRoute());
                for (ObPair<Long, ObTableParam> pair : pairs) {
                    partitionObTables.put(pair.getLeft(), pair);
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : partitionObTables.entrySet()) {
            stringBuilder.append("#").append(((ObTableParam)((ObPair)entry.getValue()).getRight()).getObTable().getIp()).append(":").append(((ObTableParam)((ObPair)entry.getValue()).getRight()).getObTable().getPort());
        }
        String string = stringBuilder.toString();
        long l = System.currentTimeMillis();
        if (this.tableQuery.isAggregation() && partitionObTables.size() > 1) {
            throw new ObTableException("Not supported aggregate of multiple partitions, the partition size is: " + partitionObTables.size(), ResultCodes.OB_NOT_SUPPORTED.errorCode);
        }
        ObTableClientQueryStreamResult obTableClientQueryStreamResult = new ObTableClientQueryStreamResult();
        obTableClientQueryStreamResult.setTableQuery(this.tableQuery);
        obTableClientQueryStreamResult.setEntityType(this.entityType);
        obTableClientQueryStreamResult.setTableName(this.tableName);
        obTableClientQueryStreamResult.setExpectant(partitionObTables);
        obTableClientQueryStreamResult.setClient(this.obTableClient);
        obTableClientQueryStreamResult.setOperationTimeout(this.operationTimeout);
        obTableClientQueryStreamResult.setReadConsistency(this.obTableClient.getReadConsistency());
        obTableClientQueryStreamResult.init();
        MonitorUtil.info((ObPayload)obTableClientQueryStreamResult, this.obTableClient.getDatabase(), this.tableName, "QUERY", string, this.tableQuery, obTableClientQueryStreamResult, l - startTime, System.currentTimeMillis() - l, this.obTableClient.getslowQueryMonitorThreshold());
        return obTableClientQueryStreamResult;
    }

    @Override
    public void clear() {
        this.tableQuery = new ObTableQuery();
    }

    @Override
    public ObTableQuery getObTableQuery() {
        return this.tableQuery;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Row getRowKey() {
        return this.rowKey;
    }
}

